/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullComparisonExpressionStateObject
extends AbstractStateObject {
    private boolean not;
    private StateObject stateObject;
    public static String NOT_PROPERTY = "not";
    public static final String STATE_OBJECT_PROPERTY = "stateObject";

    public NullComparisonExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public NullComparisonExpressionStateObject(StateObject parent, boolean not, StateObject stateObject) {
        super(parent);
        this.not = not;
        this.stateObject = this.parent(stateObject);
    }

    public NullComparisonExpressionStateObject(StateObject parent, boolean not, String path) {
        super(parent);
        this.not = not;
        this.parse(path);
    }

    public NullComparisonExpressionStateObject(StateObject parent, StateObject stateObject) {
        this(parent, false, stateObject);
    }

    public NullComparisonExpressionStateObject(StateObject parent, String path) {
        super(parent);
        this.parse(path);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.stateObject != null) {
            children.add(this.stateObject);
        }
    }

    public NullComparisonExpressionStateObject addNot() {
        if (!this.not) {
            this.setNot(true);
        }
        return this;
    }

    @Override
    public NullComparisonExpression getExpression() {
        return (NullComparisonExpression)super.getExpression();
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public boolean hasNot() {
        return this.not;
    }

    public boolean hasStateObject() {
        return this.stateObject != null;
    }

    private void parse(String path) {
        Object stateObject = this.buildStateObject(path, "pre_literal");
        this.setStateObject((StateObject)stateObject);
    }

    public void removeNot() {
        if (this.not) {
            this.setNot(false);
        }
    }

    public void setExpression(NullComparisonExpression expression) {
        super.setExpression(expression);
    }

    public void setNot(boolean not) {
        boolean oldNot = this.not;
        this.not = not;
        this.firePropertyChanged(NOT_PROPERTY, oldNot, not);
    }

    public void setStateObject(StateObject stateObject) {
        StateObject oldStateObject = this.stateObject;
        this.stateObject = this.parent(stateObject);
        this.firePropertyChanged(STATE_OBJECT_PROPERTY, oldStateObject, stateObject);
    }

    public void toggleNot() {
        this.setNot(!this.not);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.stateObject != null) {
            this.stateObject.toString(writer);
            writer.append(' ');
        }
        if (this.not) {
            writer.append("IS NOT NULL");
        } else {
            writer.append("IS NULL");
        }
    }
}

