/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.metadata;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.jpa.metadata.MetadataSourceAdapter;
import org.eclipse.persistence.logging.SessionLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMetadataSource
extends MetadataSourceAdapter {
    public Reader getEntityMappingsReader(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        InputStreamReader reader = null;
        String mappingURLName = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.metadata-source.xml.url", properties);
        if (mappingURLName != null && mappingURLName.length() != 0) {
            try {
                URL url = new URL(mappingURLName);
                reader = new InputStreamReader(url.openStream());
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        if (reader == null) {
            String mappingFileName = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.metadata-source.xml.file", properties);
            try {
                Enumeration<URL> mappingFileURLs = classLoader.getResources(mappingFileName);
                if (!mappingFileURLs.hasMoreElements()) {
                    mappingFileURLs = classLoader.getResources("/./" + mappingFileName);
                }
                if (mappingFileURLs.hasMoreElements()) {
                    URL nextURL = mappingFileURLs.nextElement();
                    if (mappingFileURLs.hasMoreElements()) {
                        log.logThrowable(2, (Throwable)ValidationException.nonUniqueRepositoryFileName((String)mappingFileName));
                    }
                    reader = new InputStreamReader(nextURL.openStream());
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        if (reader == null) {
            throw ValidationException.missingXMLMetadataRepositoryConfig();
        }
        return reader;
    }

    @Override
    public XMLEntityMappings getEntityMappings(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        XMLEntityMappings xMLEntityMappings;
        block8: {
            Reader reader = this.getEntityMappingsReader(properties, classLoader, log);
            if (reader == null) {
                return null;
            }
            try {
                xMLEntityMappings = XMLEntityMappingsReader.read(this.getRepositoryName(), reader, classLoader, properties);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return xMLEntityMappings;
    }

    public String getRepositoryName() {
        return this.getClass().getSimpleName();
    }
}

