/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class NameAndTypeConstant
extends Constant {
    private short nameIndex;
    private short descriptorIndex;

    NameAndTypeConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.nameIndex = stream.readU2();
        this.descriptorIndex = stream.readU2();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" name: ");
        writer.print(this.name());
        writer.print("  descriptor: ");
        writer.println(this.descriptor());
    }

    public String description() {
        return "name & type";
    }

    public String name() {
        return this.utf8String(this.nameIndex);
    }

    public String descriptor() {
        return this.utf8String(this.descriptorIndex);
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public Object value() {
        return this.name() + ':' + this.descriptor();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

