/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

public class CompositeListIterator
implements ListIterator {
    private ListIterator iterators;
    private ListIterator nextIterator;
    private int nextIndex;
    private boolean nextReturned;
    private ListIterator lastIteratorToReturnElement;

    public CompositeListIterator(List iterators) {
        this(iterators.listIterator());
    }

    public CompositeListIterator(ListIterator iterators) {
        this.iterators = iterators;
        this.nextIndex = 0;
        this.nextReturned = false;
    }

    public CompositeListIterator(Object object, ListIterator iterator) {
        this((ListIterator)new SingleElementListIterator(object), iterator);
    }

    public CompositeListIterator(ListIterator iterator, Object object) {
        this(iterator, (ListIterator)new SingleElementListIterator(object));
    }

    public CompositeListIterator(ListIterator iterator1, ListIterator iterator2) {
        this(CompositeListIterator.buildIterators(iterator1, iterator2));
    }

    public CompositeListIterator(ListIterator iterator1, ListIterator iterator2, ListIterator iterator3) {
        this(CompositeListIterator.buildIterators(iterator1, iterator2, iterator3));
    }

    public CompositeListIterator(ListIterator[] iterators) {
        this(new ArrayListIterator(iterators));
    }

    private static ListIterator buildIterators(ListIterator iterator1, ListIterator iterator2) {
        ArrayList<ListIterator> list = new ArrayList<ListIterator>(2);
        list.add(iterator1);
        list.add(iterator2);
        return list.listIterator();
    }

    private static ListIterator buildIterators(ListIterator iterator1, ListIterator iterator2, ListIterator iterator3) {
        ArrayList<ListIterator> list = new ArrayList<ListIterator>(3);
        list.add(iterator1);
        list.add(iterator2);
        list.add(iterator3);
        return list.listIterator();
    }

    public void add(Object o) {
        this.checkNextIterator();
        this.nextIterator.add(o);
        ++this.nextIndex;
    }

    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    public Object next() {
        this.loadNextIterator();
        Object result = this.nextIterator.next();
        this.lastIteratorToReturnElement = this.nextIterator;
        ++this.nextIndex;
        this.nextReturned = true;
        return result;
    }

    public int nextIndex() {
        return this.nextIndex;
    }

    public Object previous() {
        this.loadPreviousIterator();
        Object result = this.nextIterator.previous();
        this.lastIteratorToReturnElement = this.nextIterator;
        --this.nextIndex;
        this.nextReturned = false;
        return result;
    }

    public int previousIndex() {
        return this.nextIndex - 1;
    }

    public void remove() {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.remove();
        if (this.nextReturned) {
            --this.nextIndex;
        }
    }

    public void set(Object o) {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.set(o);
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = (ListIterator)this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = (ListIterator)this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = (ListIterator)this.iterators.next();
        }
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.iterators + ')';
    }
}

