/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.XMLProcessor;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextFactory {
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    public static final String DEFAULT_TARGET_NAMESPACE_KEY = "defaultTargetNamespace";
    public static final String ANNOTATION_HELPER_KEY = "annotationHelper";
    public static final String PKG_SEPARATOR = ".";

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0) {
            loader = classesToBeBound[0].getClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Type[] types = new Type[classesToBeBound.length];
        System.arraycopy(classesToBeBound, 0, types, 0, classesToBeBound.length);
        return JAXBContextFactory.createContext(types, properties, classLoader);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        JAXBContext.ContextPathInput contextInput = new JAXBContext.ContextPathInput(contextPath, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        HashMap<Type, TypeMappingInfo> typeToTypeMappingInfo = new HashMap<Type, TypeMappingInfo>();
        TypeMappingInfo[] typeMappingInfo = new TypeMappingInfo[typesToBeBound.length];
        int i = 0;
        while (i < typesToBeBound.length) {
            TypeMappingInfo tmi = new TypeMappingInfo();
            tmi.setType(typesToBeBound[i]);
            typeToTypeMappingInfo.put(typesToBeBound[i], tmi);
            typeMappingInfo[i] = tmi;
            ++i;
        }
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(typeMappingInfo, properties, classLoader);
        context.setTypeToTypeMappingInfo(typeToTypeMappingInfo);
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(TypeMappingInfo[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        JAXBContext.TypeMappingInfoInput contextInput = new JAXBContext.TypeMappingInfoInput(typesToBeBound, properties, classLoader);
        JAXBContext context = new JAXBContext(contextInput);
        if (context.isRefreshable()) {
            context.postInitialize();
        }
        return context;
    }

    public static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        Object value;
        Map<String, List<XmlBindings>> bindings = new HashMap<String, List<XmlBindings>>();
        if (properties != null && (value = properties.get(ECLIPSELINK_OXM_XML_KEY)) != null) {
            if (value instanceof Map) {
                Map metadataFiles = null;
                try {
                    metadataFiles = (Map)properties.get(ECLIPSELINK_OXM_XML_KEY);
                }
                catch (ClassCastException classCastException) {
                    throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                }
                if (metadataFiles != null) {
                    for (Map.Entry entry : metadataFiles.entrySet()) {
                        String key = null;
                        ArrayList<XmlBindings> xmlBindings = new ArrayList<XmlBindings>();
                        try {
                            key = (String)entry.getKey();
                            if (key == null) {
                                throw org.eclipse.persistence.exceptions.JAXBException.nullMapKey();
                            }
                        }
                        catch (ClassCastException classCastException) {
                            throw org.eclipse.persistence.exceptions.JAXBException.incorrectKeyParameterType();
                        }
                        Object metadataSource = entry.getValue();
                        if (metadataSource == null) {
                            throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource(key);
                        }
                        if (metadataSource instanceof List) {
                            for (Object next : (List)metadataSource) {
                                XmlBindings binding = JAXBContextFactory.getXmlBindings(next, classLoader, properties);
                                if (binding == null) continue;
                                xmlBindings.add(binding);
                            }
                        } else {
                            XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader, properties);
                            if (binding != null) {
                                xmlBindings.add(binding);
                            }
                        }
                        bindings.put(key, xmlBindings);
                    }
                }
            } else if (value instanceof List) {
                for (Object metadataSource : (List)value) {
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource();
                    }
                    bindings = JAXBContextFactory.processBindingFile(bindings, metadataSource, classLoader, properties);
                }
            } else {
                bindings = JAXBContextFactory.processBindingFile(bindings, value, classLoader, properties);
            }
        }
        HashMap<String, XmlBindings> mergedBindings = new HashMap<String, XmlBindings>(bindings.size());
        for (Map.Entry entry : bindings.entrySet()) {
            mergedBindings.put((String)entry.getKey(), XMLProcessor.mergeXmlBindings((List)entry.getValue()));
        }
        return mergedBindings;
    }

    private static Map<String, List<XmlBindings>> processBindingFile(Map<String, List<XmlBindings>> originalBindings, Object bindingHandle, ClassLoader classLoader, Map<String, Object> properties) {
        Map<String, List<XmlBindings>> bindingMap = originalBindings;
        XmlBindings binding = JAXBContextFactory.getXmlBindings(bindingHandle, classLoader, properties);
        if (binding != null) {
            List<XmlBindings> existingBindings;
            String key = binding.getPackageName();
            if (key.equals("##default")) {
                throw org.eclipse.persistence.exceptions.JAXBException.packageNotSetForBindingException();
            }
            XmlBindings.JavaTypes jTypes = binding.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    String javaTypeName = javaType.getName();
                    if (javaTypeName.contains(key)) continue;
                    javaType.setName(String.valueOf(key) + PKG_SEPARATOR + javaTypeName);
                }
            }
            if ((existingBindings = bindingMap.get(key)) != null) {
                existingBindings.add(binding);
            } else {
                existingBindings = new ArrayList<XmlBindings>();
                existingBindings.add(binding);
                bindingMap.put(key, existingBindings);
            }
        }
        return bindingMap;
    }

    private static XmlBindings getXmlBindings(Object metadata, ClassLoader classLoader, Map<String, Object> properties) {
        XmlBindings xmlBindings;
        block17: {
            xmlBindings = null;
            JAXBContext jaxbContext = CompilerHelper.getXmlBindingsModelContext();
            try {
                JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                if (metadata instanceof File) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((File)metadata);
                    break block17;
                }
                if (metadata instanceof InputSource) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((InputSource)metadata);
                    break block17;
                }
                if (metadata instanceof InputStream) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((InputStream)metadata);
                    break block17;
                }
                if (metadata instanceof Node) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Node)metadata);
                    break block17;
                }
                if (metadata instanceof Reader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Reader)metadata);
                    break block17;
                }
                if (metadata instanceof Source) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Source)metadata);
                    break block17;
                }
                if (metadata instanceof URL) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((URL)metadata);
                    break block17;
                }
                if (metadata instanceof XMLEventReader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((XMLEventReader)metadata);
                    break block17;
                }
                if (metadata instanceof XMLStreamReader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((XMLStreamReader)metadata);
                    break block17;
                }
                if (metadata instanceof MetadataSource) {
                    xmlBindings = ((MetadataSource)metadata).getXmlBindings(properties, classLoader);
                    break block17;
                }
                if (metadata instanceof String) {
                    if (((String)metadata).length() == 0) {
                        throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation((String)metadata);
                    }
                    URL url = null;
                    try {
                        url = new URL((String)metadata);
                    }
                    catch (MalformedURLException malformedURLException) {
                        url = classLoader.getResource((String)metadata);
                    }
                    if (url != null) {
                        xmlBindings = (XmlBindings)unmarshaller.unmarshal(url);
                        break block17;
                    }
                    throw org.eclipse.persistence.exceptions.JAXBException.unableToLoadMetadataFromLocation((String)metadata);
                }
                throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
            }
            catch (JAXBException jaxbEx) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)jaxbEx));
            }
        }
        return xmlBindings;
    }
}

