/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.login;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWProperty;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class PropertyPane
extends AbstractSubjectPanel {
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private ObjectListSelectionModel selectionModel;
    private JTable table;

    public PropertyPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    private ActionListener buildAddActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor editor = PropertyPane.this.currentWindow() instanceof Dialog ? new PropertyEditor("LOGIN_PROPERTY_EDITOR_ADD_TITLE", (Dialog)PropertyPane.this.currentWindow()) : new PropertyEditor("LOGIN_PROPERTY_EDITOR_ADD_TITLE");
                editor.setVisible(true);
                if (editor.wasConfirmed()) {
                    editor.apply();
                }
            }
        };
    }

    private ActionListener buildEditActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditor editor = PropertyPane.this.currentWindow() instanceof Dialog ? new PropertyEditor("LOGIN_PROPERTY_EDITOR_EDIT_TITLE", (Dialog)PropertyPane.this.currentWindow(), (MWProperty)PropertyPane.this.selectionModel.getSelectedValue()) : new PropertyEditor("LOGIN_PROPERTY_EDITOR_EDIT_TITLE", (MWProperty)PropertyPane.this.selectionModel.getSelectedValue());
                editor.setVisible(true);
                if (editor.wasConfirmed()) {
                    editor.apply();
                }
            }
        };
    }

    private void buildEditButtonEnabler() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PropertyPane.this.editButton.setEnabled(PropertyPane.this.selectionModel.getSelectedValues().length == 1);
                }
            }
        });
    }

    private CollectionValueModel buildPropertyCollectionHolder() {
        return new CollectionAspectAdapter(this.buildLoginSpecHolder(), "property"){

            protected Iterator getValueFromSubject() {
                MWEisLoginSpec loginSpec = (MWEisLoginSpec)this.subject;
                return loginSpec.getProperties().iterator();
            }

            protected int sizeFromSubject() {
                MWEisLoginSpec loginSpec = (MWEisLoginSpec)this.subject;
                return loginSpec.propertySize();
            }
        };
    }

    private ObjectListSelectionModel buildPropertySelectionModel() {
        ListModelAdapter listModel = new ListModelAdapter(this.buildPropertyCollectionHolder());
        return new ObjectListSelectionModel(listModel);
    }

    private TableModel buildPropertyTableAdapter() {
        return new TableModelAdapter(this.buildPropertyCollectionHolder(), (ColumnAdapter)new PropertyColumnAdapter());
    }

    private ActionListener buildRemoveActionListener(final ObjectListSelectionModel model) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] selectedValues = model.getSelectedValues();
                MWEisProject project = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec loginSpec = project.getEisLoginSpec();
                int index = selectedValues.length;
                while (--index >= 0) {
                    loginSpec.removeProperty((MWProperty)selectedValues[index]);
                }
            }
        };
    }

    private void buildRemoveButtonEnabler() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PropertyPane.this.removeButton.setEnabled(!PropertyPane.this.selectionModel.isSelectionEmpty());
                }
            }
        });
    }

    private TableColumnModel buildTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        TableColumn selectionColumn = new TableColumn(0);
        selectionColumn.setCellRenderer(new SelectionTableCellRenderer());
        selectionColumn.setHeaderValue(" ");
        selectionColumn.setMaxWidth(20);
        selectionColumn.setMinWidth(20);
        selectionColumn.setPreferredWidth(20);
        selectionColumn.setResizable(false);
        model.addColumn(selectionColumn);
        TableColumn nameColumn = new TableColumn(1);
        nameColumn.setHeaderValue(this.resourceRepository().getString("LOGIN_PROPERTY_NAME_COLUMN"));
        nameColumn.setMinWidth(50);
        nameColumn.setResizable(true);
        model.addColumn(nameColumn);
        TableColumn valueColumn = new TableColumn(2);
        valueColumn.setHeaderValue(this.resourceRepository().getString("LOGIN_PROPERTY_VALUE_COLUMN"));
        valueColumn.setMinWidth(50);
        valueColumn.setResizable(true);
        model.addColumn(valueColumn);
        return model;
    }

    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.selectionModel = this.buildPropertySelectionModel();
        this.table = SwingComponentFactory.buildTable(this.buildPropertyTableAdapter(), this.buildTableColumnModel(), this.selectionModel);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setAutoResizeMode(4);
        this.table.setAutoscrolls(true);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addPropertyChangeListener("enabled", new PropertyChangeHandler());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setMinimumSize(new Dimension(0, 0));
        this.scrollPane.setPreferredSize(new Dimension(0, 0));
        this.scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)this.scrollPane, constraints);
        this.addButton = this.buildButton("LOGIN_PROPERTY_ADD_BUTTON");
        this.addButton.addActionListener(this.buildAddActionListener());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.addButton, constraints);
        this.editButton = this.buildButton("LOGIN_PROPERTY_EDIT_BUTTON");
        this.editButton.addActionListener(this.buildEditActionListener());
        this.editButton.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.editButton, constraints);
        this.buildEditButtonEnabler();
        this.removeButton = this.buildButton("LOGIN_PROPERTY_REMOVE_BUTTON");
        this.removeButton.addActionListener(this.buildRemoveActionListener(this.selectionModel));
        this.removeButton.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.removeButton, constraints);
        this.buildRemoveButtonEnabler();
        this.addHelpTopicId(this, "session.login.properties");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.table.getTableHeader().setEnabled(enabled);
        if (enabled) {
            this.editButton.setEnabled(this.selectionModel.getSelectedValues().length == 1);
            this.removeButton.setEnabled(!this.selectionModel.isSelectionEmpty());
        } else {
            this.table.clearSelection();
            this.editButton.setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
        }
    }

    private PropertyAspectAdapter buildLoginSpecHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder()){

            protected Object getValueFromSubject() {
                return ((MWEisProject)this.subject).getEisLoginSpec();
            }
        };
    }

    private class VirtualProperty {
        public String key;
        private MWProperty propertyAdapter;
        public String value;

        VirtualProperty(MWProperty propertyAdapter) {
            this.initialize(propertyAdapter);
        }

        void apply() {
            if (this.propertyAdapter == null) {
                MWEisProject project = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec loginSpec = project.getEisLoginSpec();
                this.propertyAdapter = loginSpec.addProperty(this.key, this.value);
            } else {
                this.propertyAdapter.setKey(this.key);
                this.propertyAdapter.setValue(this.value);
            }
        }

        private void initialize(MWProperty propertyAdapter) {
            this.propertyAdapter = propertyAdapter;
            if (propertyAdapter != null) {
                this.key = propertyAdapter.getKey();
                this.value = propertyAdapter.getValue();
            } else {
                this.key = "";
                this.value = "";
            }
        }
    }

    private class SelectionTableCellRenderer
    extends SimpleTableCellRenderer {
        private SelectionTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component component = super.getTableCellRendererComponent(table, value, selected, hasFocus, rowIndex, columnIndex);
            if (!selected) {
                component.setBackground(table.getTableHeader().getBackground());
            }
            return component;
        }
    }

    private class PropertyEditorView
    extends AbstractSubjectPanel {
        static final String VALUE_PROPERTY = "value";
        static final String NAME_PROPERTY = "name";

        public PropertyEditorView(PropertyValueModel subjectHolder, ApplicationContext context) {
            super((ValueModel)subjectHolder, context);
        }

        private Document buildNameDocumentAdapter() {
            return new DocumentAdapter(this.buildNameHolder());
        }

        private PropertyValueModel buildNameHolder() {
            return new SimplePropertyValueModel(){

                public Object getValue() {
                    VirtualProperty property = (VirtualProperty)PropertyEditorView.this.subject();
                    return property.key;
                }

                public void setValue(Object value) {
                    VirtualProperty property = (VirtualProperty)PropertyEditorView.this.subject();
                    String oldName = property.key;
                    property.key = ((String)value).trim();
                    PropertyEditorView.this.firePropertyChange(PropertyEditorView.NAME_PROPERTY, oldName, property.key);
                }
            };
        }

        private Document buildValueDocumentAdapter() {
            return new DocumentAdapter(this.buildValueHolder());
        }

        private PropertyValueModel buildValueHolder() {
            return new SimplePropertyValueModel(){

                public Object getValue() {
                    VirtualProperty property = (VirtualProperty)PropertyEditorView.this.subject();
                    return property.value;
                }

                public void setValue(Object value) {
                    VirtualProperty property = (VirtualProperty)PropertyEditorView.this.subject();
                    String oldValue = property.value;
                    property.value = ((String)value).trim();
                    PropertyEditorView.this.firePropertyChange(PropertyEditorView.VALUE_PROPERTY, oldValue, property.value);
                }
            };
        }

        public Component getInitialFocusComponent() {
            return (Component)this.getClientProperty("initialFocus");
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JComponent nameWidgets = this.buildLabeledTextField("LOGIN_PROPERTY_EDITOR_NAME_FIELD", this.buildNameDocumentAdapter());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)nameWidgets, constraints);
            this.putClientProperty("initialFocus", nameWidgets.getComponent(1));
            JComponent valueWidgets = this.buildLabeledTextField("LOGIN_PROPERTY_EDITOR_VALUE_FIELD", this.buildValueDocumentAdapter());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)valueWidgets, constraints);
        }
    }

    private class PropertyEditor
    extends AbstractValidatingDialog {
        private Component initialFocusComponent;
        private final VirtualProperty virtualProperty;

        public PropertyEditor(String titleKey) {
            this(titleKey, (MWProperty)null);
        }

        public PropertyEditor(String titleKey, Dialog parentWindow) {
            this(titleKey, parentWindow, null);
        }

        public PropertyEditor(String titleKey, Dialog parentWindow, MWProperty propertyAdapter) {
            super(PropertyPane.this.getWorkbenchContext(), PropertyPane.this.resourceRepository().getString(titleKey), parentWindow);
            this.virtualProperty = new VirtualProperty(propertyAdapter);
        }

        public PropertyEditor(String titleKey, MWProperty propertyAdapter) {
            super(PropertyPane.this.getWorkbenchContext(), PropertyPane.this.resourceRepository().getString(titleKey));
            this.virtualProperty = new VirtualProperty(propertyAdapter);
        }

        public void apply() {
            if (this.wasConfirmed()) {
                this.virtualProperty.apply();
            }
        }

        protected Component buildMainPanel() {
            PropertyEditorView view = new PropertyEditorView(new SimplePropertyValueModel(this.virtualProperty), this.getApplicationContext());
            PropertyChangeListener listener = this.buildValidationPropertyListener();
            view.addPropertyChangeListener("name", listener);
            view.addPropertyChangeListener("value", listener);
            this.initialFocusComponent = view.getInitialFocusComponent();
            return view;
        }

        private PropertyChangeListener buildValidationPropertyListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    PropertyEditor.this.validate(e.getPropertyName());
                }
            };
        }

        protected String helpTopicId() {
            return "session.login.properties.propertyEditor";
        }

        protected Component initialFocusComponent() {
            return this.initialFocusComponent;
        }

        protected void prepareToShow() {
            super.prepareToShow();
            ((JTextField)this.initialFocusComponent).selectAll();
            this.getOKAction().setEnabled(this.virtualProperty.propertyAdapter != null);
        }

        private void validate(String propertyName) {
            String valueErrorKey = this.virtualProperty.value.length() == 0 ? "_EMPTY_VALUE" : null;
            String nameErrorKey = null;
            if (this.virtualProperty.key.length() == 0) {
                nameErrorKey = "_EMPTY_NAME";
            } else {
                MWEisProject project = (MWEisProject)PropertyPane.this.subject();
                MWEisLoginSpec loginSpec = project.getEisLoginSpec();
                Iterator iter = loginSpec.properties();
                while (iter.hasNext()) {
                    MWProperty propertyAdapter = (MWProperty)iter.next();
                    if (propertyAdapter == this.virtualProperty.propertyAdapter || !propertyAdapter.getKey().equalsIgnoreCase(this.virtualProperty.key)) continue;
                    nameErrorKey = "_INVALID_NAME";
                    break;
                }
            }
            String errorKey = "LOGIN_PROPERTY_EDITOR";
            if (nameErrorKey != null) {
                errorKey = errorKey + nameErrorKey;
            }
            if (valueErrorKey != null) {
                errorKey = errorKey + valueErrorKey;
            }
            if (nameErrorKey == null && valueErrorKey == null) {
                this.clearErrorMessage();
                this.getOKAction().setEnabled(true);
            } else {
                this.setErrorMessage(this.resourceRepository().getString(errorKey));
                this.getOKAction().setEnabled(false);
            }
        }
    }

    private static class PropertyColumnAdapter
    implements ColumnAdapter {
        public static final int COLUMN_COUNT = 3;
        public static final int NAME_COLUMN = 1;
        public static final int SELECTION_COLUMN = 0;
        public static final int VALUE_COLUMN = 2;

        private PropertyColumnAdapter() {
        }

        private PropertyValueModel buildNameAdapter(final MWProperty property) {
            return new PropertyAspectAdapter("key", (Model)property){

                protected Object getValueFromSubject() {
                    return property.getKey();
                }
            };
        }

        private PropertyValueModel buildValueAdapter(final MWProperty property) {
            return new PropertyAspectAdapter("value", (Model)property){

                protected Object getValueFromSubject() {
                    return property.getValue();
                }
            };
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWProperty property = (MWProperty)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{new SimplePropertyValueModel(), this.buildNameAdapter(property), this.buildValueAdapter(property)};
            return result;
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            return null;
        }

        public boolean isColumnEditable(int index) {
            return false;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (PropertyPane.this.table.isEnabled()) {
                PropertyPane.this.scrollPane.getViewport().setBackground(PropertyPane.this.table.getBackground());
            } else {
                PropertyPane.this.scrollPane.getViewport().setBackground(UIManager.getColor("control"));
            }
        }
    }
}

