/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;

public class ThreadCursoredList
extends Vector {
    protected boolean isComplete = false;
    protected RuntimeException exception;

    public ThreadCursoredList() {
        this(10);
    }

    public ThreadCursoredList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ThreadCursoredList(int initialCapacity, int capacityIncrement) {
        super(0);
    }

    public synchronized void add(int index, Object element) {
        super.add(index, element);
        this.notifyAll();
    }

    public synchronized boolean add(Object element) {
        boolean result = super.add(element);
        this.notifyAll();
        return result;
    }

    public synchronized boolean addAll(int index, Collection collection) {
        boolean result = super.addAll(index, collection);
        this.notifyAll();
        return result;
    }

    public synchronized boolean addAll(Collection collection) {
        boolean result = super.addAll(collection);
        this.notifyAll();
        return result;
    }

    public synchronized void addElement(Object object) {
        super.addElement(object);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.waitUntilComplete();
        super.clear();
    }

    public synchronized Object clone() {
        this.waitUntilComplete();
        return super.clone();
    }

    public boolean hasException() {
        return this.getException() != null;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public synchronized void throwException(RuntimeException exception) {
        this.exception = exception;
        this.setIsComplete(true);
    }

    public synchronized boolean isComplete() {
        if (this.hasException()) {
            RuntimeException thrownException = this.exception;
            this.exception = null;
            throw thrownException;
        }
        return this.isComplete;
    }

    public synchronized void setIsComplete(boolean isComplete) {
        this.isComplete = isComplete;
        this.notifyAll();
    }

    public synchronized void waitUntilComplete() {
        while (!this.isComplete()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitUntilAdd() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized boolean contains(Object element) {
        boolean result = super.contains(element);
        if (!result && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.contains(element);
        }
        return result;
    }

    public synchronized boolean containsAll(Collection collection) {
        boolean result = super.containsAll(collection);
        if (!result && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.containsAll(collection);
        }
        return result;
    }

    public synchronized void copyInto(Object[] array) {
        this.waitUntilComplete();
        super.copyInto(array);
    }

    public synchronized Object elementAt(int index) {
        Object result = super.elementAt(index);
        if (result == null && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.elementAt(index);
        }
        return result;
    }

    protected int getSize() {
        return super.size();
    }

    public Enumeration elements() {
        return new Enumeration(){
            int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasMoreElements() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    }
                    return result;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (result) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public synchronized boolean equals(Object object) {
        this.waitUntilComplete();
        return super.equals(object);
    }

    public synchronized Object firstElement() {
        while (!this.isComplete() && super.size() < 1) {
            this.waitUntilAdd();
        }
        return super.firstElement();
    }

    public synchronized Object get(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.get(index);
    }

    public synchronized int hashCode() {
        this.waitUntilComplete();
        return super.hashCode();
    }

    public int indexOf(Object element) {
        int result = super.indexOf(element);
        if (result == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.indexOf(element);
        }
        return result;
    }

    public synchronized int indexOf(Object element, int index) {
        int result = super.indexOf(element, index);
        if (result == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.indexOf(element, index);
        }
        return result;
    }

    public synchronized void insertElementAt(Object element, int index) {
        super.insertElementAt(element, index);
        this.notify();
    }

    public boolean isEmpty() {
        boolean result = super.isEmpty();
        if (result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.isEmpty();
        }
        return result;
    }

    public Iterator iterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public synchronized Object lastElement() {
        this.waitUntilComplete();
        return super.lastElement();
    }

    public int lastIndexOf(Object element) {
        this.waitUntilComplete();
        return super.lastIndexOf(element);
    }

    public synchronized int lastIndexOf(Object element, int index) {
        this.waitUntilComplete();
        return super.lastIndexOf(element, index);
    }

    public ListIterator listIterator() {
        throw ValidationException.operationNotSupported("iterator");
    }

    public ListIterator listIterator(int index) {
        throw ValidationException.operationNotSupported("iterator");
    }

    public synchronized Object remove(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.remove(index);
    }

    public boolean remove(Object element) {
        boolean result = super.remove(element);
        if (!result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.remove(element);
        }
        return result;
    }

    public synchronized boolean removeAll(Collection collection) {
        this.waitUntilComplete();
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        this.waitUntilComplete();
        super.removeAllElements();
    }

    public synchronized boolean removeElement(Object element) {
        boolean result = super.removeElement(element);
        if (!result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.removeElement(element);
        }
        return result;
    }

    public synchronized void removeElementAt(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        super.removeElementAt(index);
    }

    public synchronized boolean retainAll(Collection collection) {
        this.waitUntilComplete();
        return super.retainAll(collection);
    }

    public synchronized Object set(int index, Object element) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.set(index, element);
    }

    public synchronized void setElementAt(Object element, int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        super.setElementAt(element, index);
    }

    public int size() {
        this.waitUntilComplete();
        return super.size();
    }

    public List subList(int fromIndex, int toIndex) {
        while (!this.isComplete() && super.size() < toIndex) {
            this.waitUntilAdd();
        }
        return super.subList(fromIndex, toIndex);
    }

    public synchronized Object[] toArray() {
        this.waitUntilComplete();
        return super.toArray();
    }

    public synchronized Object[] toArray(Object[] array) {
        this.waitUntilComplete();
        return super.toArray(array);
    }

    public synchronized String toString() {
        this.waitUntilComplete();
        return super.toString();
    }

    public synchronized void trimToSize() {
        this.waitUntilComplete();
        super.trimToSize();
    }
}

