/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.query.CompoundExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;

public class ComparisonExpressionStateObject
extends CompoundExpressionStateObject {
    private String identifier;
    public static final String IDENTIFIER_PROPERTY = "identifier";

    public ComparisonExpressionStateObject(StateObject parent, StateObject leftStateObject, String identifier, StateObject rightStateObject) {
        super(parent, leftStateObject, rightStateObject);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public ComparisonExpressionStateObject(StateObject parent, String identifier) {
        super(parent);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public ComparisonExpressionStateObject(StateObject parent, String leftJpqlFragment, String identifier, String rightJpqlFragment) {
        super(parent, leftJpqlFragment, rightJpqlFragment);
        this.validateIdentifier(identifier);
        this.identifier = identifier;
    }

    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public ComparisonExpression getExpression() {
        return (ComparisonExpression)super.getExpression();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    protected String getLeftQueryBNFId() {
        return "comparison_expression";
    }

    protected String getRightQueryBNFId() {
        return "comparison_expression";
    }

    public void setExpression(ComparisonExpression expression) {
        super.setExpression(expression);
    }

    public void setIdentifier(String identifier) {
        this.validateIdentifier(identifier);
        String oldIdentifier = this.identifier;
        this.identifier = identifier;
        this.firePropertyChanged(IDENTIFIER_PROPERTY, oldIdentifier, identifier);
    }

    protected void validateIdentifier(String identifier) {
        Assert.isValid(identifier, "The comparison identifier must be either <, <=, =, >=, <>.", "<", "<=", "=", ">", ">=", "<>");
    }
}

