/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryBuilder;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DeleteStatementStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.UpdateStatementStateObject;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPQLQueryStateObject
extends AbstractStateObject {
    private IManagedTypeProvider provider;
    private IJPQLQueryBuilder queryBuilder;
    private StateObject queryStatement;
    public static final String QUERY_STATEMENT_PROPERTY = "statement";

    public JPQLQueryStateObject(IJPQLQueryBuilder queryBuilder, IManagedTypeProvider provider) {
        super(null);
        this.initialize(queryBuilder, provider);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.queryStatement != null) {
            children.add(this.queryStatement);
        }
    }

    public DeleteStatementStateObject addDeleteStatement() {
        DeleteStatementStateObject stateObject = new DeleteStatementStateObject(this);
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    public SelectStatementStateObject addDistinctSelectStatement() {
        SelectStatementStateObject stateObject = new SelectStatementStateObject(this);
        stateObject.getSelectClause().toggleDistinct();
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    public SelectStatementStateObject addSelectStatement() {
        SelectStatementStateObject stateObject = new SelectStatementStateObject(this);
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    public SelectStatementStateObject addSelectStatement(String jpqlFragment) {
        SelectStatementStateObject stateObject = new SelectStatementStateObject(this);
        stateObject.getSelectClause().parse(jpqlFragment);
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    public UpdateStatementStateObject addUpdateStatement() {
        UpdateStatementStateObject stateObject = new UpdateStatementStateObject(this);
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    public UpdateStatementStateObject addUpdateStatement(String jpqlFragment) {
        UpdateStatementStateObject stateObject = new UpdateStatementStateObject(this);
        stateObject.getModifyClause().parse(jpqlFragment);
        this.setQueryStatement(stateObject);
        return stateObject;
    }

    @Override
    protected StateObject checkParent(StateObject parent) {
        return parent;
    }

    @Override
    public DeclarationStateObject getDeclaration() {
        return this.queryStatement == null ? null : this.queryStatement.getDeclaration();
    }

    @Override
    public JPQLExpression getExpression() {
        return (JPQLExpression)super.getExpression();
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.queryBuilder.getGrammar();
    }

    @Override
    public IManagedTypeProvider getManagedTypeProvider() {
        return this.provider;
    }

    @Override
    public StateObject getParent() {
        return null;
    }

    @Override
    public IJPQLQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public StateObject getQueryStatement() {
        return this.queryStatement;
    }

    @Override
    public JPQLQueryStateObject getRoot() {
        return this;
    }

    @Override
    protected ITypeRepository getTypeRepository() {
        return this.getManagedTypeProvider().getTypeRepository();
    }

    public boolean hasQueryStatement() {
        return this.queryStatement != null;
    }

    protected void initialize(IJPQLQueryBuilder queryBuilder, IManagedTypeProvider provider) {
        Assert.isNotNull(queryBuilder, "IJPQLQueryBuilder cannot be null");
        Assert.isNotNull(provider, "IManagedTypeProvider cannot be null");
        this.provider = provider;
        this.queryBuilder = queryBuilder;
    }

    public void parse(CharSequence jpqlFragment, String queryBNFId) {
        Object stateObject = this.buildStateObject(jpqlFragment, queryBNFId);
        this.setQueryStatement((StateObject)stateObject);
    }

    public void setExpression(JPQLExpression expression) {
        super.setExpression(expression);
    }

    public void setQueryStatement(StateObject queryStatement) {
        StateObject oldStatement = this.queryStatement;
        this.queryStatement = this.parent(queryStatement);
        this.firePropertyChanged(QUERY_STATEMENT_PROPERTY, oldStatement, queryStatement);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        if (this.queryStatement != null) {
            this.queryStatement.toString(writer);
        }
    }
}

