/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnection;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSReceiveInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSRecord;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendReceiveInteractionSpec;

public class CciJMSInteraction
implements Interaction {
    protected CciJMSConnection connection;

    public CciJMSInteraction(CciJMSConnection conn) {
        this.connection = conn;
    }

    public Record execute(InteractionSpec spec, Record input) throws EISException {
        CciJMSRecord record = new CciJMSRecord();
        this.execute(spec, input, (Record)record);
        return record;
    }

    public boolean execute(InteractionSpec spec, Record input, Record output) throws EISException {
        block12: {
            if (!(spec instanceof CciJMSInteractionSpec)) {
                throw EISException.invalidInteractionSpecType();
            }
            if (!(input instanceof CciJMSRecord) || !(output instanceof CciJMSRecord)) {
                throw EISException.invalidRecordType();
            }
            boolean autocommit = false;
            if (!this.connection.getJMSTransaction().isInTransaction()) {
                autocommit = true;
                this.connection.getJMSTransaction().begin();
            }
            try {
                try {
                    if (spec instanceof CciJMSSendInteractionSpec) {
                        this.executeSendInteraction((CciJMSSendInteractionSpec)spec, (CciJMSRecord)input, (CciJMSRecord)output);
                        break block12;
                    }
                    if (spec instanceof CciJMSReceiveInteractionSpec) {
                        this.executeReceiveInteraction((CciJMSReceiveInteractionSpec)spec, (CciJMSRecord)input, (CciJMSRecord)output);
                        break block12;
                    }
                    if (spec instanceof CciJMSSendReceiveInteractionSpec) {
                        this.executeSendReceiveInteraction((CciJMSSendReceiveInteractionSpec)spec, (CciJMSRecord)input, (CciJMSRecord)output);
                        break block12;
                    }
                    throw EISException.unknownInteractionSpecType();
                }
                catch (Exception exception) {
                    throw EISException.createException(exception);
                }
            }
            finally {
                if (autocommit) {
                    this.connection.getJMSTransaction().commit();
                }
            }
        }
        return true;
    }

    protected void executeSendInteraction(CciJMSSendInteractionSpec spec, CciJMSRecord input, CciJMSRecord output) throws EISException {
        if (input.size() != 1) {
            throw EISException.invalidInput();
        }
        try {
            QueueSession qSession = (QueueSession)this.connection.getSession();
            Queue queue = spec.hasDestinationURL() ? (Queue)new InitialContext().lookup(spec.getDestinationURL()) : qSession.createQueue(spec.getDestination());
            Message msg = this.createMessage(input.get(0), qSession);
            if (spec.hasMessageSelector()) {
                msg.setJMSCorrelationID(spec.getMessageSelector());
            }
            if (spec.hasReplyToDestinationURL()) {
                msg.setJMSReplyTo((Destination)((Queue)new InitialContext().lookup(spec.getReplyToDestinationURL())));
            } else {
                msg.setJMSReplyTo((Destination)qSession.createQueue(spec.getReplyToDestination()));
            }
            qSession.createSender(queue).send(msg);
        }
        catch (Exception ex) {
            throw EISException.createException(ex);
        }
    }

    protected void executeReceiveInteraction(CciJMSReceiveInteractionSpec spec, CciJMSRecord input, CciJMSRecord output) throws EISException {
        try {
            QueueSession qSession = (QueueSession)this.connection.getSession();
            Queue queue = spec.hasDestinationURL() ? (Queue)new InitialContext().lookup(spec.getDestinationURL()) : qSession.createQueue(spec.getDestination());
            QueueReceiver receiver = spec.hasMessageSelector() ? qSession.createReceiver(queue, spec.getFormattedMessageSelector()) : qSession.createReceiver(queue);
            Message msg = receiver.receive(spec.getTimeout());
            if (msg == null) {
                throw EISException.timeoutOccurred();
            }
            output.add(msg);
        }
        catch (Exception ex) {
            throw EISException.createException(ex);
        }
    }

    protected void executeSendReceiveInteraction(CciJMSSendReceiveInteractionSpec spec, CciJMSRecord input, CciJMSRecord output) throws EISException {
        if (input.size() != 1) {
            throw EISException.invalidInput();
        }
        try {
            QueueSession qSession = (QueueSession)this.connection.getSession();
            Queue sendQueue = spec.hasDestinationURL() ? (Queue)new InitialContext().lookup(spec.getDestinationURL()) : qSession.createQueue(spec.getDestination());
            Queue replyToQueue = spec.hasReplyToDestinationURL() ? (Queue)new InitialContext().lookup(spec.getReplyToDestinationURL()) : qSession.createQueue(spec.getReplyToDestination());
            Message msg = this.createMessage(input.get(0), qSession);
            msg.setJMSReplyTo((Destination)replyToQueue);
            if (spec.hasMessageSelector()) {
                msg.setJMSCorrelationID(spec.getMessageSelector());
                this.sendMessageAndCommit(qSession, sendQueue, msg);
            } else {
                this.sendMessageAndCommit(qSession, sendQueue, msg);
                spec.setMessageSelector(msg.getJMSMessageID());
            }
            Queue receiveQueue = spec.hasReplyToDestinationURL() ? (Queue)new InitialContext().lookup(spec.getReplyToDestinationURL()) : qSession.createQueue(spec.getReplyToDestination());
            msg = qSession.createReceiver(receiveQueue, spec.getFormattedMessageSelector()).receive(spec.getTimeout());
            if (msg == null) {
                throw EISException.timeoutOccurred();
            }
            output.add(msg);
        }
        catch (Exception ex) {
            throw EISException.createException(ex);
        }
    }

    protected void sendMessageAndCommit(QueueSession qSession, Queue queue, Message msg) throws EISException {
        try {
            qSession.createSender(queue).send(msg);
        }
        catch (Exception ex) {
            throw EISException.createException(ex);
        }
        this.connection.getJMSTransaction().commit();
        this.connection.getJMSTransaction().begin();
    }

    protected Message createMessage(Object recordData, QueueSession session) throws EISException {
        TextMessage msg;
        try {
            if (!(recordData instanceof String)) {
                throw EISException.unsupportedMessageInInputRecord();
            }
            msg = session.createTextMessage((String)recordData);
        }
        catch (JMSException jmse) {
            throw EISException.createException((Exception)((Object)jmse));
        }
        return msg;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public void close() {
    }
}

