/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.IListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.model.IPropertyChangeListener;
import org.eclipse.persistence.jpa.jpql.model.ListChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.PropertyChangeEvent;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSupport {
    private Map<String, List<IListChangeListener<?>>> listChangeListeners;
    private Map<String, List<IPropertyChangeListener<?>>> propertyChangeListeners;
    private StateObject source;

    public ChangeSupport(StateObject source) {
        this.initialize(source);
    }

    public <T> void addItem(ListHolderStateObject<T> source, List<T> items, String listName, T item) {
        this.addItems(source, items, listName, Collections.singletonList(item));
    }

    public <T> void addItems(ListHolderStateObject<T> source, List<T> list, String listName, List<? extends T> items) {
        ArrayList<T> original = new ArrayList<T>(list);
        int index = list.size();
        list.addAll(index, items);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<? extends T> event = new ListChangeEvent<T>(source, original, IListChangeEvent.EventType.ADDED, listName, new ArrayList<T>(items), index, index);
            this.fireListChangeEvent(event);
        }
    }

    public void addListChangeListener(String listName, IListChangeListener<?> listener) {
        this.addListener(this.listChangeListeners, IListChangeListener.class, listName, listener);
    }

    protected <T> void addListener(Map<String, List<T>> listeners, Class<?> listenerType, String name, T listener) {
        if (listener == null) {
            throw new NullPointerException(String.valueOf(listenerType.getSimpleName()) + " cannot be null");
        }
        List<T> listenerList = listeners.get(name);
        if (listenerList == null) {
            listenerList = new ArrayList<T>();
            listeners.put(name, listenerList);
        }
        if (listenerList.contains(listener)) {
            throw new IllegalArgumentException(String.valueOf(listenerType.getSimpleName()) + " is already registered");
        }
        listenerList.add(listener);
    }

    public void addPropertyChangeListener(String propertyName, IPropertyChangeListener<?> listener) {
        this.addListener(this.propertyChangeListeners, IPropertyChangeListener.class, propertyName, listener);
    }

    public <T> boolean canMoveDown(List<T> list, T stateObject) {
        int index = list.indexOf(stateObject);
        return index > -1 && index + 1 < list.size();
    }

    public <T> boolean canMoveUp(List<T> list, T item) {
        int index = list.indexOf(item);
        return index > 0;
    }

    protected <T> void fireListChangeEvent(IListChangeEvent<T> event) {
        for (IListChangeListener iListChangeListener : this.listChangeListeners(event.getListName())) {
            try {
                iListChangeListener.itemsRemoved(event);
            }
            catch (Exception exception) {}
        }
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        if (this.valuesAreDifferent(oldValue, newValue) && this.hasPropertyChangeListeners(propertyName)) {
            PropertyChangeEvent<Object> event = new PropertyChangeEvent<Object>(this.source, propertyName, oldValue, newValue);
            for (IPropertyChangeListener iPropertyChangeListener : this.propertyChangeListeners(propertyName)) {
                try {
                    iPropertyChangeListener.propertyChanged(event);
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean hasListChangeListeners(String listName) {
        return this.hasListeners(this.listChangeListeners, listName);
    }

    protected boolean hasListeners(Map<String, ?> listeners, String name) {
        return listeners.containsKey(name);
    }

    public boolean hasPropertyChangeListeners(String propertyName) {
        return this.hasListeners(this.propertyChangeListeners, propertyName);
    }

    protected void initialize(StateObject source) {
        Assert.isNotNull(source, "The source StateObject cannot be null");
        this.source = source;
        this.listChangeListeners = new HashMap();
        this.propertyChangeListeners = new HashMap();
    }

    protected <T> IterableListIterator<IListChangeListener<T>> listChangeListeners(String listName) {
        return new CloneListIterator<IListChangeListener<T>>(this.listChangeListeners.get(listName));
    }

    public <T> void moveDown(ListHolderStateObject<T> source, List<T> items, String listName, T item) {
        int index = items.indexOf(item);
        this.moveItem(source, items, IListChangeEvent.EventType.MOVED_DOWN, listName, item, index + 1, index);
    }

    protected <T> void moveItem(ListHolderStateObject<T> source, List<T> items, IListChangeEvent.EventType eventType, String listName, T item, int oldIndex, int newIndex) {
        ArrayList<T> original = new ArrayList<T>(items);
        items.remove(oldIndex);
        items.add(newIndex, item);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<T> event = new ListChangeEvent<T>(source, original, eventType, listName, Collections.singletonList(item), newIndex, oldIndex);
            this.fireListChangeEvent(event);
        }
    }

    public <T> void moveUp(ListHolderStateObject<T> source, List<T> items, String listName, T item) {
        int index = items.indexOf(item);
        this.moveItem(source, items, IListChangeEvent.EventType.MOVED_DOWN, listName, item, index - 1, index);
    }

    protected IterableListIterator<IPropertyChangeListener<?>> propertyChangeListeners(String propertyName) {
        return new CloneListIterator(this.propertyChangeListeners.get(propertyName));
    }

    public <T> void removeItem(ListHolderStateObject<T> source, List<T> items, String listName, T item) {
        ArrayList<T> original = new ArrayList<T>(items);
        int index = items.indexOf(item);
        items.remove(index);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<T> event = new ListChangeEvent<T>(source, original, IListChangeEvent.EventType.REMOVED, listName, Collections.singletonList(item), index, index);
            this.fireListChangeEvent(event);
        }
    }

    public <T> void removeItems(ListHolderStateObject<T> source, List<? extends T> list, String listName, Collection<? extends T> items) {
        ArrayList<? extends T> original = new ArrayList<T>(list);
        list.removeAll(items);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<? extends T> event = new ListChangeEvent<T>(source, original, IListChangeEvent.EventType.REMOVED, listName, new ArrayList<T>(items), -1, -1);
            this.fireListChangeEvent(event);
        }
    }

    public void removeListChangeListener(String listName, IListChangeListener<?> listener) {
        this.removeListener(this.listChangeListeners, IListChangeListener.class, listName, listener);
    }

    protected <T> void removeListener(Map<String, List<T>> listeners, Class<?> listenerType, String name, T listener) {
        if (listener == null) {
            throw new NullPointerException(String.valueOf(listenerType.getSimpleName()) + " cannot be null");
        }
        List<T> listenerList = listeners.get(name);
        if (listenerList == null) {
            throw new IllegalArgumentException("No listeners were registered for " + name);
        }
        if (!listenerList.remove(listener)) {
            throw new IllegalArgumentException(String.valueOf(listenerType.getSimpleName()) + " was never registered");
        }
        if (listeners.isEmpty()) {
            listeners.remove(name);
        }
    }

    public void removePropertyChangeListener(String propertyName, IPropertyChangeListener<?> listener) {
        this.removeListener(this.propertyChangeListeners, IPropertyChangeListener.class, propertyName, listener);
    }

    public <T> void replaceItem(ListHolderStateObject<T> source, List<T> items, String listName, int index, T item) {
        ArrayList<T> original = new ArrayList<T>(items);
        items.set(index, item);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<T> event = new ListChangeEvent<T>(source, original, IListChangeEvent.EventType.REPLACED, listName, items, index, index);
            this.fireListChangeEvent(event);
        }
    }

    public <T> void replaceItems(ListHolderStateObject<T> source, List<T> items, String listName, List<T> newItems) {
        ArrayList<T> original = new ArrayList<T>(items);
        items.clear();
        items.addAll(newItems);
        if (this.hasListChangeListeners(listName)) {
            ListChangeEvent<T> event = new ListChangeEvent<T>(source, original, IListChangeEvent.EventType.REPLACED, listName, items, -1, -1);
            this.fireListChangeEvent(event);
        }
    }

    public boolean valuesAreDifferent(Object value1, Object value2) {
        return !this.valuesAreEqual(value1, value2);
    }

    public boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == value2 || value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }
}

