/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractIdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractJoinStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinStateObject
extends AbstractJoinStateObject {
    private boolean as;
    private IdentificationVariableStateObject identificationVariable;
    public static final String AS_PROPERTY = "as";
    public static final String JOIN_TYPE_PROPERTY = "joinType";

    public JoinStateObject(AbstractIdentificationVariableDeclarationStateObject parent, String joinType) {
        this(parent, joinType, false);
    }

    public JoinStateObject(AbstractIdentificationVariableDeclarationStateObject parent, String joinType, boolean as) {
        super(parent, joinType);
        this.as = as;
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public JoinStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.identificationVariable);
    }

    @Override
    public Join getExpression() {
        return (Join)super.getExpression();
    }

    public String getIdentificationVariable() {
        return this.identificationVariable.getText();
    }

    public IdentificationVariableStateObject getIdentificationVariableStateObject() {
        return this.identificationVariable;
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable.hasText();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.identificationVariable = new IdentificationVariableStateObject(this);
    }

    public void removeNot() {
        if (this.as) {
            this.setAs(false);
        }
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setExpression(Join expression) {
        super.setExpression(expression);
    }

    public void setIdentificationVariable(String identificationVariable) {
        this.identificationVariable.setText(identificationVariable);
    }

    public void toggleAs() {
        this.setAs(!this.as);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        super.toTextInternal(writer);
        if (this.as) {
            writer.append(' ');
            writer.append("AS");
        }
        writer.append(' ');
        this.identificationVariable.toString(writer);
    }

    @Override
    protected void validateJoinType(String joinType) {
        Assert.isValid(joinType, "The join type is not valid", "JOIN", "LEFT JOIN", "LEFT OUTER JOIN", "INNER JOIN");
    }
}

