/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.util.filter.Filter;
import org.eclipse.persistence.jpa.jpql.util.filter.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JPQLQueryBNF {
    private Set<String> cachedFactories;
    private Map<String, ExpressionFactory> cachedIdentifiers;
    private Set<JPQLQueryBNF> childNonCompoundQueryBNFs;
    private Set<JPQLQueryBNF> childQueryBNFs;
    private List<String> children;
    private boolean compound;
    private List<String> expressionFactories;
    private ExpressionRegistry expressionRegistry;
    private String fallbackBNFId;
    private String fallbackExpressionFactoryId;
    private Boolean handleAggregate;
    private Boolean handleCollection;
    private String id;
    private boolean traversed;

    protected JPQLQueryBNF(String id) {
        this.initialize(id);
    }

    protected void addChildren(Set<JPQLQueryBNF> queryBNFs, Filter<JPQLQueryBNF> filter) {
        if (this.children != null) {
            for (String id : this.children) {
                JPQLQueryBNF queryBNF = this.expressionRegistry.getQueryBNF(id);
                if (!queryBNFs.add(queryBNF) || !filter.accept(queryBNF)) continue;
                queryBNF.addChildren(queryBNFs, filter);
            }
        }
    }

    private Set<JPQLQueryBNF> buildChildren(Filter<JPQLQueryBNF> filter) {
        HashSet<JPQLQueryBNF> queryBNFs = new HashSet<JPQLQueryBNF>();
        queryBNFs.add(this);
        this.addChildren(queryBNFs, this.buildNonCompoundFilter());
        return queryBNFs;
    }

    private Map<String, ExpressionFactory> buildIdentifiers() {
        HashMap<String, ExpressionFactory> identifiers = new HashMap<String, ExpressionFactory>();
        for (String expressionFactoryId : this.getExpressionFactoryIds()) {
            ExpressionFactory expressionFactory = this.expressionRegistry.getExpressionFactory(expressionFactoryId);
            String[] stringArray = expressionFactory.identifiers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                identifiers.put(identifier, expressionFactory);
                ++n2;
            }
        }
        return Collections.unmodifiableMap(identifiers);
    }

    private Filter<JPQLQueryBNF> buildNonCompoundFilter() {
        return new Filter<JPQLQueryBNF>(){

            @Override
            public boolean accept(JPQLQueryBNF queryBNF) {
                return !queryBNF.isCompound();
            }
        };
    }

    private boolean calculateHandleAggregate() {
        for (JPQLQueryBNF queryBNF : this.children()) {
            if (queryBNF == this || queryBNF.traversed) continue;
            queryBNF.traversed = true;
            if (queryBNF.handleAggregate()) {
                queryBNF.traversed = false;
                return true;
            }
            queryBNF.traversed = false;
        }
        return false;
    }

    private boolean calculateHandleCollection() {
        for (JPQLQueryBNF queryBNF : this.children()) {
            if (queryBNF == this || queryBNF.traversed) continue;
            queryBNF.traversed = true;
            if (queryBNF.handleCollection()) {
                queryBNF.traversed = false;
                return true;
            }
            queryBNF.traversed = false;
        }
        return false;
    }

    public Set<JPQLQueryBNF> children() {
        if (this.childQueryBNFs == null) {
            this.childQueryBNFs = this.buildChildren(NullFilter.<JPQLQueryBNF>instance());
            this.childQueryBNFs = Collections.unmodifiableSet(this.childQueryBNFs);
        }
        return this.childQueryBNFs;
    }

    public ExpressionFactory getExpressionFactory(String identifier) {
        this.populateIdentifiers();
        return this.cachedIdentifiers.get(identifier.toUpperCase());
    }

    public Set<String> getExpressionFactoryIds() {
        if (this.cachedFactories == null) {
            this.cachedFactories = new HashSet<String>();
            this.cachedFactories.addAll(this.expressionFactories);
            for (JPQLQueryBNF queryBNF : this.children()) {
                if (queryBNF == this) continue;
                this.cachedFactories.addAll(queryBNF.getExpressionFactoryIds());
            }
            this.cachedFactories = Collections.unmodifiableSet(this.cachedFactories);
        }
        return this.cachedFactories;
    }

    public ExpressionRegistry getExpressionRegistry() {
        return this.expressionRegistry;
    }

    public String getFallbackBNFId() {
        return this.fallbackBNFId;
    }

    public String getFallbackExpressionFactoryId() {
        return this.fallbackExpressionFactoryId;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getIdentifiers() {
        this.populateIdentifiers();
        return this.cachedIdentifiers.keySet();
    }

    public boolean handleAggregate() {
        if (this.handleAggregate == null) {
            this.handleAggregate = this.calculateHandleAggregate();
        }
        return this.handleAggregate;
    }

    public boolean handleCollection() {
        if (this.handleCollection == null) {
            this.handleCollection = this.calculateHandleCollection();
        }
        return this.handleCollection;
    }

    public boolean hasIdentifier(String word) {
        this.populateIdentifiers();
        return this.cachedIdentifiers.containsKey(word);
    }

    protected void initialize() {
    }

    private void initialize(String id) {
        if (id == null) {
            throw new NullPointerException("The unique identifier of this JPQLQueryBNF cannot be null");
        }
        this.id = id;
        this.expressionFactories = new LinkedList<String>();
        this.initialize();
    }

    public boolean isCompound() {
        return this.compound;
    }

    public Set<JPQLQueryBNF> nonCompoundChildren() {
        if (this.childNonCompoundQueryBNFs == null) {
            this.childNonCompoundQueryBNFs = this.buildChildren(this.buildNonCompoundFilter());
            this.childNonCompoundQueryBNFs = Collections.unmodifiableSet(this.childNonCompoundQueryBNFs);
        }
        return this.childNonCompoundQueryBNFs;
    }

    private void populateIdentifiers() {
        if (this.cachedIdentifiers == null) {
            this.cachedIdentifiers = this.buildIdentifiers();
        }
    }

    protected final void registerChild(String queryBNFId) {
        if (queryBNFId == null) {
            throw new NullPointerException("The queryBNFId cannot be null");
        }
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(queryBNFId);
    }

    protected final void registerExpressionFactory(String expressionFactory) {
        this.expressionFactories.add(expressionFactory);
    }

    public void setCompound(boolean compound) {
        this.compound = compound;
    }

    final void setExpressionRegistry(ExpressionRegistry expressionRegistry) {
        this.expressionRegistry = expressionRegistry;
    }

    public void setFallbackBNFId(String fallbackBNFId) {
        this.fallbackBNFId = fallbackBNFId;
    }

    public void setFallbackExpressionFactoryId(String fallbackExpressionFactoryId) {
        this.fallbackExpressionFactoryId = fallbackExpressionFactoryId;
    }

    public void setHandleAggregate(boolean handleAggregate) {
        this.handleAggregate = handleAggregate;
    }

    public void setHandleCollection(boolean handleCollection) {
        this.handleCollection = handleCollection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("(id=");
        sb.append(this.id);
        sb.append(", identifiers=");
        sb.append(this.getIdentifiers());
        sb.append(", expressionFactories=");
        sb.append(this.getExpressionFactoryIds());
        sb.append(")");
    }
}

