/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class AbstractIdentityMap
implements IdentityMap,
Serializable,
Cloneable {
    protected int maxSize;
    protected ClassDescriptor descriptor;
    protected boolean isIsolated;

    public AbstractIdentityMap() {
    }

    public AbstractIdentityMap(int size) {
        this.maxSize = size;
    }

    public AbstractIdentityMap(int size, ClassDescriptor descriptor) {
        this(size);
        this.descriptor = descriptor;
    }

    public AbstractIdentityMap(int size, ClassDescriptor descriptor, boolean isolated) {
        this(size, descriptor);
        this.isIsolated = isolated;
    }

    @Override
    public CacheKey acquireDeferredLock(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, false);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireDeferredLock();
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.releaseDeferredLock();
        }
        cacheKey.acquireDeferredLock();
        return cacheKey;
    }

    @Override
    public CacheKey acquireLock(Object primaryKey, boolean forMerge) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        cacheKey.acquire();
        return cacheKey;
    }

    @Override
    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        if (!cacheKey.acquireNoWait(forMerge)) {
            return null;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        if (!cacheKey.acquireWithWait(forMerge, wait)) {
            return null;
        }
        return cacheKey;
    }

    @Override
    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, false);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        cacheKey.acquireReadLock();
        return cacheKey;
    }

    @Override
    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey, false);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        if (!cacheKey.acquireReadLockNoWait()) {
            return null;
        }
        return cacheKey;
    }

    @Override
    public abstract void collectLocks(HashMap var1);

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
    }

    @Override
    public boolean containsKey(Object primaryKey) {
        return this.getCacheKeyWithReadLock(primaryKey) != null;
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue) {
        return this.createCacheKey(primaryKey, object, writeLockValue, 0L);
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new CacheKey(primaryKey, object, writeLockValue, readTime, this.isIsolated);
    }

    @Override
    public abstract Enumeration elements();

    @Override
    public Object get(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    @Override
    public Map<Object, Object> getAllFromIdentityMapWithEntityPK(Object[] pkList, ClassDescriptor descriptor, AbstractSession session) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        CacheKey cachedObject = null;
        long currentTime = System.currentTimeMillis();
        Object[] objectArray = pkList;
        int n = pkList.length;
        int n2 = 0;
        while (n2 < n) {
            Object pk = objectArray[n2];
            cachedObject = this.getCacheKey(pk, false);
            if (cachedObject != null && cachedObject.getObject() != null && !descriptor.getCacheInvalidationPolicy().isInvalidated(cachedObject, currentTime)) {
                map.put(pk, cachedObject.getObject());
            }
            ++n2;
        }
        return map;
    }

    @Override
    public abstract CacheKey getCacheKey(Object var1, boolean var2);

    @Override
    public CacheKey getCacheKeyForLock(Object primaryKey) {
        return this.getCacheKey(primaryKey, true);
    }

    protected abstract CacheKey putCacheKeyIfAbsent(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Object primaryKey) {
        CacheKey key = this.getCacheKey(primaryKey, false);
        if (key != null) {
            key.checkReadLock();
        }
        return key;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    @Override
    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    @Override
    public abstract int getSize();

    @Override
    public abstract int getSize(Class var1, boolean var2);

    @Override
    public Object getWrapper(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    @Override
    public Object getWriteLockValue(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    @Override
    public abstract Enumeration keys();

    @Override
    public abstract CacheKey put(Object var1, Object var2, Object var3, long var4);

    @Override
    public void release() {
    }

    @Override
    public Object remove(Object primaryKey, Object object) {
        CacheKey key = this.getCacheKeyForLock(primaryKey);
        return this.remove(key);
    }

    @Override
    public abstract Object remove(CacheKey var1);

    protected synchronized void setMaxSize(int size) {
        this.maxSize = size;
    }

    @Override
    public void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
    }

    @Override
    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Class getDescriptorClass() {
        return this.descriptor.getJavaClass();
    }

    @Override
    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void setWrapper(Object primaryKey, Object wrapper) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWrapper(wrapper);
        }
    }

    @Override
    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(writeLockValue);
            cacheKey.release();
        }
    }

    @Override
    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "[" + this.getSize() + "]";
    }
}

