/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorInterfaceAliasPolicy
extends MWAbstractDescriptorPolicy {
    private MWClassHandle interfaceAliasHandle;
    public static final String INTERFACE_ALIAS_PROPERTY = "interfaceAlias";

    private MWDescriptorInterfaceAliasPolicy() {
    }

    public MWDescriptorInterfaceAliasPolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.interfaceAliasHandle = new MWClassHandle(this, this.buildInterfaceAliasScrubber());
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.interfaceAliasHandle);
    }

    private MWHandle.NodeReferenceScrubber buildInterfaceAliasScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInterfaceAliasPolicy.this.setInterfaceAlias(null);
            }

            public String toString() {
                return "MWDescriptorInterfaceAliasPolicy.buildInterfaceAliasScrubber()";
            }
        };
    }

    public MWClass getInterfaceAlias() {
        return this.interfaceAliasHandle.getType();
    }

    public void setInterfaceAlias(MWClass newInterfaceAlias) {
        MWClass oldValue = this.getInterfaceAlias();
        this.interfaceAliasHandle.setType(newInterfaceAlias);
        if (newInterfaceAlias != null) {
            this.getOwningDescriptor().getProject().removeDescriptorForType(newInterfaceAlias);
        }
        this.firePropertyChanged(INTERFACE_ALIAS_PROPERTY, oldValue, this.interfaceAliasHandle.getType());
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        MWClass interfaceAlias = this.getInterfaceAlias();
        if (interfaceAlias != null) {
            runtimeDescriptor.getInterfacePolicy().addParentInterfaceName(this.getInterfaceAlias().getName());
        }
    }

    @Override
    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkInterfaceAlias(problems);
    }

    private void checkInterfaceAlias(List problems) {
        if (this.getInterfaceAlias() == null) {
            problems.add(this.buildProblem("0324"));
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        this.getInterfaceAlias().toString(sb);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorInterfaceAliasPolicy.class);
        XMLCompositeObjectMapping interfaceAliasHandleMapping = new XMLCompositeObjectMapping();
        interfaceAliasHandleMapping.setAttributeName("interfaceAliasHandle");
        interfaceAliasHandleMapping.setSetMethodName("setInterfaceAliasHandleForTopLink");
        interfaceAliasHandleMapping.setGetMethodName("getInterfaceAliasHandleForTopLink");
        interfaceAliasHandleMapping.setReferenceClass(MWClassHandle.class);
        interfaceAliasHandleMapping.setXPath("interface-alias-type-handle");
        descriptor.addMapping((DatabaseMapping)interfaceAliasHandleMapping);
        return descriptor;
    }

    private MWClassHandle getInterfaceAliasHandleForTopLink() {
        return this.interfaceAliasHandle.getType() == null ? null : this.interfaceAliasHandle;
    }

    private void setInterfaceAliasHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildInterfaceAliasScrubber();
        this.interfaceAliasHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

