/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.CursorPolicy;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class Cursor
implements Enumeration,
Iterator,
Serializable {
    protected transient Statement statement;
    protected transient ResultSet resultSet;
    protected transient AbstractSession session;
    protected transient AbstractSession executionSession;
    protected transient Vector<DatabaseField> fields;
    protected int size = -1;
    public transient ReadQuery query;
    public transient CursorPolicy policy;
    protected List<Object> objectCollection;
    protected Map<Object, Object> initiallyConformingIndex;
    protected Expression selectionCriteriaClone;
    protected AbstractRecord translationRow;
    protected AbstractRecord nextRow;
    protected int position;

    public Cursor() {
    }

    public Cursor(DatabaseCall call, CursorPolicy policy) {
        ReadQuery query;
        this.query = query = policy.getQuery();
        this.session = query.getSession();
        this.executionSession = this.session.getExecutionSession(query);
        this.statement = call.getStatement();
        this.fields = call.getFields();
        this.resultSet = call.getResult();
        this.policy = policy;
        this.objectCollection = new Vector<Object>();
        if (query.getSession().isUnitOfWork() && query.isObjectLevelReadQuery()) {
            ((ObjectLevelReadQuery)query).registerResultInUnitOfWork(this, (UnitOfWorkImpl)this.session, query.getTranslationRow(), false);
        }
    }

    public void close() throws DatabaseException {
        RuntimeException exception = null;
        try {
            block18: {
                block20: {
                    if (this.isClosed()) {
                        return;
                    }
                    try {
                        try {
                            this.getAccessor().closeCursor(this.resultSet, this.session);
                            this.getAccessor().closeStatement(this.statement, this.session, null);
                        }
                        catch (RuntimeException caughtException) {
                            block17: {
                                exception = caughtException;
                                try {
                                    this.session.releaseReadConnection(this.query.getAccessor());
                                }
                                catch (RuntimeException releaseException) {
                                    if (exception != null) break block17;
                                    throw releaseException;
                                }
                            }
                            if (exception != null) {
                                throw exception;
                            }
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        block19: {
                            try {
                                this.session.releaseReadConnection(this.query.getAccessor());
                            }
                            catch (RuntimeException releaseException) {
                                if (exception != null) break block19;
                                throw releaseException;
                            }
                        }
                        if (exception != null) {
                            throw exception;
                        }
                        throw throwable;
                    }
                    try {
                        this.session.releaseReadConnection(this.query.getAccessor());
                    }
                    catch (RuntimeException releaseException) {
                        if (exception != null) break block20;
                        throw releaseException;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            this.statement = null;
            this.resultSet = null;
            this.nextRow = null;
        }
        catch (SQLException sqlException) {
            throw DatabaseException.sqlException(sqlException, this.getAccessor(), this.getSession(), false);
        }
    }

    protected void finalize() throws DatabaseException {
        this.close();
    }

    public DatabaseAccessor getAccessor() {
        try {
            return (DatabaseAccessor)this.query.getAccessor();
        }
        catch (ClassCastException classCastException) {
            throw QueryException.invalidDatabaseAccessor(this.query.getAccessor());
        }
    }

    protected abstract int getCursorSize() throws DatabaseException, QueryException;

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public Map<Object, Object> getInitiallyConformingIndex() {
        return this.initiallyConformingIndex;
    }

    public List<Object> getObjectCollection() {
        return this.objectCollection;
    }

    public int getPageSize() {
        return this.policy.getPageSize();
    }

    public CursorPolicy getPolicy() {
        return this.policy;
    }

    public abstract int getPosition();

    public ReadQuery getQuery() {
        return this.query;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Expression getSelectionCriteriaClone() {
        return this.selectionCriteriaClone;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public AbstractSession getExecutionSession() {
        return this.executionSession;
    }

    protected Statement getStatement() {
        return this.statement;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public boolean isClosed() {
        return this.resultSet == null;
    }

    protected Object buildAndRegisterObject(AbstractRecord row) {
        ReadQuery query = this.query;
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectQuery = (ObjectLevelReadQuery)query;
            if (objectQuery.hasBatchReadAttributes() && objectQuery.getBatchFetchPolicy().isIN()) {
                objectQuery.getBatchFetchPolicy().addDataResults(row);
            }
            if (this.session.isUnitOfWork() && !query.isReportQuery() && query.shouldMaintainCache() && (objectQuery.shouldConformResultsInUnitOfWork() || objectQuery.getDescriptor().shouldAlwaysConformResultsInUnitOfWork())) {
                Object object = objectQuery.conformIndividualResult(objectQuery.buildObject(row), (UnitOfWorkImpl)this.session, this.translationRow, this.selectionCriteriaClone, this.initiallyConformingIndex);
                if (object == null) {
                    return InvalidObject.instance;
                }
                return object;
            }
        }
        return query.buildObject(row);
    }

    protected abstract Object retrieveNextObject() throws DatabaseException;

    protected void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setInitiallyConformingIndex(Map<Object, Object> index) {
        this.initiallyConformingIndex = index;
    }

    public void setObjectCollection(List<Object> collection) {
        this.objectCollection = collection;
    }

    public void setPolicy(CursorPolicy policy) {
        this.policy = policy;
    }

    protected void setPosition(int value) {
        this.position = value;
    }

    protected void setResultSet(ResultSet result) {
        this.resultSet = result;
    }

    public void setSelectionCriteriaClone(Expression expression) {
        this.selectionCriteriaClone = expression;
    }

    public void setSession(AbstractSession databaseSession) {
        this.session = databaseSession;
    }

    protected void setExecutionSession(AbstractSession executionSession) {
        this.executionSession = executionSession;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setTranslationRow(AbstractRecord row) {
        this.translationRow = row;
    }

    public int size() throws DatabaseException {
        if (this.size == -1) {
            this.size = this.getCursorSize();
            if (this.initiallyConformingIndex != null) {
                this.size += this.initiallyConformingIndex.size();
            }
        }
        return this.size;
    }

    @Override
    public void remove() throws QueryException {
        QueryException.invalidOperation("remove");
    }

    public void clear() {
        if (this.query != null && this.query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.query).hasJoining()) {
            ((ObjectLevelReadQuery)this.query).getJoinedAttributeManager().clearDataResults();
        }
    }
}

