/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.LinkAdapter;

public class StreamingOutputMarshaller
implements StreamingOutput {
    private PersistenceContext context;
    private Object result;
    private MediaType mediaType;

    public StreamingOutputMarshaller(PersistenceContext context, Object result, MediaType acceptedType) {
        this.context = context;
        this.result = result;
        this.mediaType = acceptedType;
    }

    public StreamingOutputMarshaller(PersistenceContext context, Object result, List<MediaType> acceptedTypes) {
        this(context, result, StreamingOutputMarshaller.mediaType(acceptedTypes));
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        if (this.result instanceof byte[]) {
            output.write((byte[])this.result);
        } else if (this.result instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            writer.write((String)this.result);
            writer.flush();
            writer.close();
        } else {
            if (this.context != null && this.context.getJAXBContext() != null && this.result != null) {
                JAXBException initialException;
                block10: {
                    try {
                        this.context.marshallEntity(this.result, this.mediaType, output);
                        return;
                    }
                    catch (JAXBException e) {
                        initialException = e;
                        if (!(this.result instanceof List)) break block10;
                        ArrayList<JAXBElement> returnList = new ArrayList<JAXBElement>(((List)this.result).size());
                        List resultAsList = (List)this.result;
                        try {
                            for (Object object : resultAsList) {
                                JAXBElement jaxbResult = new JAXBElement(new QName("result"), object.getClass(), object);
                                returnList.add(jaxbResult);
                            }
                            this.context.marshallEntity(returnList, this.mediaType, output);
                            return;
                        }
                        catch (JAXBException ex) {
                            JPARSLogger.fine("jaxb_exception_while_marshalling", new Object[]{ex.toString()});
                        }
                    }
                }
                initialException.printStackTrace();
                JPARSLogger.fine("jpars_could_not_marshal_serializing", new Object[]{initialException});
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.result);
            oos.flush();
            oos.close();
            output.write(baos.toByteArray());
        }
    }

    public static MediaType mediaType(List<?> types) {
        if (StreamingOutputMarshaller.contains(types, MediaType.APPLICATION_JSON_TYPE)) {
            return MediaType.APPLICATION_JSON_TYPE;
        }
        if (StreamingOutputMarshaller.contains(types, MediaType.APPLICATION_XML_TYPE)) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        return MediaType.WILDCARD_TYPE;
    }

    private static boolean contains(List<?> types, MediaType type) {
        for (Object mt : types) {
            if (!(mt instanceof String ? ((String)mt).contains(type.toString()) : ((MediaType)mt).equals((Object)type))) continue;
            return true;
        }
        return false;
    }

    public static Marshaller createMarshaller(PersistenceContext context, MediaType mediaType) throws JAXBException {
        JAXBMarshaller marshaller = context.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", (Object)false);
        marshaller.setAdapter((XmlAdapter)new LinkAdapter(context.getBaseURI().toString(), context));
        marshaller.setListener(new Marshaller.Listener(){

            public void beforeMarshal(Object source) {
                if (source instanceof DynamicEntity) {
                    DynamicEntityImpl sourceImpl = (DynamicEntityImpl)source;
                    PropertyChangeListener listener = sourceImpl._persistence_getPropertyChangeListener();
                    sourceImpl._persistence_setPropertyChangeListener(null);
                    ((DynamicEntity)source).set("self", source);
                    sourceImpl._persistence_setPropertyChangeListener(listener);
                }
            }
        });
        return marshaller;
    }
}

