/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ConstructorResult
extends SQLResult {
    protected Class targetClass;
    protected List<ColumnResult> columnResults = new ArrayList<ColumnResult>();
    protected Constructor constructor;
    protected Class[] constructorArgTypes;

    protected ConstructorResult() {
    }

    public ConstructorResult(Class targetClass) {
        this();
        if (targetClass == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_constructor_result"));
        }
        this.targetClass = targetClass;
    }

    public void addColumnResult(ColumnResult columnResult) {
        this.columnResults.add(columnResult);
    }

    public List<ColumnResult> getColumnResults() {
        return this.columnResults;
    }

    @Override
    public Object getValueFromRecord(DatabaseRecord record, ResultSetMappingQuery query) {
        if (this.constructor == null) {
            this.initialize(record, query);
        }
        int columnResultsSize = this.getColumnResults().size();
        Object[] constructorArgs = new Object[columnResultsSize];
        int i = 0;
        while (i < columnResultsSize) {
            constructorArgs[i] = ConversionManager.getDefaultManager().convertObject(record.get(this.getColumnResults().get(i).getColumn()), this.constructorArgTypes[i]);
            ++i;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.constructor, constructorArgs));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.exceptionWhileInitializingConstructor(exception.getException(), query, this.targetClass);
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.constructor, constructorArgs);
        }
        catch (IllegalAccessException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
        catch (InvocationTargetException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
        catch (InstantiationException exception) {
            throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
        }
    }

    protected void initialize(DatabaseRecord record, ResultSetMappingQuery query) {
        block6: {
            int columnResultsSize = this.getColumnResults().size();
            this.constructorArgTypes = new Class[columnResultsSize];
            int i = 0;
            while (i < columnResultsSize) {
                ColumnResult result = this.getColumnResults().get(i);
                DatabaseField resultField = result.getColumn();
                this.constructorArgTypes[i] = resultField.getType() == null ? record.get(resultField).getClass() : resultField.getType();
                ++i;
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.targetClass, this.constructorArgTypes, true));
                        break block6;
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.exceptionWhileInitializingConstructor(exception.getException(), query, this.targetClass);
                    }
                }
                this.constructor = PrivilegedAccessHelper.getConstructorFor(this.targetClass, this.constructorArgTypes, true);
            }
            catch (NoSuchMethodException exception) {
                throw QueryException.exceptionWhileInitializingConstructor(exception, query, this.targetClass);
            }
        }
    }

    @Override
    public boolean isConstructorResult() {
        return true;
    }

    public void setColumnResults(List<ColumnResult> columnResults) {
        this.columnResults = columnResults;
    }
}

