/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;

public class ReadPreference {
    public static ReadPreference PRIMARY = new PrimaryReadPreference();
    public static ReadPreference SECONDARY = new SecondaryReadPreference();

    public static class PrimaryReadPreference
    extends ReadPreference {
        private PrimaryReadPreference() {
        }

        public String toString() {
            return "ReadPreference.PRIMARY";
        }
    }

    public static class SecondaryReadPreference
    extends ReadPreference {
        private SecondaryReadPreference() {
        }

        public String toString() {
            return "ReadPreference.SECONDARY";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaggedReadPreference
    extends ReadPreference {
        private final DBObject _tags;

        public TaggedReadPreference(DBObject tags) {
            this._tags = tags;
        }

        public TaggedReadPreference(Map<String, String> tags) {
            this._tags = new BasicDBObject(tags);
        }

        public DBObject getTags() {
            return this._tags;
        }

        public String toString() {
            return this.getTags().toString();
        }
    }
}

