/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inherited;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inherited.Accredidation;
import org.eclipse.persistence.testing.models.jpa.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.inherited.Becks;
import org.eclipse.persistence.testing.models.jpa.inherited.BecksTag;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Birthday;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.BlueLight;
import org.eclipse.persistence.testing.models.jpa.inherited.BuildingBylaw;
import org.eclipse.persistence.testing.models.jpa.inherited.Bylaw;
import org.eclipse.persistence.testing.models.jpa.inherited.CityNumberPair;
import org.eclipse.persistence.testing.models.jpa.inherited.Committee;
import org.eclipse.persistence.testing.models.jpa.inherited.CommitteeDates;
import org.eclipse.persistence.testing.models.jpa.inherited.Corona;
import org.eclipse.persistence.testing.models.jpa.inherited.CoronaTag;
import org.eclipse.persistence.testing.models.jpa.inherited.ExpertBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Heineken;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.inherited.Location;
import org.eclipse.persistence.testing.models.jpa.inherited.NodeImpl;
import org.eclipse.persistence.testing.models.jpa.inherited.NoiseBylaw;
import org.eclipse.persistence.testing.models.jpa.inherited.NoviceBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Official;
import org.eclipse.persistence.testing.models.jpa.inherited.OfficialEntry;
import org.eclipse.persistence.testing.models.jpa.inherited.Record;
import org.eclipse.persistence.testing.models.jpa.inherited.RedStripe;
import org.eclipse.persistence.testing.models.jpa.inherited.SerialNumber;
import org.eclipse.persistence.testing.models.jpa.inherited.ServiceTime;
import org.eclipse.persistence.testing.models.jpa.inherited.Venue;
import org.eclipse.persistence.testing.models.jpa.inherited.Witness;

public class InheritedModelJunitTest
extends JUnitTestCase {
    private static BigDecimal m_blueId;
    private static Integer m_beerConsumerId;
    private static Integer m_noviceBeerConsumerId;
    private static Integer m_expertBeerConsumerId;
    private static Timestamp m_quote1Stamp;
    private static final String QUOTE_ONE = "Beer is blood";
    private static Timestamp m_quote2Stamp;
    private static final String QUOTE_TWO = "My first wife was a beer";

    public InheritedModelJunitTest() {
    }

    public InheritedModelJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritedModelJunitTest");
        suite.addTest((Test)new InheritedModelJunitTest("testSetup"));
        suite.addTest((Test)new InheritedModelJunitTest("testCreateBlue"));
        suite.addTest((Test)new InheritedModelJunitTest("testReadBlue"));
        suite.addTest((Test)new InheritedModelJunitTest("testCreateBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testCreateNoviceBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testReadNoviceBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testOrderColumnNoviceBeerConsumerDesignations"));
        suite.addTest((Test)new InheritedModelJunitTest("testCreateExpertBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testDeleteMiddleRecordOfExpertBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testReadExpertBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testExpertBeerConsumerRecordsCRUD"));
        suite.addTest((Test)new InheritedModelJunitTest("testUpdateBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testInheritedClone"));
        suite.addTest((Test)new InheritedModelJunitTest("testCascadeRemove"));
        suite.addTest((Test)new InheritedModelJunitTest("testHeinekenBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testBecksBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testCoronaBeerConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testRedStripeExpertConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testRedStripeNoviceConsumer"));
        suite.addTest((Test)new InheritedModelJunitTest("testBreakOrder_CorrectionType_EXCEPTION"));
        suite.addTest((Test)new InheritedModelJunitTest("testBreakOrder_CorrectionType_READ_WRITE"));
        suite.addTest((Test)new InheritedModelJunitTest("testMapOrphanRemoval"));
        suite.addTest((Test)new InheritedModelJunitTest("testSerializedElementCollectionMap"));
        suite.addTest((Test)new InheritedModelJunitTest("testVersionUpdateOnElementCollectionChange"));
        suite.addTest((Test)new InheritedModelJunitTest("testAddToHeinekenBeerConsumerMap"));
        suite.addTest((Test)new InheritedModelJunitTest("testColumnUpdatableAndInsertable"));
        suite.addTest((Test)new InheritedModelJunitTest("testColumnUpdatableAndInsertableThroughQuery"));
        suite.addTest((Test)new InheritedModelJunitTest("testElementCollectionMapEmbeddable"));
        suite.addTest((Test)new InheritedModelJunitTest("testMultipleIdButNonIdClassEntity"));
        suite.addTest((Test)new InheritedModelJunitTest("testRelatedBylawWrite"));
        suite.addTest((Test)new InheritedModelJunitTest("testInterfaceBylawWrite"));
        suite.addTest((Test)new InheritedModelJunitTest("testEmbeddableAggregateCollectionAndAggregate"));
        suite.addTest((Test)new InheritedModelJunitTest("testNodeImplWeaving"));
        return suite;
    }

    public void testSetup() {
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testMultipleIdButNonIdClassEntity() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        NoiseBylaw noiseBylaw = new NoiseBylaw();
        int noiseBylawId = 0;
        BuildingBylaw buildingBylaw = new BuildingBylaw();
        int buildingBylawId = 0;
        try {
            noiseBylaw.setCity("Ottawa");
            noiseBylaw.setDescription("Can't mow your grass after 9PM!");
            em.persist((Object)noiseBylaw);
            buildingBylaw.setCity("Ottawa");
            buildingBylaw.setDescription("Can't build without a permit");
            em.persist((Object)buildingBylaw);
            noiseBylawId = noiseBylaw.getNumber();
            buildingBylawId = buildingBylaw.getNumber();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        String jpqlString = "SELECT n FROM NoiseBylaw n WHERE n.number =" + noiseBylawId;
        NoiseBylaw refreshedNoiseBylaw = (NoiseBylaw)em.createQuery(jpqlString).getSingleResult();
        InheritedModelJunitTest.assertTrue((String)"The noise bylaw read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)noiseBylaw, (Object)refreshedNoiseBylaw));
        String jpqlString2 = "SELECT n FROM BuildingBylaw n WHERE n.number =" + buildingBylawId;
        BuildingBylaw refreshedBuildingBylaw = (BuildingBylaw)em.createQuery(jpqlString2).getSingleResult();
        InheritedModelJunitTest.assertTrue((String)"The building bylaw read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)buildingBylaw, (Object)refreshedBuildingBylaw));
        this.closeEntityManager(em);
    }

    public void testBecksBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Becks becks1 = new Becks();
            becks1.setAlcoholContent((Object)5.1);
            BecksTag becksTag1 = new BecksTag();
            becksTag1.setCallNumber("0A.789");
            em.persist((Object)becksTag1);
            Becks becks2 = new Becks();
            becks2.setAlcoholContent((Object)5.1);
            BecksTag becksTag2 = new BecksTag();
            becksTag2.setCallNumber("BX.521");
            em.persist((Object)becksTag2);
            Becks becks3 = new Becks();
            becks3.setAlcoholContent((Object)5.1);
            BecksTag becksTag3 = new BecksTag();
            becksTag3.setCallNumber("UY.429");
            em.persist((Object)becksTag3);
            initialBC.setName("Becks Consumer");
            initialBC.addBecksBeerToConsume(becks1, becksTag1);
            initialBC.addBecksBeerToConsume(becks2, becksTag2);
            initialBC.addBecksBeerToConsume(becks3, becksTag3);
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void testCoronaBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Corona corona1 = new Corona();
            corona1.setAlcoholContent((Object)5.3);
            CoronaTag coronaTag1 = new CoronaTag();
            coronaTag1.setCode("0A");
            coronaTag1.setNumber(Integer.valueOf(789));
            Corona corona2 = new Corona();
            corona2.setAlcoholContent((Object)5.3);
            CoronaTag coronaTag2 = new CoronaTag();
            coronaTag2.setCode("BX");
            coronaTag2.setNumber(Integer.valueOf(521));
            Corona corona3 = new Corona();
            corona3.setAlcoholContent((Object)5.3);
            CoronaTag coronaTag3 = new CoronaTag();
            coronaTag3.setCode("UY");
            coronaTag3.setNumber(Integer.valueOf(429));
            initialBC.setName("Corona Consumer");
            initialBC.addCoronaBeerToConsume(corona1, coronaTag1);
            initialBC.addCoronaBeerToConsume(corona2, coronaTag2);
            initialBC.addCoronaBeerToConsume(corona3, coronaTag3);
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void testCreateBlue() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Blue blue = new Blue();
            blue.setAlcoholContent((Object)new Float(5.3));
            em.persist((Object)blue);
            m_blueId = (BigDecimal)blue.getId();
            blue.setUniqueKey(m_blueId.toBigInteger());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testOrderColumnNoviceBeerConsumerDesignations() {
        NoviceBeerConsumer beerConsumer;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            beerConsumer = (NoviceBeerConsumer)em.find(NoviceBeerConsumer.class, (Object)m_noviceBeerConsumerId);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_noviceBeerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The novice beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    public void testReadBlue() {
        Blue blue = (Blue)this.createEntityManager().find(Blue.class, (Object)m_blueId);
        InheritedModelJunitTest.assertTrue((String)"Error on reading back a Blue beer", (blue != null ? 1 : 0) != 0);
    }

    public void testCreateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = new BeerConsumer();
            beerConsumer.setName("Blue Consumer");
            em.persist((Object)beerConsumer);
            m_beerConsumerId = beerConsumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testCreateNoviceBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        NoviceBeerConsumer beerConsumer = new NoviceBeerConsumer();
        try {
            beerConsumer.setName("Novice Beer Consumer");
            beerConsumer.setIQ(100);
            beerConsumer.getAcclaims().add(1);
            beerConsumer.getAcclaims().add(2);
            beerConsumer.getAcclaims().add(3);
            beerConsumer.getAwards().put(1, 1);
            beerConsumer.getAwards().put(2, 2);
            beerConsumer.getAwards().put(3, 3);
            beerConsumer.getDesignations().add("5");
            beerConsumer.getDesignations().add("4");
            beerConsumer.getDesignations().add("2");
            beerConsumer.getDesignations().add("3");
            beerConsumer.getDesignations().add("1");
            Record record1 = new Record();
            record1.setDescription("Slowest beer ever consumed - 10 hours");
            record1.setDate(Helper.dateFromYearMonthDate((int)2008, (int)1, (int)1));
            record1.setLocation(new Location("Paris", "France"));
            Venue venue1 = new Venue();
            venue1.setAttendance(Integer.valueOf(10));
            venue1.setName("Champs-Elysees");
            record1.setVenue(venue1);
            beerConsumer.getRecords().add(record1);
            Accredidation accredidation = new Accredidation();
            accredidation.setDetails("Superb, just superb!");
            Witness witness1 = new Witness();
            witness1.setName("Mickey Blue Eyes");
            accredidation.addWitness(witness1);
            Witness witness2 = new Witness();
            witness2.setName("Donny Trafalgo");
            accredidation.addWitness(witness2);
            beerConsumer.setAccredidation(accredidation);
            Committee committee1 = new Committee();
            committee1.setDescription("Moral labelling");
            beerConsumer.addCommittee(committee1);
            Committee committee2 = new Committee();
            committee2.setDescription("Crimes against beer");
            beerConsumer.addCommittee(committee2);
            Committee committee3 = new Committee();
            committee3.setDescription("BADD - Beers against drunk dorks");
            beerConsumer.addCommittee(committee3);
            em.persist((Object)beerConsumer);
            m_noviceBeerConsumerId = beerConsumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation for a novice beer consumer: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_noviceBeerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The novice beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    public void testCreateExpertBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer beerConsumer = new ExpertBeerConsumer();
        try {
            beerConsumer.setName("Expert Beer Consumer");
            beerConsumer.setIQ(110);
            beerConsumer.getAcclaims().add("A");
            beerConsumer.getAcclaims().add("B");
            beerConsumer.getAcclaims().add("C");
            beerConsumer.getAwards().put("A", "A");
            beerConsumer.getAwards().put("B", "B");
            beerConsumer.getAwards().put("C", "C");
            beerConsumer.getDesignations().add("A");
            beerConsumer.getDesignations().add("B");
            m_quote1Stamp = Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1));
            beerConsumer.getQuotes().put(m_quote1Stamp, QUOTE_ONE);
            m_quote2Stamp = Helper.timestampFromDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)7, (int)9));
            beerConsumer.getQuotes().put(m_quote2Stamp, QUOTE_TWO);
            Record record1 = new Record();
            record1.setDescription("Fastest beer ever consumed - 10 ms");
            record1.setDate(Helper.dateFromYearMonthDate((int)2009, (int)10, (int)10));
            record1.setLocation(new Location("Ottawa", "Canada"));
            Venue venue1 = new Venue();
            venue1.setAttendance(Integer.valueOf(10000));
            venue1.setName("Scotiabank PLace");
            record1.setVenue(venue1);
            beerConsumer.getRecords().add(record1);
            Record record2 = new Record();
            record2.setDescription("Most beers consumed upside down - 12");
            record2.setDate(Helper.dateFromYearMonthDate((int)2007, (int)11, (int)11));
            record2.setLocation(new Location("Sydney", "Australia"));
            Venue venue2 = new Venue();
            venue2.setAttendance(Integer.valueOf(2678));
            venue2.setName("Opera House");
            record2.setVenue(venue2);
            beerConsumer.getRecords().add(record2);
            Record record3 = new Record();
            record3.setDescription("Most beers consumed in a second - 5");
            record3.setDate(Helper.dateFromYearMonthDate((int)2005, (int)12, (int)12));
            record3.setLocation(new Location("Miami", "USA"));
            Venue venue3 = new Venue();
            venue3.setAttendance(Integer.valueOf(63000));
            venue3.setName("Dolphin Stadium");
            record3.setVenue(venue3);
            beerConsumer.getRecords().add(record3);
            Accredidation accredidation = new Accredidation();
            accredidation.setDetails("Elite, absolutely elite!");
            Witness witness1 = new Witness();
            witness1.setName("Big Bobby");
            accredidation.addWitness(witness1);
            Witness witness2 = new Witness();
            witness2.setName("Little Bobby");
            accredidation.addWitness(witness2);
            Official official = new Official();
            official.setName("Authority Joe");
            accredidation.addOfficial(official);
            beerConsumer.setAccredidation(accredidation);
            Birthday birthday1 = new Birthday();
            birthday1.setDay(Integer.valueOf(9));
            birthday1.setMonth(Integer.valueOf(7));
            birthday1.setYear(Integer.valueOf(2005));
            beerConsumer.addCelebration(birthday1, "Drank a 24 of Heineken");
            Birthday birthday2 = new Birthday();
            birthday2.setDay(Integer.valueOf(10));
            birthday2.setMonth(Integer.valueOf(7));
            birthday2.setYear(Integer.valueOf(2006));
            beerConsumer.addCelebration(birthday2, "Drank a 24 of Becks");
            Committee committee1 = new Committee();
            committee1.setDescription("New beer committee");
            CommitteeDates committee1Dates = new CommitteeDates();
            committee1Dates.setStartDate("Jan 1, 2010");
            committee1.setCommitteeDates(committee1Dates);
            beerConsumer.addCommittee(committee1);
            Committee committee2 = new Committee();
            committee2.setDescription("Alcohol content regulation");
            CommitteeDates committee2Dates = new CommitteeDates();
            committee2Dates.setStartDate("Jan 1, 1970");
            committee2Dates.setEndDate("Jan 1, 2001");
            committee2.setCommitteeDates(committee2Dates);
            beerConsumer.addCommittee(committee2);
            em.persist((Object)beerConsumer);
            m_expertBeerConsumerId = beerConsumer.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation for an expert beer consumer: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_expertBeerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The expert beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)beerConsumer, (Object)refreshedBC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMiddleRecordOfExpertBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpertBeerConsumer beerConsumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            beerConsumer.getRecords().remove(1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            this.clearCache();
        }
    }

    public void testHeinekenBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Heineken heineken1 = new Heineken();
            heineken1.setAlcoholContent((Object)5.0);
            Heineken heineken2 = new Heineken();
            heineken2.setAlcoholContent((Object)5.0);
            Heineken heineken3 = new Heineken();
            heineken3.setAlcoholContent((Object)5.0);
            initialBC.setName("Heineken Consumer");
            Calendar cal = Calendar.getInstance();
            cal.set(2008, 12, 12);
            initialBC.addHeinekenBeerToConsume(heineken1, cal.getTime());
            cal.set(2009, 1, 1);
            initialBC.addHeinekenBeerToConsume(heineken2, cal.getTime());
            cal.set(2009, 2, 2);
            initialBC.addHeinekenBeerToConsume(heineken3, cal.getTime());
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialBC, (Object)refreshedBC));
    }

    public void testReadNoviceBeerConsumer() {
        NoviceBeerConsumer consumer = (NoviceBeerConsumer)this.createEntityManager().find(NoviceBeerConsumer.class, (Object)m_noviceBeerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"Error on reading back a NoviceBeerConsumer", (consumer != null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"IQ Level was not persisted.", (consumer.getIQ() == 100 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of acclaims returned.", (consumer.getAcclaims().size() == 3 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - 1", (boolean)consumer.getAcclaims().contains(1));
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - 2", (boolean)consumer.getAcclaims().contains(2));
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - 3", (boolean)consumer.getAcclaims().contains(3));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of awards returned.", (consumer.getAwards().size() == 3 ? 1 : 0) != 0);
        Integer awardCode = (Integer)consumer.getAwards().get(1);
        InheritedModelJunitTest.assertFalse((String)"Missing award code - 1", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code 1 is incorrect", (boolean)awardCode.equals(1));
        awardCode = (Integer)consumer.getAwards().get(2);
        InheritedModelJunitTest.assertFalse((String)"Missing award code - 2", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code 2 is incorrect", (boolean)awardCode.equals(2));
        awardCode = (Integer)consumer.getAwards().get(3);
        InheritedModelJunitTest.assertFalse((String)"Missing award code - 3", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code 3 is incorrect", (boolean)awardCode.equals(3));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of designations returned.", (consumer.getDesignations().size() == 5 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Missing designation - 5 at index 0", (boolean)((String)consumer.getDesignations().get(0)).equals("5"));
        InheritedModelJunitTest.assertTrue((String)"Missing designation - 4 at index 1", (boolean)((String)consumer.getDesignations().get(1)).equals("4"));
        InheritedModelJunitTest.assertTrue((String)"Missing designation - 2 at index 2", (boolean)((String)consumer.getDesignations().get(2)).equals("2"));
        InheritedModelJunitTest.assertTrue((String)"Missing designation - 3 at index 3", (boolean)((String)consumer.getDesignations().get(3)).equals("3"));
        InheritedModelJunitTest.assertTrue((String)"Missing designation - 1 at index 4", (boolean)((String)consumer.getDesignations().get(4)).equals("1"));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of records returned.", (consumer.getRecords().size() == 1 ? 1 : 0) != 0);
    }

    public void testReadExpertBeerConsumer() {
        ExpertBeerConsumer consumer = (ExpertBeerConsumer)this.createEntityManager().find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"Error on reading back an ExpertBeerConsumer", (consumer != null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"IQ Level was not persisted.", (consumer.getIQ() == 110 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of acclaims returned.", (consumer.getAcclaims().size() == 3 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - A", (boolean)consumer.getAcclaims().contains("A"));
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - B", (boolean)consumer.getAcclaims().contains("B"));
        InheritedModelJunitTest.assertTrue((String)"Missing acclaim - C", (boolean)consumer.getAcclaims().contains("C"));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of awards returned.", (consumer.getAwards().size() == 3 ? 1 : 0) != 0);
        String awardCode = (String)consumer.getAwards().get("A");
        InheritedModelJunitTest.assertFalse((String)"Missing award code - A", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code A is incorrect", (boolean)awardCode.equals("A"));
        awardCode = (String)consumer.getAwards().get("B");
        InheritedModelJunitTest.assertFalse((String)"Missing award code - B", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code B is incorrect", (boolean)awardCode.equals("B"));
        awardCode = (String)consumer.getAwards().get("C");
        InheritedModelJunitTest.assertFalse((String)"Missing award code - C", (awardCode == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Award code C is incorrect", (boolean)awardCode.equals("C"));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of designations returned.", (consumer.getDesignations().size() == 2 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Missing designation - A", (boolean)consumer.getDesignations().contains("A"));
        InheritedModelJunitTest.assertTrue((String)"Missing designation - B", (boolean)consumer.getDesignations().contains("B"));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of quotes returned.", (consumer.getQuotes().size() == 2 ? 1 : 0) != 0);
        String quote = (String)consumer.getQuotes().get(m_quote1Stamp);
        InheritedModelJunitTest.assertFalse((String)"Missing quote from Jan 1, 2009", (quote == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Quote from Jan 1, 2009 was incorrect", (boolean)quote.equals(QUOTE_ONE));
        quote = (String)consumer.getQuotes().get(m_quote2Stamp);
        InheritedModelJunitTest.assertFalse((String)"Missing quote from Jul 9, 2005", (quote == null ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Quote from Jul 9, 2005 was incorrect", (boolean)quote.equals(QUOTE_TWO));
        InheritedModelJunitTest.assertTrue((String)"Incorrect number of records returned.", (consumer.getRecords().size() == 2 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"Incorrect first record", (boolean)((Record)consumer.getRecords().get(0)).getDescription().equals("Fastest beer ever consumed - 10 ms"));
        InheritedModelJunitTest.assertTrue((String)"Incorrect last record", (boolean)((Record)consumer.getRecords().get(1)).getDescription().equals("Most beers consumed in a second - 5"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpertBeerConsumerRecordsCRUD() {
        String errorMsg = "";
        int nRecordsExpected = 2;
        this.clearCache();
        EntityManager em = this.createEntityManager();
        try {
            String name;
            String description;
            this.beginTransaction(em);
            ExpertBeerConsumer consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            int nRecords = consumer.getRecords().size();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            if (nRecords != nRecordsExpected) {
                errorMsg = errorMsg + "wrong number of records after read; ";
            }
            em = this.createEntityManager();
            this.beginTransaction(em);
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            Record recordToRemove = (Record)consumer.getRecords().iterator().next();
            consumer.getRecords().remove(recordToRemove);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != --nRecordsExpected) {
                errorMsg = errorMsg + "cache: wrong number of records after remove; ";
            }
            this.clearCache();
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != nRecordsExpected) {
                errorMsg = errorMsg + "db: wrong number of records after remove; ";
            }
            Record record1 = new Record();
            record1.setDescription("Original");
            record1.setDate(Helper.dateFromYearMonthDate((int)2009, (int)1, (int)1));
            record1.setLocation(new Location("Ottawa", "Canada"));
            Venue venue1 = new Venue();
            venue1.setAttendance(Integer.valueOf(10));
            venue1.setName("Original");
            record1.setVenue(venue1);
            em = this.createEntityManager();
            this.beginTransaction(em);
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            consumer.getRecords().add(record1);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != ++nRecordsExpected) {
                errorMsg = errorMsg + "cache: wrong number of records after add; ";
            }
            this.clearCache();
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != nRecordsExpected) {
                errorMsg = errorMsg + "db: wrong number of records after add; ";
            }
            String newDescription = "New Description ";
            String newName = "New Name ";
            em = this.createEntityManager();
            this.beginTransaction(em);
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            int i = 0;
            for (Record record : consumer.getRecords()) {
                String index = Integer.toString(i++);
                record.setDescription(newDescription + index);
                record.getVenue().setName(newName + index);
            }
            this.commitTransaction(em);
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != nRecordsExpected) {
                errorMsg = errorMsg + "cache: wrong number of records after update; ";
            }
            HashSet<String> usedDescriptions = new HashSet<String>(nRecords);
            HashSet<String> usedNames = new HashSet<String>(nRecords);
            for (Record record : consumer.getRecords()) {
                description = record.getDescription();
                if (!description.startsWith(newDescription)) {
                    errorMsg = errorMsg + "cache: wrong record description after update; ";
                }
                usedDescriptions.add(description);
                name = record.getVenue().getName();
                if (!name.startsWith(newName)) {
                    errorMsg = errorMsg + "cache: wrong venue name after update; ";
                }
                usedNames.add(name);
            }
            if (usedDescriptions.size() != nRecords) {
                errorMsg = errorMsg + "cache: records with same description; ";
            }
            if (usedNames.size() != nRecords) {
                errorMsg = errorMsg + "cache: venues with same name; ";
            }
            this.clearCache();
            em = this.createEntityManager();
            consumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)m_expertBeerConsumerId);
            this.closeEntityManager(em);
            nRecords = consumer.getRecords().size();
            if (nRecords != nRecordsExpected) {
                errorMsg = errorMsg + "db: wrong number of records after update; ";
            }
            usedDescriptions.clear();
            usedNames.clear();
            for (Record record : consumer.getRecords()) {
                description = record.getDescription();
                if (!description.startsWith(newDescription)) {
                    errorMsg = errorMsg + "db: wrong record description after update; ";
                }
                usedDescriptions.add(description);
                name = record.getVenue().getName();
                if (!name.startsWith(newName)) {
                    errorMsg = errorMsg + "db: wrong venue name after update; ";
                }
                usedNames.add(name);
            }
            if (usedDescriptions.size() != nRecords) {
                errorMsg = errorMsg + "db: records with same description; ";
            }
            if (usedNames.size() != nRecords) {
                errorMsg = errorMsg + "db: venues with same name; ";
            }
            if (errorMsg.length() > 0) {
                InheritedModelJunitTest.fail((String)errorMsg);
            }
        }
        finally {
            if (em != null) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                if (InheritedModelJunitTest.isOnServer()) {
                    this.closeEntityManager(em);
                } else if (em.isOpen()) {
                    this.closeEntityManager(em);
                }
            }
        }
    }

    public void testRedStripeExpertConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer initialEBC = new ExpertBeerConsumer();
        initialEBC.setAccredidation(new Accredidation());
        int beerConsumerId = 0;
        try {
            RedStripe redStripe1 = new RedStripe();
            redStripe1.setAlcoholContent(Double.valueOf(5.0));
            initialEBC.addRedStripeBeersToConsume(redStripe1, (Object)"1");
            RedStripe redStripe2 = new RedStripe();
            redStripe2.setAlcoholContent(Double.valueOf(5.0));
            initialEBC.addRedStripeBeersToConsume(redStripe2, (Object)"2");
            initialEBC.setName("Expert Red Stripe Consumer");
            em.persist((Object)initialEBC);
            beerConsumerId = initialEBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        ExpertBeerConsumer refreshedEBC = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)beerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The expert beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialEBC, (Object)refreshedEBC));
    }

    public void testRedStripeNoviceConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        NoviceBeerConsumer initialNBC = new NoviceBeerConsumer();
        initialNBC.setAccredidation(new Accredidation());
        int beerConsumerId = 0;
        try {
            RedStripe redStripe1 = new RedStripe();
            redStripe1.setAlcoholContent(Double.valueOf(5.0));
            initialNBC.addRedStripeBeersToConsume(redStripe1, (Object)"3");
            RedStripe redStripe2 = new RedStripe();
            redStripe2.setAlcoholContent(Double.valueOf(5.0));
            initialNBC.addRedStripeBeersToConsume(redStripe2, (Object)"4");
            initialNBC.setName("Novice Red Stripe Consumer");
            em.persist((Object)initialNBC);
            beerConsumerId = initialNBC.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        NoviceBeerConsumer refreshedNBC = (NoviceBeerConsumer)em.find(NoviceBeerConsumer.class, (Object)beerConsumerId);
        InheritedModelJunitTest.assertTrue((String)"The novice beer consumer read back did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialNBC, (Object)refreshedNBC));
    }

    public void testUpdateBeerConsumer() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
            BeerConsumer beerConsumerDetached = new BeerConsumer();
            beerConsumerDetached.setName(beerConsumer.getName());
            beerConsumerDetached.setId(beerConsumer.getId());
            beerConsumerDetached.setVersion(beerConsumer.getVersion());
            Blue blue = (Blue)em.find(Blue.class, (Object)m_blueId);
            beerConsumerDetached.addBlueBeerToConsume(blue);
            em.merge((Object)beerConsumerDetached);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during the merge of the detached beer consumer: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testVersionUpdateOnElementCollectionChange() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer beerConsumer = (BeerConsumer)em.createQuery("select b from BeerConsumer b join b.redStripes r").getResultList().get(0);
            int currentVersion = beerConsumer.getVersion();
            beerConsumer.getRedStripes().put("version", new RedStripe(Double.valueOf("343")));
            this.commitTransaction(em);
            InheritedModelJunitTest.assertTrue((String)"Did not increment version for change to element collection", (beerConsumer.getVersion() == ++currentVersion ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testInheritedClone() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SerialNumber serialNumber = new SerialNumber();
        em.persist((Object)serialNumber);
        Alpine alpine2 = new Alpine(serialNumber);
        alpine2.setBestBeforeDate((Date)Helper.dateFromYearMonthDate((int)2005, (int)8, (int)21));
        alpine2.setAlcoholContent((Object)5.0);
        alpine2.setClassification(Alpine.Classification.BITTER);
        alpine2.addInspectionDate(new Date(System.currentTimeMillis()));
        alpine2.getBeerConsumer();
        Alpine clone = null;
        try {
            clone = alpine2.clone();
        }
        catch (CloneNotSupportedException ex) {
            InheritedModelJunitTest.fail((String)("Caught CloneNotSupportedException " + ex));
        }
        BeerConsumer consumer = new BeerConsumer();
        consumer.setName("Keith Alexander");
        BlueLight blueLight2 = new BlueLight();
        blueLight2.setAlcoholContent((Object)new Float(4.0));
        blueLight2.setUniqueKey(new BigInteger(new Long(System.currentTimeMillis()).toString()));
        em.persist((Object)blueLight2);
        consumer.addBlueLightBeerToConsume(blueLight2);
        clone.setBeerConsumer(consumer);
        consumer.addAlpineBeerToConsume(clone);
        em.persist((Object)clone);
        em.persist((Object)consumer);
        if (alpine2.getBeerConsumer() == clone.getBeerConsumer()) {
            InheritedModelJunitTest.fail((String)"Changing clone beerConsumer changed original.");
        }
        this.commitTransaction(em);
        Integer alpineId = (Integer)clone.getId();
        Integer consumerId = consumer.getId();
        BigDecimal blueLightId = (BigDecimal)blueLight2.getId();
        this.clearCache();
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        alpine2 = (Alpine)em.find(Alpine.class, (Object)alpineId);
        try {
            clone = alpine2.clone();
        }
        catch (CloneNotSupportedException ex) {
            InheritedModelJunitTest.fail((String)("Caught CloneNotSupportedException " + ex));
        }
        consumer = new BeerConsumer();
        consumer.setName("Frank Keith");
        clone.setBeerConsumer(consumer);
        consumer.addAlpineBeerToConsume(clone);
        clone.getBeerConsumer();
        if (alpine2.getBeerConsumer() == clone.getBeerConsumer()) {
            InheritedModelJunitTest.fail((String)"Changing clone beerConsumer changed original.");
        }
        if (alpine2.getBeerConsumer() == null) {
            InheritedModelJunitTest.fail((String)"Changing clone address reset original to null.");
        }
        if (clone.getBeerConsumer() != consumer) {
            InheritedModelJunitTest.fail((String)"Changing clone did not work.");
        }
        try {
            consumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)consumerId);
            BeerConsumer consumerClone = (BeerConsumer)consumer.clone();
            for (Alpine alpine2 : consumer.getAlpineBeersToConsume()) {
                InheritedModelJunitTest.assertTrue((String)"The original beerConsumer has an alpine beer with an incorrect back pointer.", (consumer == alpine2.getBeerConsumer() ? 1 : 0) != 0);
            }
            for (Alpine alpine2 : consumerClone.getAlpineBeersToConsume()) {
                InheritedModelJunitTest.assertTrue((String)"The cloned beerConsumer has an alpine beer with an incorrect back pointer.", (consumerClone == alpine2.getBeerConsumer() ? 1 : 0) != 0);
            }
            for (BlueLight blueLight2 : consumer.getBlueLightBeersToConsume()) {
                InheritedModelJunitTest.assertTrue((String)"The original beerConsumer has an BlueLight beer with an incorrect back pointer.", (consumer == blueLight2.getBeerConsumer() ? 1 : 0) != 0);
            }
            for (BlueLight blueLight2 : consumerClone.getBlueLightBeersToConsume()) {
                InheritedModelJunitTest.assertTrue((String)"The cloned beerConsumer has an BlueLight beer with an incorrect back pointer.", (consumerClone == blueLight2.getBeerConsumer() ? 1 : 0) != 0);
            }
        }
        catch (CloneNotSupportedException e) {
            InheritedModelJunitTest.fail((String)"Call to clone threw CloneNotSupportedException");
        }
        alpine2 = (Alpine)em.find(Alpine.class, clone.getId());
        em.remove((Object)alpine2);
        blueLight2 = (BlueLight)em.find(BlueLight.class, (Object)blueLightId);
        em.remove((Object)blueLight2);
        consumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)consumerId);
        em.remove((Object)consumer);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testCascadeRemove() {
        BeerConsumer beerConsumer = null;
        BlueLight blueLightPersisted = null;
        BlueLight blueLightDetached = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            beerConsumer = new BeerConsumer();
            beerConsumer.setName("Beer Man");
            blueLightPersisted = new BlueLight();
            beerConsumer.getBlueLightBeersToConsume().add(blueLightPersisted);
            blueLightPersisted.setBeerConsumer(beerConsumer);
            em.persist((Object)beerConsumer);
            blueLightPersisted.setUniqueKey(((BigDecimal)blueLightPersisted.getId()).toBigInteger());
            InheritedModelJunitTest.assertTrue((boolean)em.contains((Object)beerConsumer));
            InheritedModelJunitTest.assertTrue((boolean)em.contains((Object)blueLightPersisted));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        try {
            this.beginTransaction(em);
            blueLightDetached = new BlueLight();
            blueLightDetached.setUniqueKey(new BigDecimal(blueLightPersisted.getUniqueKey().intValue() + 1).toBigInteger());
            beerConsumer.getBlueLightBeersToConsume().add(blueLightDetached);
            blueLightDetached.setBeerConsumer(beerConsumer);
            if (InheritedModelJunitTest.isOnServer()) {
                beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_beerConsumerId);
            }
            em.remove((Object)beerConsumer);
            InheritedModelJunitTest.assertFalse((boolean)em.contains((Object)blueLightDetached));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during the remove of the BeerConsumer: [" + e.getMessage() + "]"));
        }
        InheritedModelJunitTest.assertFalse((String)"The beer consumer was not removed", (boolean)em.contains((Object)beerConsumer));
        InheritedModelJunitTest.assertFalse((String)"The blue light persisted was not removed even though the its owning beer comsumer was removed", (boolean)em.contains((Object)blueLightPersisted));
        InheritedModelJunitTest.assertFalse((String)"The blue light detached was persisted even though the its owning beer comsumer was removed", (boolean)em.contains((Object)blueLightDetached));
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBreakOrder_CorrectionType_EXCEPTION() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        NoviceBeerConsumer beerConsumer = new NoviceBeerConsumer();
        beerConsumer.setAccredidation(new Accredidation());
        beerConsumer.setName("Broken order");
        beerConsumer.getDesignations().add("0");
        beerConsumer.getDesignations().add("1");
        beerConsumer.getDesignations().add("2");
        try {
            em.persist((Object)beerConsumer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)"failed to create beerConsumer");
        }
        Integer id = beerConsumer.getId();
        try {
            this.beginTransaction(em);
            try {
                em.createNativeQuery("UPDATE NOVICE_CONSUMER_DESIGNATIONS SET ORDER_COLUMN = null WHERE NOVICE_CONSUMER_ID = " + id + " AND ORDER_COLUMN = 0").executeUpdate();
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                InheritedModelJunitTest.fail((String)"failed to break order of designations");
            }
            finally {
                this.closeEntityManager(em);
            }
            this.clearCache();
            em = this.createEntityManager();
            try {
                beerConsumer = (NoviceBeerConsumer)em.find(NoviceBeerConsumer.class, (Object)id);
                beerConsumer.getDesignations().size();
                InheritedModelJunitTest.fail((String)"Exception was expected - but not thrown");
                return;
            }
            catch (RuntimeException e) {
                boolean isCorrectException = false;
                if (e instanceof QueryException) {
                    QueryException queryException = (QueryException)((Object)e);
                    if (((QueryException)((Object)e)).getErrorCode() == 6162) {
                        isCorrectException = true;
                    }
                }
                if (isCorrectException) return;
                throw e;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                beerConsumer = (NoviceBeerConsumer)em.find(NoviceBeerConsumer.class, (Object)id);
                em.remove((Object)beerConsumer);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBreakOrder_CorrectionType_READ_WRITE() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        ExpertBeerConsumer beerConsumer = new ExpertBeerConsumer();
        beerConsumer.setName("Beer order");
        beerConsumer.setAccredidation(new Accredidation());
        Committee committee0 = new Committee();
        committee0.setDescription("Broken Order 0");
        beerConsumer.addCommittee(committee0);
        Committee committee1 = new Committee();
        committee1.setDescription("Broken Order 1");
        beerConsumer.addCommittee(committee1);
        Committee committee2 = new Committee();
        committee2.setDescription("Broken Order 2");
        beerConsumer.addCommittee(committee2);
        try {
            em.persist((Object)beerConsumer);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)"failed to create beerConsumer");
        }
        Integer id = beerConsumer.getId();
        try {
            this.beginTransaction(em);
            try {
                em.createNativeQuery("UPDATE JPA_CONSUMER_COMMITTEE SET ORDER_COLUMN = null WHERE CONSUMER_ID = " + id + " AND ORDER_COLUMN = 0").executeUpdate();
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                InheritedModelJunitTest.fail((String)"failed to break order of committees");
            }
            finally {
                this.closeEntityManager(em);
            }
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                beerConsumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)id);
                Committee committee = (Committee)beerConsumer.getCommittees().remove(2);
                beerConsumer.getCommittees().add(1, committee);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                InheritedModelJunitTest.fail((String)"failed to change committees order");
            }
            List results = em.createNativeQuery("SELECT ORDER_COLUMN FROM JPA_CONSUMER_COMMITTEE WHERE CONSUMER_ID = " + id + " ORDER BY ORDER_COLUMN").getResultList();
            int expectedSize = beerConsumer.getCommittees().size();
            if (expectedSize != results.size()) {
                this.closeEntityManager(em);
                InheritedModelJunitTest.fail((String)("read in " + results.size() + " committees; expected " + expectedSize));
            }
            for (int i = 0; i < expectedSize; ++i) {
                if (results.get(i) != null && ((Number)results.get(i)).intValue() == i) continue;
                this.closeEntityManager(em);
                InheritedModelJunitTest.fail((String)("read in list in wrong order: " + results + "; expected: 0, 1, 2"));
            }
            this.closeEntityManager(em);
            return;
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                beerConsumer = (ExpertBeerConsumer)em.find(ExpertBeerConsumer.class, (Object)id);
                em.remove((Object)beerConsumer);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    public void testMapOrphanRemoval() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer initialBC = new BeerConsumer();
        int beerConsumerId = 0;
        try {
            Becks becks1 = new Becks();
            becks1.setAlcoholContent((Object)5.1);
            BecksTag becksTag1 = new BecksTag();
            becksTag1.setCallNumber("0A.789");
            em.persist((Object)becksTag1);
            initialBC.setName("Becks Consumer");
            initialBC.addBecksBeerToConsume(becks1, becksTag1);
            em.persist((Object)initialBC);
            beerConsumerId = initialBC.getId();
            em.flush();
            this.clearCache();
            BeerConsumer refreshedBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            refreshedBC.getBecksBeersToConsume().remove(becksTag1);
            em.flush();
            this.clearCache();
            becksTag1 = (BecksTag)em.find(BecksTag.class, (Object)becksTag1.getId());
            InheritedModelJunitTest.assertTrue((String)"Key was deleted when it should not be.", (becksTag1 != null ? 1 : 0) != 0);
            becks1 = (Becks)em.find(Becks.class, becks1.getId());
            InheritedModelJunitTest.assertTrue((String)"Orphan removal did not remove the orphan", (becks1 == null ? 1 : 0) != 0);
            this.rollbackTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerializedElementCollectionMap() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer initialBC = new BeerConsumer();
            em.persist((Object)initialBC);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            initialBC.addCommentLookup(serialNumber, "A test comment");
            em.flush();
            em.clear();
            initialBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)initialBC.getId());
            serialNumber = (SerialNumber)em.find(SerialNumber.class, (Object)serialNumber.getNumber());
            InheritedModelJunitTest.assertTrue((String)"The serialized map was not properly retrieved after persist.", (initialBC.getCommentLookup().size() == 1 ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The serialized map did not contain the proper entry.", (initialBC.getCommentLookup().get(serialNumber) != null ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddToHeinekenBeerConsumerMap() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        int beerConsumerId = 0;
        int heinekenId = 0;
        Calendar cal = Calendar.getInstance();
        cal.set(2008, 12, 12);
        try {
            BeerConsumer initialBC = new BeerConsumer();
            initialBC.setName("Heineken Consumer");
            em.persist((Object)initialBC);
            Heineken heineken1 = new Heineken();
            heineken1.setAlcoholContent((Object)5.0);
            em.persist((Object)heineken1);
            this.commitTransaction(em);
            beerConsumerId = initialBC.getId();
            heinekenId = (Integer)heineken1.getId();
            this.clearCache();
            this.beginTransaction(em);
            initialBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)initialBC.getId());
            heineken1 = (Heineken)em.find(Heineken.class, heineken1.getId());
            initialBC.addHeinekenBeerToConsume(heineken1, cal.getTime());
            this.commitTransaction(em);
            this.clearCache();
            initialBC = (BeerConsumer)em.find(BeerConsumer.class, (Object)initialBC.getId());
            heineken1 = (Heineken)em.find(Heineken.class, heineken1.getId());
            InheritedModelJunitTest.assertTrue((String)"The beer consumer is not appropriately associated with the heineken.", (heineken1.getBeerConsumer() != null ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The heineken is not appropriately associated with the beer consumer.", (initialBC.getHeinekenBeersToConsume().size() == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.beginTransaction(em);
            BeerConsumer consumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)beerConsumerId);
            Heineken heineken = (Heineken)em.find(Heineken.class, (Object)heinekenId);
            if (consumer != null) {
                em.remove((Object)consumer);
            }
            if (heineken != null) {
                em.remove((Object)heineken);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testColumnUpdatableAndInsertable() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            OfficialEntry officialEntry = new OfficialEntry();
            em.persist((Object)officialEntry);
            Official initialOfficial = new Official();
            initialOfficial.setName("Gui Pelletier");
            initialOfficial.setAge(Integer.valueOf(25));
            initialOfficial.setSalary(Integer.valueOf(50000));
            initialOfficial.setBonus(Integer.valueOf(10000));
            initialOfficial.setOfficialEntry(officialEntry);
            initialOfficial.setOfficialEntryId(Integer.valueOf(officialEntry.getId()));
            ServiceTime service = new ServiceTime();
            service.setStartDate("Jan 1, 2008");
            service.setEndDate("Jul 1, 2010");
            initialOfficial.setServiceTime(service);
            em.persist((Object)initialOfficial);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Official official = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            InheritedModelJunitTest.assertTrue((String)"The name was not inserted", (boolean)official.getName().equals("Gui Pelletier"));
            InheritedModelJunitTest.assertTrue((String)"The age was inserted", (official.getAge() == null ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The salary was not inserted", (official.getSalary() == 50000 ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The bonus was inserted", (official.getBonus() == null ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The official entry was not inserted", (official.getOfficialEntryId().intValue() == officialEntry.getId() ? 1 : 0) != 0);
            InheritedModelJunitTest.assertTrue((String)"The embeddable start date was not inserted", (boolean)official.getServiceTime().getStartDate().equals("Jan 1, 2008"));
            InheritedModelJunitTest.assertTrue((String)"The embeddable end date was inserted", (official.getServiceTime().getEndDate() == null ? 1 : 0) != 0);
            official.setName("Guy Pelletier");
            official.setSalary(Integer.valueOf(100000));
            official.getServiceTime().setStartDate("Jan 30, 2008");
            official.setAge(Integer.valueOf(25));
            official.setBonus(Integer.valueOf(10000));
            official.getServiceTime().setEndDate("Jul 1, 2010");
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            Official refreshedOfficial = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            InheritedModelJunitTest.assertTrue((String)"The refreshedOfficial did not match the original", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)initialOfficial, (Object)refreshedOfficial));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            InheritedModelJunitTest.fail((String)("An exception was caught during create operation: [" + e.getMessage() + "]"));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testColumnUpdatableAndInsertableThroughQuery() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            InheritedModelJunitTest.getServerSession().logMessage("Test testColumnUpdatableAndInsertableThroughQuery skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Official initialOfficial = new Official();
            initialOfficial.setName("Gui Pelletier");
            em.persist((Object)initialOfficial);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Query query = em.createNamedQuery("UpdateOfficalName");
            query.setParameter("name", (Object)"Guy");
            query.setParameter("id", (Object)initialOfficial.getId());
            query.executeUpdate();
            Official modifiedOfficial = (Official)em.find(Official.class, (Object)initialOfficial.getId());
            InheritedModelJunitTest.assertTrue((String)"The name was not updated after executing the named query", (boolean)modifiedOfficial.getName().equals("Guy"));
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            Official refreshedOfficial = (Official)em.find(Official.class, (Object)modifiedOfficial.getId());
            InheritedModelJunitTest.assertTrue((String)"The refreshedOfficial did not match the modified", (boolean)InheritedModelJunitTest.getServerSession().compareObjects((Object)modifiedOfficial, (Object)refreshedOfficial));
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            InheritedModelJunitTest.fail((String)("Update query failed: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testElementCollectionMapEmbeddable() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer consumer = new BeerConsumer();
            consumer.setName("Lionel");
            RedStripe rs = new RedStripe();
            rs.setAlcoholContent(Double.valueOf(4.5));
            consumer.addRedStripeByAlcoholContent(rs);
            em.persist((Object)consumer);
            em.flush();
            rs = new RedStripe();
            rs.setAlcoholContent(Double.valueOf(3.5));
            consumer.addRedStripeByAlcoholContent(rs);
            em.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRelatedBylawWrite() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BuildingBylaw law = new BuildingBylaw();
            law.setCity("EastTown");
            law.setDescription("No west facing property.");
            BuildingBylaw relatedLaw = new BuildingBylaw();
            relatedLaw.setCity("EastTown");
            relatedLaw.setDescription("No square houses");
            law.setRelatedByLaw((Bylaw)relatedLaw);
            em.persist((Object)law);
            em.persist((Object)relatedLaw);
            em.flush();
            em.clear();
            String jpqlString = "SELECT b FROM BuildingBylaw b WHERE b.number =" + law.getNumber();
            law = (BuildingBylaw)em.createQuery(jpqlString).getSingleResult();
            InheritedModelJunitTest.assertNotNull((String)"BuildingBylaw not properly written.", (Object)law);
            InheritedModelJunitTest.assertNotNull((String)"ManyToOne with target type != actual type not properly written.", (Object)law.getRelatedByLaw());
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterfaceBylawWrite() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BuildingBylaw law = new BuildingBylaw();
            law.setCity("EastTown");
            law.setDescription("No west facing property.");
            BuildingBylaw relatedLaw = new BuildingBylaw();
            relatedLaw.setCity("EastTown");
            relatedLaw.setDescription("No square houses");
            law.setReference((CityNumberPair)relatedLaw);
            em.persist((Object)law);
            em.persist((Object)relatedLaw);
            em.flush();
            em.clear();
            String jpqlString = "SELECT b FROM BuildingBylaw b WHERE b.number =" + law.getNumber();
            law = (BuildingBylaw)em.createQuery(jpqlString).getSingleResult();
            InheritedModelJunitTest.assertNotNull((String)"BuildingBylaw not properly written.", (Object)law);
            InheritedModelJunitTest.assertNotNull((String)"ManyToOne with target type != actual type not properly written.", (Object)law.getReference());
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testEmbeddableAggregateCollectionAndAggregate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        BeerConsumer consumer = new BeerConsumer();
        consumer.setName("Lionel");
        RedStripe rs = new RedStripe();
        rs.setAlcoholContent(Double.valueOf(4.5));
        consumer.addRedStripeByAlcoholContent(rs);
        em.persist((Object)consumer);
        Official official = new Official();
        official.setName("George");
        rs = new RedStripe();
        rs.setAlcoholContent(Double.valueOf(4.6));
        official.setLastRedStripeConsumed(rs);
        em.persist((Object)official);
        em.flush();
        em.clear();
        this.clearCache();
        consumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)consumer.getId());
        InheritedModelJunitTest.assertNotNull((String)"BeerConsumer had null red stripes.", (Object)consumer.getRedStripes());
        InheritedModelJunitTest.assertTrue((String)"BeerConsumer had wrong number of red stripes.", (consumer.getRedStripesByAlcoholContent().size() == 1 ? 1 : 0) != 0);
        InheritedModelJunitTest.assertTrue((String)"BeerConsumer had wrong red stripe.", (consumer.getRedStripesByAlcoholContent().get(4.5) != null ? 1 : 0) != 0);
        official = (Official)em.find(Official.class, (Object)official.getId());
        InheritedModelJunitTest.assertNotNull((String)"Official had null red stripe.", (Object)official.getLastRedStripeConsumed());
        InheritedModelJunitTest.assertTrue((String)"Official had the wrong red stripe", (official.getLastRedStripeConsumed().getAlcoholContent() == 4.6 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    public void testNodeImplWeaving() {
        if (this.isWeavingEnabled()) {
            Class<?>[] interfaces = NodeImpl.class.getInterfaces();
            boolean found = false;
            for (Class<?> c : interfaces) {
                if (c != PersistenceWeaved.class) continue;
                found = true;
            }
            InheritedModelJunitTest.assertTrue((String)"NodeImpl was not weaved.", (boolean)found);
        }
    }
}

