/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.spi.PersistenceProvider;
import junit.framework.Test;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.LargeProject;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.performance.SmallProject;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public class JPAPerformanceComparisonModel
extends TestModel {
    public JPAPerformanceComparisonModel() {
        this.setDescription("Performance tests that compare JPA performance.");
    }

    public void addTests() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadingSuite");
        suite.addTest((Test)this.buildReadAllVsReadAllResultSet());
        suite.addTest((Test)this.buildBatchFetchTest());
        this.addTest((Test)suite);
    }

    public void setup() {
        int j;
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EmulatedDriver.emulate = false;
        EntityManager manager = this.getExecutor().createEntityManager();
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
        manager.getTransaction().begin();
        for (j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        for (j = 0; j < 50; ++j) {
            SmallProject project = new SmallProject();
            project.setName("Tracker");
            manager.persist((Object)project);
            project = new LargeProject();
            project.setName("Tracker");
            manager.persist((Object)project);
        }
        manager.getTransaction().commit();
        manager.close();
        EmulatedDriver.emulate = true;
    }

    public void setupProvider() {
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).newInstance();
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        try {
            Class.forName(this.getSession().getLogin().getDriverClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties.put("eclipselink.jdbc.driver", "org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver");
        properties.put("eclipselink.jdbc.url", "emulate:" + this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        return properties;
    }

    public TestCase buildReadAllVsReadAllResultSet() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            ReadAllQuery query;
            ReadAllQuery resultSetQuery;

            public void setup() {
                this.query = new ReadAllQuery(Address.class);
                this.resultSetQuery = new ReadAllQuery(Address.class);
                this.resultSetQuery.setIsResultSetOptimizedQuery(true);
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)resultSetQuery).getResultList();
                        em.close();
                    }
                };
                test.setName("ReadAllResultSet");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void startTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(4);
                        em.close();
                    }

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)query).getResultList();
                        em.close();
                    }

                    public void endTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(1);
                        em.close();
                    }
                };
                test.setName("ReadAllNoCache");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void startTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        em.close();
                    }

                    public void test() {
                        EntityManager em = this.createEntityManager();
                        ((JpaEntityManager)em).createQuery((DatabaseQuery)resultSetQuery).getResultList();
                        em.close();
                    }

                    public void endTest() {
                        EntityManager em = this.createEntityManager();
                        ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                        em.close();
                    }
                };
                test.setName("ReadAllResultSetNoCache");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                EntityManager em = this.createEntityManager();
                ((JpaEntityManager)em).createQuery((DatabaseQuery)this.query).getResultList();
                em.close();
            }
        };
        test.setName("ReadAllVsReadAllResultSet");
        return test;
    }

    public TestCase buildBatchFetchTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void setup() {
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(4);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(4);
                ((Session)this.createEntityManager().unwrap(Session.class)).getProject().setHasIsolatedClasses(true);
                if (!this.getTests().isEmpty()) {
                    return;
                }
                PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatch");
                    }
                };
                test.setName("BatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatchEXISTS");
                    }
                };
                test.setName("EXISTSBatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesBatchIN");
                    }
                };
                test.setName("INBatchFetchTest");
                this.addTest((TestCase)test);
                test = new PerformanceComparisonTestCase(){

                    public void test() {
                        JPAPerformanceComparisonModel.this.testQuery("findAllEmployeesJoin");
                    }
                };
                test.setName("JoinFetchTest");
                this.addTest((TestCase)test);
            }

            public void test() throws Exception {
                JPAPerformanceComparisonModel.this.testQuery("findAllEmployees");
            }

            public void reset() {
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Employee.class).setUnitOfWorkCacheIsolationLevel(1);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setCacheIsolation(CacheIsolationType.ISOLATED);
                ((Session)this.createEntityManager().unwrap(Session.class)).getDescriptor(Address.class).setUnitOfWorkCacheIsolationLevel(1);
                ((Session)this.createEntityManager().unwrap(Session.class)).getProject().setHasIsolatedClasses(false);
            }
        };
        test.setName("BatchFetchTest");
        return test;
    }

    protected void testQuery(String query) {
        EntityManager em = this.getExecutor().createEntityManager();
        List employees = em.createNamedQuery(query).getResultList();
        for (Employee employee : employees) {
            employee.getAddress().toString();
        }
        em.close();
    }
}

