/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced;

import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.persistence.RollbackException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.CacheAuditor;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.PartnerLink;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.Woman;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class AdvancedJunitTest
extends JUnitTestCase {
    String m_persistenceUnit = "default";

    public AdvancedJunitTest() {
    }

    public AdvancedJunitTest(String name) {
        super(name);
    }

    public AdvancedJunitTest(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-advanced";
        TestSuite suite = new TestSuite("AdvancedJunitTest - " + persistenceUnit);
        suite.addTest((Test)new AdvancedJunitTest("testSetup", persistenceUnit));
        suite.addTest((Test)new AdvancedJunitTest("testEL254937", persistenceUnit));
        suite.addTest((Test)new AdvancedJunitTest("testGF1894", persistenceUnit));
        suite.addTest((Test)new AdvancedJunitTest("testManAndWoman", persistenceUnit));
        if (persistenceUnit.equals("extended-advanced")) {
            suite.addTest((Test)new AdvancedJunitTest("testForRedirectorsAndInterceptors", persistenceUnit));
            suite.addTest((Test)new AdvancedJunitTest("testForExceptionsFromInterceptors", persistenceUnit));
        }
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)this.m_persistenceUnit));
        AdvancedJunitTest.clearCache((String)this.m_persistenceUnit);
    }

    public void testEL254937() {
        EntityManager em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        LargeProject lp1 = new LargeProject();
        lp1.setName("one");
        em.persist((Object)lp1);
        this.commitTransaction(em);
        em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        em.remove(em.find(LargeProject.class, (Object)lp1.getId()));
        em.flush();
        JpaEntityManager eclipselinkEm = (JpaEntityManager)em.getDelegate();
        RepeatableWriteUnitOfWork uow = (RepeatableWriteUnitOfWork)eclipselinkEm.getActiveSession();
        uow.issueSQLbeforeCompletion();
        uow.setShouldTerminateTransaction(true);
        uow.commitTransaction();
        uow.mergeClonesAfterCompletion();
        em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        LargeProject cachedLargeProject = (LargeProject)em.find(LargeProject.class, (Object)lp1.getId());
        this.closeEntityManager(em);
        AdvancedJunitTest.assertTrue((String)"Entity removed during flush was not removed from the shared cache on commit", (cachedLargeProject == null ? 1 : 0) != 0);
    }

    public void testGF1894() {
        EntityManager em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        Employee emp = new Employee("Guy", "Pelletier");
        Address address = new Address();
        address.setCity("College Town");
        emp.setAddress(address);
        try {
            Employee empClone = (Employee)em.merge((Object)emp);
            AdvancedJunitTest.assertNotNull((String)"The id field for the merged new employee object was not generated.", (Object)empClone.getId());
            this.commitTransaction(em);
            Employee empFromDB = (Employee)em.find(Employee.class, (Object)empClone.getId());
            AdvancedJunitTest.assertNotNull((String)"The version locking field for the merged new employee object was not updated after commit.", (Object)empFromDB.getVersion());
            this.beginTransaction(em);
            Employee empClone2 = (Employee)em.merge((Object)empFromDB);
            AdvancedJunitTest.assertTrue((String)"The id field on a existing merged employee object was modified on a subsequent merge.", (boolean)empFromDB.getId().equals(empClone2.getId()));
            this.commitTransaction(em);
        }
        catch (OptimisticLockException e) {
            AdvancedJunitTest.fail((String)"An optimistic locking exception was caught on the merge of a new object. An insert should of occurred instead.");
        }
        this.closeEntityManager(em);
    }

    public void testManAndWoman() {
        EntityManager em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            PartnerLink pLink1 = new PartnerLink();
            pLink1.setMan(new Man());
            em.persist((Object)pLink1);
            PartnerLink pLink2 = new PartnerLink();
            pLink2.setWoman(new Woman());
            em.persist((Object)pLink2);
            PartnerLink pLink3 = new PartnerLink();
            pLink3.setMan(new Man());
            pLink3.setWoman(new Woman());
            em.persist((Object)pLink3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            AdvancedJunitTest.fail((String)("An exception was caught: [" + e.getMessage() + "]"));
        }
        this.closeEntityManager(em);
    }

    public void testForRedirectorsAndInterceptors() {
        ClassDescriptor descriptor = AdvancedJunitTest.getServerSession((String)this.m_persistenceUnit).getDescriptor(Address.class);
        AdvancedJunitTest.assertTrue((String)"CacheInterceptor was not set on decriptor", (descriptor.getCacheInterceptorClassName() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"All queries default redirector was not set on decriptor", (descriptor.getDefaultQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Read All queries default redirector was not set on decriptor", (descriptor.getDefaultReadAllQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Read Object queries default redirector was not set on decriptor", (descriptor.getDefaultReadObjectQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Report queries default redirector was not set on decriptor", (descriptor.getDefaultReportQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Insert queries default redirector was not set on decriptor", (descriptor.getDefaultInsertObjectQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Update queries default redirector was not set on decriptor", (descriptor.getDefaultUpdateObjectQueryRedirector() != null ? 1 : 0) != 0);
        AdvancedJunitTest.assertTrue((String)"Delete queries default redirector was not set on decriptor", (descriptor.getDefaultDeleteObjectQueryRedirector() != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForExceptionsFromInterceptors() {
        ClassDescriptor descriptor = AdvancedJunitTest.getServerSession((String)this.m_persistenceUnit).getDescriptor(Address.class);
        CacheAuditor interceptor = (CacheAuditor)AdvancedJunitTest.getServerSession((String)this.m_persistenceUnit).getIdentityMapAccessorInstance().getIdentityMap(descriptor);
        interceptor.setShouldThrow(true);
        EntityManager em = AdvancedJunitTest.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Address addr = new Address();
            addr.setCity("WhaHa");
            addr.setProvince("NFLD");
            em.persist((Object)addr);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.remove((Object)addr);
            this.commitTransaction(em);
            AdvancedJunitTest.fail((String)"There was no Optimistic Lock Exception");
        }
        catch (RollbackException e) {
            AdvancedJunitTest.assertTrue((String)"Not caused by OptimisticLockException", (boolean)(e.getCause() instanceof OptimisticLockException));
        }
        finally {
            interceptor.setShouldThrow(false);
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

