/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeClient;
import org.eclipse.persistence.testing.tests.clientserver.FIFO;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class EmployeeSeqDeadlockClient
extends EmployeeClient {
    protected boolean createEmployees;
    protected FIFO fifoOut;

    public EmployeeSeqDeadlockClient(Server server, Session session, String name, int maximumLoops, boolean createEmployees, FIFO fifoOut) {
        super(server, session, name, maximumLoops);
        this.createEmployees = createEmployees;
        this.fifoOut = fifoOut;
    }

    @Override
    public void run() {
        int i = 0;
        while (this.getKeepRunning()) {
            try {
                if (++i > this.getMaximumLoops()) {
                    this.pleaseStop();
                    continue;
                }
                UnitOfWork uow = this.clientSession.acquireUnitOfWork();
                if (this.createEmployees) {
                    uow.registerNewObject((Object)new Employee());
                } else {
                    uow.registerNewObject((Object)new SmallProject());
                }
                uow.commit();
                if (this.fifoOut == null) continue;
                this.fifoOut.insertTail(new Integer(i));
            }
            catch (Exception e) {
                this.pleaseStop();
                this.setErrorOccurred(true);
                this.setTestException(e);
            }
        }
        this.session = null;
        this.server = null;
        if (this.fifoOut != null) {
            this.fifoOut.insertTail(new Integer(-1));
        }
    }
}

