/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Client;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;

public class StoredInObjectOptimisticLockTest
extends ComplexUpdateTest {
    public StoredInObjectOptimisticLockTest() {
    }

    public StoredInObjectOptimisticLockTest(Client originalObject) {
        super(originalObject);
    }

    @Override
    protected void changeObject() {
        Client client = (Client)this.workingCopy;
        client.setName("Name:" + System.currentTimeMillis());
    }

    @Override
    protected void test() {
        this.changeObject();
        if (!this.getUnitOfWork().getParent().compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.getUnitOfWork().commit();
    }

    @Override
    protected void verify() {
        DatabaseSession remoteServer = ((DistributedServer)DistributedServersModel.getDistributedServers().get(0)).getDistributedSession();
        remoteServer.beginTransaction();
        UnitOfWork uow = remoteServer.acquireUnitOfWork();
        Client remoteClient = (Client)uow.executeQuery((DatabaseQuery)this.query);
        remoteClient.setName("newName" + System.currentTimeMillis());
        try {
            uow.commit();
        }
        catch (OptimisticLockException ex) {
            throw new TestErrorException("Failed to copy the version number to the remote system");
        }
        finally {
            remoteServer.rollbackTransaction();
        }
    }
}

