/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class RefreshIfNewerVersionTest
extends CacheExpiryTest {
    protected boolean shouldRefreshCache = false;
    protected long originalReadTime = 0L;
    protected long secondReadTime = 0L;

    public RefreshIfNewerVersionTest() {
        this.setDescription("Ensure refresh if newer version updates the cache expiry flag when the versions are the same.");
    }

    @Override
    public void setup() {
        super.setup();
        this.shouldRefreshCache = this.getSession().getDescriptor(Employee.class).shouldOnlyRefreshCacheIfNewerVersion();
        this.getSession().getDescriptor(Employee.class).setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void test() {
        Employee employee = (Employee)this.getSession().readObject(Employee.class);
        this.originalReadTime = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)employee).getReadTime();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        ReadObjectQuery query = new ReadObjectQuery((Object)employee);
        query.refreshIdentityMapResult();
        employee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.secondReadTime = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)employee).getReadTime();
    }

    public void verify() {
        if (this.originalReadTime >= this.secondReadTime) {
            throw new TestErrorException("Refresh if newer version did not update the expiry time for an object that was a newer version.");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.getSession().getDescriptor(Employee.class).setShouldOnlyRefreshCacheIfNewerVersion(this.shouldRefreshCache);
    }
}

