/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class Jdk12ScrollableCursorTest
extends TestCase {
    protected Vector cursoredQueryObjects;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public Jdk12ScrollableCursorTest() {
        this.setDescription("This test tests ScrollableCursor in jdk1.1");
    }

    protected void setup() {
        if (this.getSession().getPlatform().isAccess() || this.getSession().getPlatform().isTimesTen()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform");
        }
        if (this.getSession().getPlatform().isDB2()) {
            throw new TestWarningException("java.sql.SQLException: [IBM][JDBC Driver] CLI0626E" + Helper.cr() + "Updatable result set is not supported in this version of DB2 JDBC 2.0 driver.");
        }
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        if (this.getSession().getPlatform().isSymfoware()) {
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        this.cursoredQueryObjects = new Vector();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
            query.useScrollableCursor();
        } else {
            ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
            if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                policy.setResultSetType(1005);
            }
            if (!this.CONCUR_UPDATABLE_isSupported) {
                policy.setResultSetConcurrency(1007);
            }
            policy.setPageSize(10);
            query.useScrollableCursor(policy);
        }
        ScrollableCursor cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
        while (cursor.hasMoreElements()) {
            this.cursoredQueryObjects.addElement(cursor.nextElement());
        }
    }
}

