/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ZTestCase
extends AutoVerifyTestCase {
    private final String zName;

    public ZTestCase(String zName) {
        this.zName = zName;
        this.setName(this.getName() + "." + zName + "()");
        this.initialize();
    }

    protected void assertElementsEqual(String message, Vector expected, Vector actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        for (int i = 0; i < expected.size(); ++i) {
            Object e1 = expected.elementAt(i);
            Object e2 = actual.elementAt(i);
            if (e1 == null) {
                if (e2 == null) continue;
                ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
                continue;
            }
            if (e1.equals(e2)) continue;
            ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertElementsEqual(Vector expected, Vector actual) {
        this.assertElementsEqual("", expected, actual);
    }

    protected void assertUnorderedElementsEqual(String message, Vector expected, Vector actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        Vector temp = (Vector)actual.clone();
        for (int i = 0; i < expected.size(); ++i) {
            Object e1 = expected.elementAt(i);
            if (e1 == null) {
                if (this.removeNullElement(temp)) continue;
                ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
                continue;
            }
            if (temp.removeElement(e1)) continue;
            ZTestCase.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertUnorderedElementsEqual(Vector expected, Vector actual) {
        this.assertUnorderedElementsEqual("", expected, actual);
    }

    public String getZName() {
        return this.zName;
    }

    protected void initialize() {
    }

    protected void invokeTest() throws Throwable {
        Method method = this.methodNamed(this.getZName());
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("The method '" + method + "' (and its class) must be public.");
        }
        catch (InvocationTargetException ite) {
            ite.fillInStackTrace();
            throw ite.getTargetException();
        }
    }

    private Method methodNamed(String name) {
        try {
            return ((Object)((Object)this)).getClass().getMethod(this.zName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Method named " + name + " not found.");
        }
    }

    protected String notEqualsMessage(String message, Object expected, Object actual) {
        StringBuffer buffer = new StringBuffer(250);
        if (message != null && message.length() != 0) {
            buffer.append(message);
            buffer.append(" ");
        }
        buffer.append("expected: \"");
        buffer.append(expected);
        buffer.append("\" but was: \"");
        buffer.append(actual);
        buffer.append("\"");
        return buffer.toString();
    }

    private boolean removeNullElement(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i) != null) continue;
            v.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void reset() {
        this.tearDown();
    }

    protected void setup() {
        this.setUp();
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    protected void test() throws Exception {
        try {
            this.invokeTest();
        }
        catch (Throwable ex) {
            throw new TestErrorException("Error in test Case: " + this.getName(), ex);
        }
    }
}

