/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MarshalRecord
extends XMLRecord {
    private ArrayList<XPathNode> groupingElements;
    private HashMap positionalNodes;
    protected XPathFragment textWrapperFragment;
    private CycleDetectionStack<Object> cycleDetectionStack = new CycleDetectionStack();
    protected static final String COLON_W_SCHEMA_NIL_ATTRIBUTE = ":nil";
    protected static final String TRUE = "true";
    private static final Object[] EMPTY_CYCLE_DATA = new Object[8];

    public HashMap getPositionalNodes() {
        if (this.positionalNodes == null) {
            this.positionalNodes = new HashMap();
        }
        return this.positionalNodes;
    }

    @Override
    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    @Override
    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    @Override
    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    @Override
    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    @Override
    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public void addGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements == null) {
            this.groupingElements = new ArrayList(2);
        }
        this.groupingElements.add(xPathNode);
    }

    public void removeGroupingElement(XPathNode xPathNode) {
        if (this.groupingElements != null) {
            this.groupingElements.remove(xPathNode);
        }
    }

    @Override
    public String transformToXML() {
        return null;
    }

    @Override
    public void setSession(AbstractSession session) {
        super.setSession(session);
        if (session != null && session.getDatasourceLogin() instanceof XMLLogin) {
            this.equalNamespaceResolvers = ((XMLLogin)session.getDatasourceLogin()).hasEqualNamespaceResolvers();
        }
    }

    @Override
    public void add(DatabaseField key, Object value) {
        if (value == null) {
            return;
        }
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        if (lastFragment.nameIsText()) {
            this.characters(xmlField.getSchemaType(), value, null, xmlField.isCDATA());
        } else if (lastFragment.isAttribute()) {
            this.attribute(lastFragment, xmlField.getNamespaceResolver(), value, xmlField.getSchemaType());
        } else {
            this.element(lastFragment);
        }
    }

    @Override
    public Object put(DatabaseField key, Object value) {
        this.add(key, value);
        return null;
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return;
        }
        String namespaceURI = namespaceResolver.getDefaultNamespaceURI();
        if (namespaceURI != null) {
            this.defaultNamespaceDeclaration(namespaceURI);
        }
        if (namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                String namespacePrefix = entry.getKey();
                this.namespaceDeclaration(namespacePrefix, entry.getValue());
            }
        }
    }

    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (openGrouping) {
            XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
            this.closeStartGroupingElements(groupingFragment);
            return true;
        }
        return false;
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
        this.attribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, namespaceURI);
    }

    public void defaultNamespaceDeclaration(String defaultNamespace) {
        this.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", defaultNamespace);
    }

    public abstract void startDocument(String var1, String var2);

    public void writeHeader() {
    }

    public abstract void endDocument();

    public void marshalWithoutRootElement(TreeObjectBuilder treeObjectBuilder, Object object, XMLDescriptor descriptor, XMLRoot root, boolean isXMLRoot) {
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null && namespaceResolver.hasPrefixesToNamespaces()) {
            for (Map.Entry<String, String> entry : namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                this.startPrefixMapping(entry.getKey(), entry.getValue());
            }
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
    }

    public abstract void element(XPathFragment var1);

    public abstract void attribute(XPathFragment var1, NamespaceResolver var2, String var3);

    @Override
    public abstract void attribute(String var1, String var2, String var3, String var4);

    public abstract void closeStartElement();

    public abstract void endElement(XPathFragment var1, NamespaceResolver var2);

    public abstract void characters(String var1);

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value, QName schemaType) {
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            this.attribute(xPathFragment, namespaceResolver, convertedValue);
        }
    }

    public void characters(QName schemaType, Object value, String mimeType, boolean isCDATA) {
        if (mimeType != null) {
            value = XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value);
            this.characters(convertedValue);
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
            if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue);
            }
        }
    }

    public String getValueToWrite(QName schemaType, Object value, XMLConversionManager xmlConversionManager) {
        if (value == null) {
            return null;
        }
        if (schemaType != null && XMLConstants.QNAME_QNAME.equals(schemaType)) {
            return this.getStringForQName((QName)value);
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        return (String)xmlConversionManager.convertObject(value, ClassConstants.STRING, schemaType);
    }

    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            if (this.getNamespaceResolver() != null && this.getNamespaceResolver().getDefaultNamespaceURI() != null) {
                this.defaultNamespaceDeclaration(namespaceURI);
            }
            return qName.getLocalPart();
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        if (namespaceURI.equals(namespaceResolver.getDefaultNamespaceURI())) {
            return qName.getLocalPart();
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            prefix = namespaceResolver.generatePrefix();
            this.namespaceDeclaration(prefix, namespaceURI);
        }
        if ("".equals(prefix)) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    public abstract void cdata(String var1);

    public abstract void node(Node var1, NamespaceResolver var2);

    public XPathFragment openStartGroupingElements(NamespaceResolver namespaceResolver) {
        if (this.groupingElements == null) {
            return null;
        }
        XPathFragment xPathFragment = null;
        int x = 0;
        int groupingElementsSize = this.groupingElements.size();
        while (x < groupingElementsSize) {
            XPathNode xPathNode = this.groupingElements.get(x);
            xPathFragment = xPathNode.getXPathFragment();
            this.openStartElement(xPathFragment, namespaceResolver);
            this.predicateAttribute(xPathFragment, namespaceResolver);
            if (x != groupingElementsSize - 1) {
                this.closeStartElement();
            }
            ++x;
        }
        this.groupingElements = null;
        return xPathFragment;
    }

    public void closeStartGroupingElements(XPathFragment groupingFragment) {
        if (groupingFragment != null) {
            this.closeStartElement();
        }
    }

    protected void addPositionalNodes(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (xPathFragment.containsIndex()) {
            String shortName = xPathFragment.getShortName();
            Integer index = (Integer)this.getPositionalNodes().get(shortName);
            int start = index == null ? 1 : index;
            int x = start;
            while (x < xPathFragment.getIndexValue()) {
                this.element(xPathFragment);
                ++x;
            }
            this.getPositionalNodes().put(shortName, xPathFragment.getIndexValue() + 1);
        }
    }

    public void beforeContainmentMarshal(Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            marshalListener.beforeMarshal(child);
        }
        this.setOwningObject(child);
    }

    public void afterContainmentMarshal(Object parent, Object child) {
        XMLMarshalListener marshalListener;
        if (this.marshaller != null && (marshalListener = this.marshaller.getMarshalListener()) != null) {
            marshalListener.afterMarshal(child);
        }
        this.setOwningObject(parent);
    }

    public ArrayList<XPathNode> getGroupingElements() {
        return this.groupingElements;
    }

    public void setGroupingElement(ArrayList<XPathNode> elements) {
        this.groupingElements = elements;
    }

    public void predicateAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment predicateXPathFragment;
        XPathPredicate predicate;
        if (xPathFragment != null && (predicate = xPathFragment.getPredicate()) != null && (predicateXPathFragment = predicate.getXPathFragment()).isAttribute()) {
            this.attribute(predicateXPathFragment, namespaceResolver, predicate.getValue());
        }
    }

    public void startCollection() {
    }

    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.attribute(xPathFragment, namespaceResolver, "");
        this.closeStartGroupingElements(groupingFragment);
    }

    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    public void emptySimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        StringBuilder qName = new StringBuilder(XMLConstants.ATTRIBUTE.charValue());
        qName.append(xsiPrefix).append(COLON_W_SCHEMA_NIL_ATTRIBUTE);
        XPathFragment nilFragment = new XPathFragment(qName.toString());
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartGroupingElements(groupingFragment);
    }

    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        String xsiPrefix = this.processNamespaceResolverForXSIPrefix(namespaceResolver);
        XPathFragment nilFragment = new XPathFragment(XMLConstants.ATTRIBUTE + xsiPrefix + COLON_W_SCHEMA_NIL_ATTRIBUTE);
        nilFragment.setNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        this.attribute(nilFragment, namespaceResolver, TRUE);
        this.closeStartElement();
        this.endElement(xPathFragment, namespaceResolver);
    }

    public void endCollection() {
    }

    protected String processNamespaceResolverForXSIPrefix(NamespaceResolver namespaceResolver) {
        String xsiPrefix;
        if (namespaceResolver == null) {
            xsiPrefix = "xsi";
            namespaceResolver = new NamespaceResolver();
            namespaceResolver.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (xsiPrefix == null) {
                xsiPrefix = namespaceResolver.generatePrefix("xsi");
                this.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        return xsiPrefix;
    }

    public XPathFragment getTextWrapperFragment() {
        return null;
    }

    protected String getNameForFragment(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortName();
        }
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            return String.valueOf(prefix) + ':' + xPathFragment.getLocalName();
        }
        return xPathFragment.getLocalName();
    }

    protected byte[] getNameForFragmentBytes(XPathFragment xPathFragment) {
        String prefix;
        if (!this.hasCustomNamespaceMapper()) {
            return xPathFragment.getShortNameBytes();
        }
        String name = xPathFragment.getLocalName();
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI().length() > 0 && (prefix = this.getPrefixForFragment(xPathFragment)) != null && prefix.length() > 0) {
            name = String.valueOf(prefix) + ':' + xPathFragment.getLocalName();
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return bytes;
    }

    protected String getPrefixForFragment(XPathFragment xPathFragment) {
        if (!this.hasCustomNamespaceMapper) {
            return xPathFragment.getPrefix();
        }
        String uri = xPathFragment.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return "";
        }
        String defaultNamespace = this.getNamespaceResolver().getDefaultNamespaceURI();
        if (defaultNamespace != null && defaultNamespace.equals(uri)) {
            return "";
        }
        String prefix = this.getNamespaceResolver().resolveNamespaceURI(uri);
        if (prefix != null) {
            return prefix;
        }
        for (Object next : this.getNamespaceResolver().getNamespaces()) {
            Namespace ns = (Namespace)next;
            uri = ns.getNamespaceURI();
            prefix = ns.getPrefix();
        }
        return xPathFragment.getPrefix();
    }

    public CycleDetectionStack<Object> getCycleDetectionStack() {
        return this.cycleDetectionStack;
    }

    static /* synthetic */ Object[] access$1() {
        return EMPTY_CYCLE_DATA;
    }

    public class CycleDetectionStack<E>
    extends AbstractList<Object> {
        private Object[] data = MarshalRecord.access$1();
        int currentIndex = 0;

        public void push(E item) {
            if (this.currentIndex == this.data.length) {
                this.growArray();
            }
            this.data[this.currentIndex] = item;
            ++this.currentIndex;
        }

        private void growArray() {
            Object[] newArray = new Object[this.data.length * 2];
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            this.data = newArray;
        }

        public Object pop() {
            Object o = this.data[this.currentIndex - 1];
            this.data[this.currentIndex - 1] = null;
            --this.currentIndex;
            return o;
        }

        public boolean contains(Object item, boolean equalsUsingIdentity) {
            if (equalsUsingIdentity) {
                int i = 0;
                while (i < this.currentIndex) {
                    if (this.data[i] == item) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.currentIndex) {
                    if (this.data[i] != null && this.data[i].equals(item)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String getCycleString() {
            Object x;
            StringBuilder sb = new StringBuilder();
            int i = this.size() - 1;
            Object obj = this.get(i);
            sb.append(obj);
            do {
                sb.append(" -> ");
                x = this.get(--i);
                sb.append(x);
            } while (obj != x);
            return sb.toString();
        }

        @Override
        public Object get(int index) {
            return this.data[index];
        }

        @Override
        public int size() {
            return this.data.length;
        }
    }
}

