/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ResultSetMappingQuery
extends ObjectBuildingQuery {
    protected boolean isExecuteCall;
    protected Vector resultRows;
    protected List<String> resultSetMappingNames = new ArrayList<String>();
    protected List<SQLResultSetMapping> resultSetMappings = new ArrayList<SQLResultSetMapping>();

    public ResultSetMappingQuery() {
    }

    public ResultSetMappingQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ResultSetMappingQuery(Call call, String sqlResultSetMappingName) {
        this();
        this.setCall(call);
        this.resultSetMappingNames.add(sqlResultSetMappingName);
    }

    public void addSQLResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.resultSetMappings.add(resultSetMapping);
        this.resultSetMappingNames.add(resultSetMapping.getName());
    }

    public void addSQLResultSetMappingName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_sqlresultsetmapping_in_query"));
        }
        this.resultSetMappingNames.add(name);
    }

    @Override
    public void cacheResult(Object unwrappedOriginal) {
        Object cachableObject = unwrappedOriginal;
        if (this.shouldUseWrapperPolicy()) {
            cachableObject = this.getSession().wrapObject(unwrappedOriginal);
        }
        this.setTemporaryCachedQueryResults(cachableObject);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (SQLResultSetMapping mapping : this.resultSetMappings) {
            mapping.convertClassNamesToClasses(classLoader);
        }
    }

    public void setSQLResultSetMapping(SQLResultSetMapping resultSetMapping) {
        this.addSQLResultSetMapping(resultSetMapping);
    }

    public void setSQLResultSetMappings(List<SQLResultSetMapping> resultSetMappings) {
        this.resultSetMappings = resultSetMappings;
    }

    public void setSQLResultSetMappingName(String name) {
        this.addSQLResultSetMappingName(name);
    }

    public void setSQLResultSetMappingNames(List<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_sqlresultsetmapping_in_query"));
        }
        this.resultSetMappingNames = names;
    }

    public List buildObjectsFromRecords(List databaseRecords) {
        if (this.getSQLResultSetMappings().size() > 1) {
            int numberOfRecords = databaseRecords.size();
            ArrayList<List> results = new ArrayList<List>(numberOfRecords);
            int recordIndex = 0;
            while (recordIndex < numberOfRecords) {
                Object records = databaseRecords.get(recordIndex);
                if (records instanceof DatabaseRecord) {
                    DatabaseRecord dRecords = (DatabaseRecord)records;
                    for (Object dRecord : dRecords.keySet()) {
                        Vector blah = (Vector)((Vector)dRecords.get(dRecord)).get(0);
                        System.out.println("blah is:" + blah.getClass());
                        results.add(this.buildObjectsFromRecords((List)blah, this.getSQLResultSetMappings().get(recordIndex)));
                        ++recordIndex;
                    }
                } else {
                    results.add(this.buildObjectsFromRecords((List)records, this.getSQLResultSetMappings().get(recordIndex)));
                }
                ++recordIndex;
            }
            return results;
        }
        return this.buildObjectsFromRecords(databaseRecords, this.getSQLResultSetMapping());
    }

    public List buildObjectsFromRecords(List databaseRecords, int index) {
        return this.buildObjectsFromRecords(databaseRecords, this.getSQLResultSetMappings().get(index));
    }

    protected List buildObjectsFromRecords(List databaseRecords, SQLResultSetMapping mapping) {
        int numberOfRecords = databaseRecords.size();
        ArrayList<Object> results = new ArrayList<Object>(numberOfRecords);
        if (mapping == null) {
            for (DatabaseRecord record : databaseRecords) {
                results.add(record.values().toArray());
            }
        } else {
            Iterator iterator = databaseRecords.iterator();
            while (iterator.hasNext()) {
                if (mapping.getResults().size() > 1) {
                    Object[] resultElement = new Object[mapping.getResults().size()];
                    DatabaseRecord record = (DatabaseRecord)iterator.next();
                    int i = 0;
                    while (i < mapping.getResults().size()) {
                        resultElement[i] = mapping.getResults().get(i).getValueFromRecord(record, this);
                        ++i;
                    }
                    results.add(resultElement);
                    continue;
                }
                if (mapping.getResults().size() == 1) {
                    DatabaseRecord record = (DatabaseRecord)iterator.next();
                    results.add(mapping.getResults().get(0).getValueFromRecord(record, this));
                    continue;
                }
                return results;
            }
        }
        return results;
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
            if (unitOfWork.isNestedUnitOfWork()) {
                UnitOfWorkImpl nestedUnitOfWork = (UnitOfWorkImpl)this.getSession();
                this.setSession(nestedUnitOfWork.getParent());
                Object result = this.executeDatabaseQuery();
                this.setSession(nestedUnitOfWork);
                Object clone = this.registerIndividualResult(result, null, unitOfWork, null, null);
                if (this.shouldUseWrapperPolicy()) {
                    clone = this.getDescriptor().getObjectBuilder().wrapObject(clone, unitOfWork);
                }
                return clone;
            }
        }
        this.session.validateQuery(this);
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        if (this.getCall().isExecuteUpdate()) {
            StoredProcedureCall call = (StoredProcedureCall)this.getQueryMechanism().execute();
            this.setExecutionTime(System.currentTimeMillis());
            return call;
        }
        Vector rows = this.getQueryMechanism().executeSelect();
        this.setExecutionTime(System.currentTimeMillis());
        return this.buildObjectsFromRecords(rows);
    }

    @Override
    public boolean isResultSetMappingQuery() {
        return true;
    }

    @Override
    protected void prepare() {
        if (!this.shouldMaintainCache() && this.shouldRefreshIdentityMapResult()) {
            throw QueryException.refreshNotPossibleWithoutCache(this);
        }
        this.getQueryMechanism().prepare();
        if (this.isExecuteCall) {
            this.getQueryMechanism().prepareExecute();
        } else {
            this.getQueryMechanism().prepareExecuteSelect();
        }
    }

    public SQLResultSetMapping getSQLResultSetMapping() {
        if (this.resultSetMappings.isEmpty()) {
            if (this.resultSetMappingNames.isEmpty()) {
                return null;
            }
            return this.getSession().getProject().getSQLResultSetMapping(this.resultSetMappingNames.get(0));
        }
        return this.resultSetMappings.get(0);
    }

    public List<SQLResultSetMapping> getSQLResultSetMappings() {
        if (this.resultSetMappings.isEmpty()) {
            ArrayList<SQLResultSetMapping> list = new ArrayList<SQLResultSetMapping>();
            for (String resultSetMappingName : this.resultSetMappingNames) {
                list.add(this.getSession().getProject().getSQLResultSetMapping(resultSetMappingName));
            }
            return list;
        }
        return this.resultSetMappings;
    }

    public String getSQLResultSetMappingName() {
        return this.resultSetMappingNames.get(0);
    }

    public List<String> getSQLResultSetMappingNames() {
        return this.resultSetMappingNames;
    }

    public void setIsExecuteCall() {
        this.isExecuteCall = true;
        this.setIsPrepared(false);
    }
}

