/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.jpql.AbstractObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.DeleteQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.EclipseLinkSemanticValidatorHelper;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.ObjectLevelReadQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReadAllQueryBuilder;
import org.eclipse.persistence.internal.jpa.jpql.ReadAllQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.ReportQueryVisitor;
import org.eclipse.persistence.internal.jpa.jpql.UpdateQueryVisitor;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.EclipseLinkGrammarValidator;
import org.eclipse.persistence.jpa.jpql.EclipseLinkSemanticValidator;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblemResourceBundle;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar1_0;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar2_0;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar2_1;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

public final class HermesParser
implements JPAQueryBuilder {
    private String validationLevel = "EclipseLink";

    private void addArguments(JPQLQueryContext queryContext, DatabaseQuery databaseQuery) {
        Map<String, Class<?>> inputParameters = queryContext.inputParameters();
        if (inputParameters != null) {
            for (String inputParameter : inputParameters.keySet()) {
                databaseQuery.addArgument(inputParameter.substring(1), inputParameters.get(inputParameter));
            }
        }
    }

    private JPQLException buildException(JPQLQueryContext queryContext, Collection<JPQLQueryProblem> problems, String messageKey) {
        ResourceBundle bundle = this.resourceBundle();
        StringBuilder sb = new StringBuilder();
        for (JPQLQueryProblem problem : problems) {
            String message;
            try {
                message = bundle.getString(problem.getMessageKey());
            }
            catch (NullPointerException nullPointerException) {
                message = problem.getMessageKey();
            }
            Object[] arguments = problem.getMessageArguments();
            if (arguments.length > 0) {
                message = MessageFormat.format(message, arguments);
            }
            sb.append("\n");
            sb.append("[");
            sb.append(problem.getStartPosition());
            sb.append(", ");
            sb.append(problem.getEndPosition());
            sb.append("] ");
            sb.append(message);
        }
        String errorMessage = bundle.getString(messageKey);
        errorMessage = MessageFormat.format(errorMessage, queryContext.getJPQLQuery(), sb);
        return new JPQLException(errorMessage);
    }

    @Override
    public DatabaseQuery buildQuery(CharSequence jpqlQuery, AbstractSession session) {
        return this.populateQueryImp(jpqlQuery, null, session);
    }

    @Override
    public org.eclipse.persistence.expressions.Expression buildSelectionCriteria(String entityName, String selectionCriteria, AbstractSession session) {
        try {
            JPQLExpression jpqlExpression = new JPQLExpression((CharSequence)selectionCriteria, DefaultEclipseLinkJPQLGrammar.instance(), "conditional_expression", this.isTolerant());
            JPQLQueryContext queryContext = new JPQLQueryContext(this.jpqlGrammar());
            queryContext.cache(session, null, jpqlExpression, selectionCriteria);
            queryContext.addRangeVariableDeclaration(entityName, "this");
            this.validate(queryContext, jpqlExpression.getQueryStatement());
            return queryContext.buildExpression(jpqlExpression.getQueryStatement());
        }
        catch (JPQLException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw this.buildUnexpectedException(selectionCriteria, exception);
        }
    }

    private JPQLException buildUnexpectedException(CharSequence jpqlQuery, Exception exception) {
        String errorMessage = this.resourceBundle().getString("HERMES_PARSER_UNEXPECTED_EXCEPTION_ERROR_MESSAGE");
        errorMessage = MessageFormat.format(errorMessage, jpqlQuery);
        return new JPQLException(errorMessage, exception);
    }

    private boolean isTolerant() {
        return this.validationLevel != "None";
    }

    private JPQLGrammar jpqlGrammar() {
        if (this.validationLevel == "EclipseLink") {
            return DefaultEclipseLinkJPQLGrammar.instance();
        }
        if (this.validationLevel == "JPA 1.0") {
            return JPQLGrammar1_0.instance();
        }
        if (this.validationLevel == "JPA 2.0") {
            return JPQLGrammar2_0.instance();
        }
        if (this.validationLevel == "JPA 2.1") {
            return JPQLGrammar2_1.instance();
        }
        return DefaultEclipseLinkJPQLGrammar.instance();
    }

    @Override
    public void populateQuery(CharSequence jpqlQuery, DatabaseQuery query, AbstractSession session) {
        this.populateQueryImp(jpqlQuery, query, session);
    }

    private DatabaseQuery populateQueryImp(CharSequence jpqlQuery, DatabaseQuery query, AbstractSession session) {
        try {
            JPQLExpression jpqlExpression = new JPQLExpression(jpqlQuery, DefaultEclipseLinkJPQLGrammar.instance(), this.isTolerant());
            JPQLQueryContext queryContext = new JPQLQueryContext(this.jpqlGrammar());
            queryContext.cache(session, query, jpqlExpression, jpqlQuery);
            this.validate(queryContext, (Expression)jpqlExpression);
            DatabaseQueryVisitor visitor = new DatabaseQueryVisitor(queryContext, jpqlQuery);
            jpqlExpression.accept((ExpressionVisitor)visitor);
            if (query == null) {
                query = queryContext.getDatabaseQuery();
                this.addArguments(queryContext, query);
            }
            return query;
        }
        catch (JPQLException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw this.buildUnexpectedException(jpqlQuery, exception);
        }
    }

    private ResourceBundle resourceBundle() {
        return ResourceBundle.getBundle(JPQLQueryProblemResourceBundle.class.getName());
    }

    @Override
    public void setValidationLevel(String validationLevel) {
        this.validationLevel = validationLevel;
    }

    private void validate(JPQLQueryContext queryContext, Expression expression) {
        if (this.validationLevel != "None") {
            LinkedList<JPQLQueryProblem> problems = new LinkedList<JPQLQueryProblem>();
            EclipseLinkGrammarValidator grammar = new EclipseLinkGrammarValidator(this.jpqlGrammar());
            grammar.setProblems(problems);
            expression.accept((ExpressionVisitor)grammar);
            if (!problems.isEmpty()) {
                throw this.buildException(queryContext, problems, "HERMES_PARSER_GRAMMAR_VALIDATOR_ERROR_MESSAGE");
            }
            EclipseLinkSemanticValidatorHelper helper = new EclipseLinkSemanticValidatorHelper(queryContext);
            EclipseLinkSemanticValidator semantic = new EclipseLinkSemanticValidator((SemanticValidatorHelper)helper);
            semantic.setProblems(problems);
            expression.accept((ExpressionVisitor)semantic);
            if (!problems.isEmpty()) {
                throw this.buildException(queryContext, problems, "HERMES_PARSER_SEMANTIC_VALIDATOR_ERROR_MESSAGE");
            }
        }
    }

    private static class DatabaseQueryVisitor
    extends AbstractExpressionVisitor {
        private final String jpqlQuery;
        private final JPQLQueryContext queryContext;

        DatabaseQueryVisitor(JPQLQueryContext queryContext, CharSequence jpqlQuery) {
            this.jpqlQuery = jpqlQuery.toString();
            this.queryContext = queryContext;
        }

        private ReadAllQuery buildReadAllQuery(SelectStatement expression) {
            ReadAllQueryBuilder visitor = new ReadAllQueryBuilder(this.queryContext);
            expression.accept((ExpressionVisitor)visitor);
            return visitor.query;
        }

        private AbstractObjectLevelReadQueryVisitor buildVisitor(ObjectLevelReadQuery query) {
            if (query.isReportQuery()) {
                return new ReportQueryVisitor(this.queryContext, (ReportQuery)query);
            }
            if (query.isReadAllQuery()) {
                return new ReadAllQueryVisitor(this.queryContext, (ReadAllQuery)query);
            }
            return new ObjectLevelReadQueryVisitor(this.queryContext, query);
        }

        public void visit(DeleteStatement expression) {
            DeleteAllQuery query = (DeleteAllQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new DeleteAllQuery();
                this.queryContext.setDatabasQuery(query);
                query.setJPQLString(this.jpqlQuery);
                ((JPQLCallQueryMechanism)query.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            }
            query.setSession(this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            DeleteQueryVisitor visitor = new DeleteQueryVisitor(this.queryContext, query);
            expression.accept((ExpressionVisitor)visitor);
        }

        public void visit(JPQLExpression expression) {
            expression.getQueryStatement().accept((ExpressionVisitor)this);
        }

        public void visit(SelectStatement expression) {
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = this.buildReadAllQuery(expression);
                this.queryContext.setDatabasQuery(query);
                query.setJPQLString(this.jpqlQuery);
                ((JPQLCallQueryMechanism)query.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            }
            expression.accept((ExpressionVisitor)this.buildVisitor(query));
        }

        public void visit(UpdateStatement expression) {
            UpdateAllQuery query = (UpdateAllQuery)this.queryContext.getDatabaseQuery();
            if (query == null) {
                query = new UpdateAllQuery();
                this.queryContext.setDatabasQuery(query);
                query.setJPQLString(this.jpqlQuery);
                ((JPQLCallQueryMechanism)query.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            }
            query.setSession(this.queryContext.getSession());
            query.setShouldDeferExecutionInUOW(false);
            UpdateQueryVisitor visitor = new UpdateQueryVisitor(this.queryContext, query);
            expression.accept((ExpressionVisitor)visitor);
        }
    }
}

