/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneIterable;

public class FromSubqueryResolver
extends Resolver {
    private IManagedType managedType;
    private JPQLQueryContext queryContext;
    private SimpleSelectStatement subquery;

    public FromSubqueryResolver(Resolver parent, JPQLQueryContext queryContext, SimpleSelectStatement subquery) {
        super(parent);
        this.subquery = subquery;
        this.queryContext = queryContext;
    }

    public void accept(ResolverVisitor visitor) {
    }

    protected IType buildType() {
        return this.getManagedType().getType();
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }

    public IManagedType getManagedType() {
        if (this.managedType == null) {
            this.managedType = new VirtualManagedType();
        }
        return this.managedType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VirtualManagedType
    implements IManagedType {
        private Map<String, IMapping> mappings;

        protected VirtualManagedType() {
        }

        @Override
        public void accept(IManagedTypeVisitor visitor) {
        }

        @Override
        public int compareTo(IManagedType managedType) {
            return this.getType().getName().compareTo(managedType.getType().getName());
        }

        @Override
        public IMapping getMappingNamed(String name) {
            this.initializeMappings();
            return this.mappings.get(name);
        }

        @Override
        public IManagedTypeProvider getProvider() {
            return FromSubqueryResolver.this.getProvider();
        }

        @Override
        public IType getType() {
            return this.getProvider().getTypeRepository().getType("UNRESOLVABLE_TYPE");
        }

        private void initializeMappings() {
            if (this.mappings == null) {
                this.mappings = new HashMap<String, IMapping>();
                VirtualMappingBuilder builder = new VirtualMappingBuilder();
                builder.parent = this;
                builder.mappings = this.mappings;
                FromSubqueryResolver.this.subquery.accept(builder);
            }
        }

        @Override
        public Iterable<IMapping> mappings() {
            this.initializeMappings();
            return new SnapshotCloneIterable<IMapping>(this.mappings.values());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VirtualMapping
    implements IMapping {
        private String name;
        private IManagedType parent;
        private Resolver resolver;

        protected VirtualMapping(IManagedType parent, String name, Resolver resolver) {
            this.name = name;
            this.parent = parent;
            this.resolver = resolver;
        }

        @Override
        public int compareTo(IMapping mapping) {
            return this.getName().compareTo(mapping.getName());
        }

        @Override
        public int getMappingType() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.getMappingType() : 10;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IManagedType getParent() {
            return this.parent;
        }

        @Override
        public IType getType() {
            return this.resolver.getType();
        }

        @Override
        public ITypeDeclaration getTypeDeclaration() {
            return this.resolver.getTypeDeclaration();
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.getType().hasAnnotation(annotationType);
        }

        @Override
        public boolean isCollection() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isCollection() : false;
        }

        @Override
        public boolean isProperty() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isProperty() : false;
        }

        @Override
        public boolean isRelationship() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isRelationship() : false;
        }

        @Override
        public boolean isTransient() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isTransient() : false;
        }
    }

    protected class VirtualMappingBuilder
    extends AbstractEclipseLinkExpressionVisitor {
        private Map<String, IMapping> mappings;
        protected IManagedType parent;

        protected VirtualMappingBuilder() {
        }

        protected IMapping buildMapping(String name, Resolver resolver) {
            return new VirtualMapping(this.parent, name, resolver);
        }

        protected String literal(Expression expression, LiteralType literalType) {
            return FromSubqueryResolver.this.queryContext.literal(expression, literalType);
        }

        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        public void visit(ResultVariable expression) {
            String name = this.literal(expression, LiteralType.RESULT_VARIABLE);
            if (ExpressionTools.stringIsNotEmpty(name)) {
                Resolver resolver = FromSubqueryResolver.this.queryContext.getResolver(expression.getSelectExpression());
                this.mappings.put(name, this.buildMapping(name, resolver));
            }
        }

        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        public void visit(SimpleSelectStatement expression) {
            expression.getSelectClause().accept(this);
        }

        public void visit(StateFieldPathExpression expression) {
            String name;
            if (!expression.startsWithDot() && ExpressionTools.stringIsNotEmpty(name = this.literal(expression, LiteralType.PATH_EXPRESSION_LAST_PATH))) {
                Resolver resolver = FromSubqueryResolver.this.queryContext.getResolver(expression);
                this.mappings.put(name, this.buildMapping(name, resolver));
            }
        }
    }
}

