/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.ResolverVisitor;
import org.eclipse.persistence.jpa.jpql.TypeHelper;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resolver {
    private boolean nullAllowed;
    private final Resolver parent;
    private Map<String, Resolver> resolvers;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    protected Resolver(Resolver parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    public abstract void accept(ResolverVisitor var1);

    public final void addChild(String variableName, Resolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new HashMap<String, Resolver>();
        }
        this.resolvers.put(variableName, resolver);
    }

    protected IType buildType() {
        return this.getTypeDeclaration().getType();
    }

    protected abstract ITypeDeclaration buildTypeDeclaration();

    protected void checkParent(Resolver parent) {
        if (parent == null) {
            throw new NullPointerException("The parent resolver cannot be null");
        }
    }

    public final Resolver getChild(String variableName) {
        return this.resolvers != null ? this.resolvers.get(variableName) : null;
    }

    public IManagedType getManagedType() {
        return null;
    }

    public IMapping getMapping() {
        return null;
    }

    public Resolver getParent() {
        return this.parent;
    }

    protected final IManagedType getParentManagedType() {
        return this.parent.getManagedType();
    }

    protected final IMapping getParentMapping() {
        return this.parent.getMapping();
    }

    protected final IType getParentType() {
        return this.parent.getType();
    }

    protected final ITypeDeclaration getParentTypeDeclaration() {
        return this.parent.getTypeDeclaration();
    }

    protected final IManagedTypeProvider getProvider() {
        return this.getQuery().getProvider();
    }

    protected IQuery getQuery() {
        return this.parent.getQuery();
    }

    public final IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    protected final IType getType(Class<?> type) {
        return this.getTypeRepository().getType(type);
    }

    protected final IType getType(String typeName) {
        return this.getTypeRepository().getType(typeName);
    }

    protected final ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    protected final TypeHelper getTypeHelper() {
        return this.getTypeRepository().getTypeHelper();
    }

    protected final ITypeRepository getTypeRepository() {
        return this.getQuery().getProvider().getTypeRepository();
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }
}

