/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionMemberDeclaration
extends AbstractExpression {
    private String asIdentifier;
    private AbstractExpression collectionValuedPathExpression;
    private boolean hasLeftParenthesis;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterAs;
    private boolean hasSpaceAfterIn;
    private boolean hasSpaceAfterRightParenthesis;
    private AbstractExpression identificationVariable;
    private String inIdentifier;

    public CollectionMemberDeclaration(AbstractExpression parent) {
        super(parent, "IN");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getCollectionValuedPathExpression().accept(visitor);
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getCollectionValuedPathExpression());
        children.add(this.getIdentificationVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("IN"));
        if (this.hasSpaceAfterIn) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        }
        if (this.collectionValuedPathExpression != null) {
            children.add(this.collectionValuedPathExpression);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
        if (this.hasSpaceAfterRightParenthesis) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.asIdentifier != null) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.identificationVariable != null) {
            children.add(this.identificationVariable);
        }
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier;
    }

    public String getActualInIdentifier() {
        return this.inIdentifier;
    }

    public Expression getCollectionValuedPathExpression() {
        if (this.collectionValuedPathExpression == null) {
            this.collectionValuedPathExpression = this.buildNullExpression();
        }
        return this.collectionValuedPathExpression;
    }

    public Expression getIdentificationVariable() {
        if (this.identificationVariable == null) {
            this.identificationVariable = this.buildNullExpression();
        }
        return this.identificationVariable;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("collection_member_declaration");
    }

    public boolean hasAs() {
        return this.asIdentifier != null;
    }

    public boolean hasCollectionValuedPathExpression() {
        return this.collectionValuedPathExpression != null && !this.collectionValuedPathExpression.isNull();
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable != null && !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    public boolean hasSpaceAfterIn() {
        return this.hasSpaceAfterIn;
    }

    public boolean hasSpaceAfterRightParenthesis() {
        return this.hasSpaceAfterRightParenthesis;
    }

    public boolean isDerived() {
        return !this.hasLeftParenthesis && !this.hasRightParenthesis && !this.hasSpaceAfterRightParenthesis && this.asIdentifier == null && !this.hasIdentificationVariable();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || word.equalsIgnoreCase("AS") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.inIdentifier = wordParser.moveForward("IN");
        int count = wordParser.skipLeadingWhitespace();
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        } else {
            this.hasSpaceAfterIn = count > 0;
            count = 0;
        }
        this.collectionValuedPathExpression = this.parse(wordParser, "collection_valued_path_expression", tolerant);
        if (this.collectionValuedPathExpression != null) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasRightParenthesis = wordParser.startsWith(')');
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
            boolean bl = this.hasSpaceAfterRightParenthesis = count > 0;
            if (!this.hasLeftParenthesis && !wordParser.startsWithIdentifier("AS") && (wordParser.isTail() || this.isParsingComplete(wordParser, wordParser.word(), null))) {
                this.hasRightParenthesis = false;
                this.hasSpaceAfterRightParenthesis = false;
                wordParser.moveBackward(count + 1);
                return;
            }
        } else {
            boolean bl = this.hasSpaceAfterRightParenthesis = count > 0;
        }
        if (wordParser.startsWithIdentifier("AS")) {
            this.asIdentifier = wordParser.moveForward("AS");
            this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        boolean parseVariable = true;
        if (!tolerant && !this.hasLeftParenthesis && !this.hasRightParenthesis && this.hasSpaceAfterRightParenthesis && this.asIdentifier == null && this.isParsingComplete(wordParser, wordParser.word(), null)) {
            parseVariable = false;
        }
        if (parseVariable) {
            this.identificationVariable = this.parse(wordParser, "identification_variable", tolerant);
        }
        if (!this.hasLeftParenthesis && !this.hasRightParenthesis && this.hasSpaceAfterRightParenthesis && this.asIdentifier == null && this.identificationVariable == null) {
            this.hasSpaceAfterRightParenthesis = false;
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.inIdentifier : this.getText());
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIn) {
            writer.append(' ');
        }
        if (this.collectionValuedPathExpression != null) {
            this.collectionValuedPathExpression.toParsedText(writer, actual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
        if (this.hasSpaceAfterRightParenthesis) {
            writer.append(' ');
        }
        if (this.asIdentifier != null) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.identificationVariable != null) {
            this.identificationVariable.toParsedText(writer, actual);
        }
    }

    public String toParsedTextUntilAs() {
        StringBuilder writer = new StringBuilder();
        writer.append(this.getText());
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIn) {
            writer.append(' ');
        }
        if (this.collectionValuedPathExpression != null) {
            this.collectionValuedPathExpression.toParsedText(writer, false);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
        if (this.hasSpaceAfterRightParenthesis) {
            writer.append(' ');
        }
        return writer.toString();
    }
}

