/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectStatement
extends AbstractSelectStatement {
    private boolean hasSpaceBeforeOrderBy;
    private boolean hasSpaceBeforeUnion;
    private AbstractExpression orderByClause;
    private AbstractExpression unionClauses;

    public SelectStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        super.acceptChildren(visitor);
        this.getOrderByClause().accept(visitor);
        this.getUnionClauses().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        super.addChildrenTo(children);
        children.add(this.getOrderByClause());
        children.add(this.getUnionClauses());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        super.addOrderedChildrenTo(children);
        if (this.hasSpaceBeforeOrderBy) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderByClause != null) {
            children.add(this.orderByClause);
        }
        if (this.unionClauses != null) {
            children.add(this.unionClauses);
        }
    }

    @Override
    protected FromClause buildFromClause() {
        return new FromClause(this);
    }

    @Override
    protected SelectClause buildSelectClause() {
        return new SelectClause(this);
    }

    public Expression getOrderByClause() {
        if (this.orderByClause == null) {
            this.orderByClause = this.buildNullExpression();
        }
        return this.orderByClause;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("select_statement");
    }

    public Expression getUnionClauses() {
        if (this.unionClauses == null) {
            this.unionClauses = this.buildNullExpression();
        }
        return this.unionClauses;
    }

    public boolean hasOrderByClause() {
        return this.orderByClause != null && !this.orderByClause.isNull();
    }

    public boolean hasSpaceBeforeOrderBy() {
        return this.hasSpaceBeforeOrderBy;
    }

    public boolean hasSpaceBeforeUnion() {
        return this.hasSpaceBeforeUnion;
    }

    public boolean hasUnionClauses() {
        return this.unionClauses != null && !this.unionClauses.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        if (word.equalsIgnoreCase("UNION") || word.equalsIgnoreCase("INTERSECT") || word.equalsIgnoreCase("EXCEPT")) {
            return false;
        }
        return super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        super.parse(wordParser, tolerant);
        boolean bl = this.hasSpaceBeforeOrderBy = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("ORDER BY")) {
            this.orderByClause = new OrderByClause(this);
            this.orderByClause.parse(wordParser, tolerant);
        }
        if (this.getQueryBNF("union_clause") != null) {
            this.hasSpaceBeforeUnion = wordParser.skipLeadingWhitespace() > 0;
            this.unionClauses = this.parse(wordParser, "union_clause", tolerant);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        super.toParsedText(writer, actual);
        if (this.hasSpaceBeforeOrderBy) {
            writer.append(' ');
        }
        if (this.hasOrderByClause()) {
            this.orderByClause.toParsedText(writer, actual);
        }
        if (this.hasSpaceBeforeUnion) {
            writer.append(' ');
        }
        if (this.hasUnionClauses()) {
            this.unionClauses.toParsedText(writer, actual);
        }
    }
}

