/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhenClause
extends AbstractExpression {
    private boolean hasSpaceAfterThen;
    private boolean hasSpaceAfterWhen;
    private boolean hasSpaceAfterWhenExpression;
    private AbstractExpression thenExpression;
    private String thenIdentifier;
    private AbstractExpression whenExpression;
    private String whenIdentifier;

    public WhenClause(AbstractExpression parent) {
        super(parent, "WHEN");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getWhenExpression().accept(visitor);
        this.getThenExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getWhenExpression());
        children.add(this.getThenExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("WHEN"));
        if (this.hasSpaceAfterWhen) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whenExpression != null) {
            children.add(this.whenExpression);
        }
        if (this.hasSpaceAfterWhenExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.thenIdentifier != null) {
            children.add(this.buildStringExpression("THEN"));
        }
        if (this.hasSpaceAfterThen) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.thenExpression != null) {
            children.add(this.thenExpression);
        }
    }

    public String getActualThenIdentifier() {
        return this.thenIdentifier != null ? this.thenIdentifier : "";
    }

    public String getActualWhenIdentifier() {
        return this.whenIdentifier;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("when_clause");
    }

    public AbstractExpression getThenExpression() {
        if (this.thenExpression == null) {
            this.thenExpression = this.buildNullExpression();
        }
        return this.thenExpression;
    }

    public AbstractExpression getWhenExpression() {
        if (this.whenExpression == null) {
            this.whenExpression = this.buildNullExpression();
        }
        return this.whenExpression;
    }

    public boolean hasSpaceAfterThen() {
        return this.hasSpaceAfterThen;
    }

    public boolean hasSpaceAfterWhen() {
        return this.hasSpaceAfterWhen;
    }

    public boolean hasSpaceAfterWhenExpression() {
        return this.hasSpaceAfterWhenExpression;
    }

    public boolean hasThen() {
        return this.thenIdentifier != null;
    }

    public boolean hasThenExpression() {
        return this.thenExpression != null && !this.thenExpression.isNull();
    }

    public boolean hasWhenExpression() {
        return this.whenExpression != null && !this.whenExpression.isNull();
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("WHEN") || word.equalsIgnoreCase("THEN") || word.equalsIgnoreCase("ELSE") || word.equalsIgnoreCase("END") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.whenIdentifier = wordParser.moveForward("WHEN");
        this.hasSpaceAfterWhen = wordParser.skipLeadingWhitespace() > 0;
        this.whenExpression = this.parse(wordParser, "internal_when_clause*", tolerant);
        boolean bl = this.hasSpaceAfterWhenExpression = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("THEN")) {
            this.thenIdentifier = wordParser.moveForward("THEN");
            this.hasSpaceAfterThen = wordParser.skipLeadingWhitespace() > 0;
        }
        this.thenExpression = this.parse(wordParser, "scalar_expression", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.whenIdentifier : "WHEN");
        if (this.hasSpaceAfterWhen) {
            writer.append(' ');
        }
        if (this.whenExpression != null) {
            this.whenExpression.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterWhenExpression) {
            writer.append(' ');
        }
        if (this.thenIdentifier != null) {
            writer.append(actual ? this.thenIdentifier : "THEN");
        }
        if (this.hasSpaceAfterThen) {
            writer.append(' ');
        }
        if (this.thenExpression != null) {
            this.thenExpression.toParsedText(writer, actual);
        }
    }
}

