/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.javax.persistence.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiProviderResolver
implements PersistenceProviderResolver,
PersistenceProvider {
    BundleContext ctx;

    public OSGiProviderResolver(BundleContext bundleContext) {
        this.ctx = bundleContext;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        ArrayList<PersistenceProvider> arrayList = new ArrayList<PersistenceProvider>();
        arrayList.add(this);
        return arrayList;
    }

    @Override
    public void clearCachedProviders() {
    }

    @Override
    public EntityManagerFactory createEntityManagerFactory(String string, Map map) {
        return map == null || map.isEmpty() ? this.lookupEMF(string) : this.lookupEMFBuilder(string, map);
    }

    @Override
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo persistenceUnitInfo, Map map) {
        return null;
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return new ForwardingProviderUtil();
    }

    public EntityManagerFactory lookupEMF(String string) {
        this.debug("Persistence class - lookupEMF, punit=", string);
        String string2 = null;
        ServiceReference[] serviceReferenceArray = null;
        try {
            string2 = "(osgi.unit.name=" + string + ")";
            serviceReferenceArray = this.ctx.getServiceReferences(EntityManagerFactory.class.getName(), string2);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            new PersistenceException("Implementation error - incorrect filter specified while looking up EMF", invalidSyntaxException);
        }
        if (serviceReferenceArray != null && serviceReferenceArray.length != 0) {
            this.debug("Persistence class - lookupEMF, found service ", string, " in registry");
            return (EntityManagerFactory)this.ctx.getService(serviceReferenceArray[0]);
        }
        this.debug("Persistence class - lookupEMF, *** EMF service ", string, " not found in registry ***");
        return null;
    }

    public EntityManagerFactory lookupEMFBuilder(String string, Map<?, ?> map) {
        this.debug("Persistence class - lookupEMFBuilder, punit=", string);
        String string2 = null;
        ServiceReference[] serviceReferenceArray = null;
        try {
            string2 = "(osgi.unit.name=" + string + ")";
            serviceReferenceArray = this.ctx.getServiceReferences(EntityManagerFactoryBuilder.class.getName(), string2);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            new PersistenceException("Implementation error - incorrect filter specified while looking up EMF", invalidSyntaxException);
        }
        if (serviceReferenceArray != null && serviceReferenceArray.length != 0) {
            this.debug("Persistence class - lookupEMFBuilder, found service ", string, " in registry");
            EntityManagerFactoryBuilder entityManagerFactoryBuilder = (EntityManagerFactoryBuilder)this.ctx.getService(serviceReferenceArray[0]);
            return entityManagerFactoryBuilder.createEntityManagerFactory(map);
        }
        this.debug("Persistence class - lookupEMFBuilder, *** EMFBuilder service ", string, " not found in registry ***");
        return null;
    }

    public Collection<PersistenceProvider> lookupProviders() {
        this.debug("Persistence class - lookupProviders");
        HashSet<PersistenceProvider> hashSet = new HashSet<PersistenceProvider>();
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = this.ctx.getServiceReferences(PersistenceProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (serviceReferenceArray != null) {
            for (ServiceReference serviceReference : serviceReferenceArray) {
                hashSet.add((PersistenceProvider)this.ctx.getService(serviceReference));
            }
        }
        return hashSet;
    }

    protected void debug(String ... stringArray) {
        if (System.getProperty("JPA_DEBUG") != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string);
            }
            System.out.println(stringBuilder.toString());
        }
    }

    @Override
    public void generateSchema(PersistenceUnitInfo persistenceUnitInfo, Map map) {
    }

    public class ForwardingProviderUtil
    implements ProviderUtil {
        public LoadState isLoadedWithReference(Object object, String string) {
            Collection<PersistenceProvider> collection = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider persistenceProvider : collection) {
                LoadState loadState = persistenceProvider.getProviderUtil().isLoadedWithReference(object, string);
                if (loadState == LoadState.UNKNOWN) continue;
                return loadState;
            }
            return LoadState.UNKNOWN;
        }

        public LoadState isLoadedWithoutReference(Object object, String string) {
            Collection<PersistenceProvider> collection = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider persistenceProvider : collection) {
                LoadState loadState = persistenceProvider.getProviderUtil().isLoadedWithoutReference(object, string);
                if (loadState == LoadState.UNKNOWN) continue;
                return loadState;
            }
            return LoadState.UNKNOWN;
        }

        public LoadState isLoaded(Object object) {
            Collection<PersistenceProvider> collection = OSGiProviderResolver.this.lookupProviders();
            for (PersistenceProvider persistenceProvider : collection) {
                LoadState loadState = persistenceProvider.getProviderUtil().isLoaded(object);
                if (loadState == LoadState.UNKNOWN) continue;
                return loadState;
            }
            return LoadState.UNKNOWN;
        }
    }
}

