/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.jpql.ConstructorQueryMappings;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;

public class JUnitJPQLQueryHelperTestSuite
extends JUnitTestCase {
    public JUnitJPQLQueryHelperTestSuite() {
    }

    public JUnitJPQLQueryHelperTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLQueryHelperTestSuite");
        suite.addTest((Test)new JUnitJPQLQueryHelperTestSuite("test_getConstructorQueryMappings_01"));
        suite.addTest((Test)new JUnitJPQLQueryHelperTestSuite("test_getConstructorQueryMappings_02"));
        return suite;
    }

    private int size(Iterable<DatabaseMapping> mappings) {
        int count = 0;
        for (DatabaseMapping mapping : mappings) {
            ++count;
        }
        return count;
    }

    public void tearDown() {
        super.tearDown();
        this.clearCache();
    }

    public void test_getConstructorQueryMappings_01() {
        String jpqlQuery = "SELECT e FROM Employee e";
        JPAQuery query = new JPAQuery(jpqlQuery);
        query.setSession((AbstractSession)this.getDatabaseSession());
        JPQLQueryHelper helper = new JPQLQueryHelper();
        ConstructorQueryMappings constructorQuery = helper.getConstructorQueryMappings(query.getSession(), (DatabaseQuery)query);
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"ConstructorQueryMappings should not be null", (Object)constructorQuery);
        JUnitJPQLQueryHelperTestSuite.assertSame((String)"The query was not cached correctly", (Object)query, (Object)constructorQuery.getQuery());
        JUnitJPQLQueryHelperTestSuite.assertFalse((String)"The query is not a constructor query", (boolean)constructorQuery.isConstructorQuery());
        JUnitJPQLQueryHelperTestSuite.assertNull((String)"The class name should be null", (Object)constructorQuery.getClassName());
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"The list of mappings cannot be null", (Object)constructorQuery.mappings());
        JUnitJPQLQueryHelperTestSuite.assertFalse((String)"The list of mappings should be empty", (boolean)constructorQuery.mappings().iterator().hasNext());
    }

    public void test_getConstructorQueryMappings_02() {
        String jpqlQuery = "SELECT NEW org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLQueryHelperTestSuite.MyConstructorClass(   e.lastName, e.id, e.address, e.payScale) FROM Employee e";
        JPAQuery query = new JPAQuery(jpqlQuery);
        query.setSession((AbstractSession)this.getDatabaseSession());
        JPQLQueryHelper helper = new JPQLQueryHelper();
        ConstructorQueryMappings constructorQuery = helper.getConstructorQueryMappings(query.getSession(), (DatabaseQuery)query);
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"ConstructorQueryMappings should not be null", (Object)constructorQuery);
        JUnitJPQLQueryHelperTestSuite.assertSame((String)"The query was not cached correctly", (Object)query, (Object)constructorQuery.getQuery());
        JUnitJPQLQueryHelperTestSuite.assertTrue((String)"The query is a constructor query", (boolean)constructorQuery.isConstructorQuery());
        String expectedClassName = MyConstructorClass.class.getName().replace('$', '.');
        JUnitJPQLQueryHelperTestSuite.assertEquals((String)"The class name should be null", (String)expectedClassName, (String)constructorQuery.getClassName());
        Iterable mappings = constructorQuery.mappings();
        JUnitJPQLQueryHelperTestSuite.assertNotNull((String)"The list of mappings cannot be null", (Object)mappings);
        JUnitJPQLQueryHelperTestSuite.assertTrue((String)"The list of mappings should be empty", (boolean)mappings.iterator().hasNext());
        JUnitJPQLQueryHelperTestSuite.assertEquals((String)"The count of mappings should be 4", (int)4, (int)this.size(mappings));
        int index = 0;
        for (DatabaseMapping mapping : mappings) {
            switch (index++) {
                case 0: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"lastName", (String)mapping.getAttributeName());
                    break;
                }
                case 1: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"id", (String)mapping.getAttributeName());
                    break;
                }
                case 2: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"address", (String)mapping.getAttributeName());
                    break;
                }
                case 3: {
                    JUnitJPQLQueryHelperTestSuite.assertEquals((String)"payScale", (String)mapping.getAttributeName());
                }
            }
        }
    }

    private static final class MyConstructorClass {
        private MyConstructorClass(String name, Integer id, Address address, Employee.SalaryRate payScale) {
        }
    }
}

