/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Time;
import java.util.Date;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimeFromDateTest
extends AutoVerifyTestCase {
    Date testDate;
    Time nonOptimizedTime;
    Time optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimeFromDateTest test = new TimeFromDateTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimeFromDateTest() {
        this.setDescription("Test of Helper.timeFromDate(java.util.Date dateObject)");
    }

    public void setup() {
        this.testDate = Helper.utilDateFromLong((Long)new Long(System.currentTimeMillis()));
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)false);
        this.nonOptimizedTime = Helper.timeFromDate((Date)this.testDate);
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timeFromDate((Date)this.testDate);
    }

    public void verify() {
        String testTime = new Time(this.testDate.getTime()).toString();
        if (!testTime.equals(this.nonOptimizedTime.toString())) {
            throw new TestErrorException("Failed to convert java.util.Date to java.sql.Time when shouldOptimizedDates is off");
        }
        if (!testTime.equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert java.util.Date to java.sql.Time when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

