/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.sql.Connection;
import java.sql.Statement;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class PrimaryKeyQueryInUOWTest
extends CacheExpiryTest {
    String originalName;
    String newName;

    public PrimaryKeyQueryInUOWTest() {
        this.setDescription("Test Cache Expiry a read Object Query.");
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(10000L));
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery rq = new ReadObjectQuery(Employee.class);
        rq.conformResultsInUnitOfWork();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        rq.setSelectionCriteria(exp);
        Employee employee = (Employee)uow.executeQuery((DatabaseQuery)rq);
        uow.commit();
        try {
            Connection con = ((AbstractSession)this.getSession()).getAccessor().getConnection();
            Statement sqlStmt = con.createStatement();
            String str = "UPDATE EMPLOYEE SET L_NAME = 'Ray', VERSION = 2 WHERE ((EMP_ID = " + employee.getId() + ") AND (VERSION = 1))";
            sqlStmt.executeUpdate(str);
            sqlStmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Thread.sleep(7000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        rq = new ReadObjectQuery(Employee.class);
        rq.conformResultsInUnitOfWork();
        rq.setSelectionObject((Object)employee);
        Employee employee2 = (Employee)uow2.executeQuery((DatabaseQuery)rq);
        this.originalName = employee2.getLastName();
        uow2.commit();
        try {
            Thread.sleep(8000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        UnitOfWork uow3 = this.getSession().acquireUnitOfWork();
        rq = new ReadObjectQuery(Employee.class);
        rq.conformResultsInUnitOfWork();
        rq.setSelectionObject((Object)employee);
        employee2 = (Employee)uow3.executeQuery((DatabaseQuery)rq);
        this.newName = employee2.getLastName();
        uow3.commit();
    }

    public void verify() {
        if (!this.originalName.equals("Smith")) {
            throw new TestErrorException("The original name before expiry should be Smith, but " + this.originalName + " was returned");
        }
        if (!this.newName.equals("Ray")) {
            throw new TestErrorException("The new name after expiry should be Ray, but " + this.newName + " was returned");
        }
    }
}

