/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import java.util.Properties;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;

public class DatabaseLoginWithNoEncryptorTest
extends AutoVerifyTestCase {
    boolean exceptionOccurred;
    DatabaseSession mySession;
    Session originalSession = null;

    public DatabaseLoginWithNoEncryptorTest() {
        this.setDescription("Test the login without making a set password call, i.e. no Securable object initialized");
    }

    public void reset() {
        if (this.mySession != null && this.mySession.isConnected()) {
            this.mySession.logout();
        }
        SessionManager.getManager().getSessions().remove(this.mySession);
        this.mySession = null;
    }

    protected void setup() throws Throwable {
        this.exceptionOccurred = false;
        this.originalSession = this.getSession();
        DatabaseLogin login = new DatabaseLogin();
        login.setPlatform((Platform)this.originalSession.getLogin().getPlatform());
        login.setConnector(this.originalSession.getLogin().getConnector());
        Properties properties = new Properties();
        if (this.originalSession.getLogin().getUserName() != null) {
            properties.setProperty("user", this.originalSession.getLogin().getUserName());
        }
        if (this.originalSession.getLogin().getPassword() != null) {
            properties.setProperty("password", this.originalSession.getLogin().getPassword());
        }
        login.setProperties(properties);
        this.mySession = new Project(login).createDatabaseSession();
        this.mySession.dontLogMessages();
    }

    public void test() {
        try {
            this.mySession.login();
        }
        catch (Exception e) {
            this.exceptionOccurred = true;
        }
    }

    protected void verify() {
        if (this.exceptionOccurred) {
            throw new TestErrorException("Exception was caught on login");
        }
        if (!this.mySession.isConnected()) {
            throw new TestWarningException("Session was not connected, but no exception was thrown");
        }
    }
}

