/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.typedefs;

import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;
import org.eclipse.persistence.tools.workbench.ant.typedefs.IgnoreError;
import org.eclipse.persistence.tools.workbench.ant.typedefs.MappingsType;

public class IgnoreErrorSet
extends MappingsType
implements Cloneable {
    private Vector ignoreErrors;
    private static final String CR = System.getProperty("line.separator");

    public IgnoreErrorSet() {
    }

    protected IgnoreErrorSet(IgnoreErrorSet ignoreErrorSet) {
        this.ignoreErrors = ignoreErrorSet.ignoreErrors;
        this.setProject(ignoreErrorSet.getProject());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.ignoreErrors = new Vector();
    }

    public void addIgnoreError(IgnoreError ignoreError) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.ignoreErrors.add(ignoreError);
    }

    public boolean contains(IgnoreError ignoreError) {
        String code = ignoreError.getCode();
        for (IgnoreError error : this.ignoreErrors) {
            if (!code.equals(error.getCode())) continue;
            return true;
        }
        return false;
    }

    public Vector getIgnoreErrors(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIgnoreErrors(project);
        }
        Vector ignoreErrors = new Vector(this.ignoreErrors.size());
        ignoreErrors.addAll(this.ignoreErrors);
        return ignoreErrors;
    }

    public Vector getIgnoreErrorCodes(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getIgnoreErrorCodes(project);
        }
        Vector<String> codes = new Vector<String>();
        for (IgnoreError ignoreError : this.ignoreErrors) {
            codes.add(ignoreError.getCode());
        }
        return codes;
    }

    protected IgnoreErrorSet getRef(Project project) {
        Object anObject;
        if (!this.isChecked()) {
            Stack<IgnoreErrorSet> stack = new Stack<IgnoreErrorSet>();
            stack.push(this);
            this.dieOnCircularReference(stack, project);
        }
        if ((anObject = this.getRefid().getReferencedObject(project)) instanceof IgnoreErrorSet) {
            return (IgnoreErrorSet)anObject;
        }
        throw new BuildException(this.stringRepository.getString("notNotAIgnoreErrorSet", this.getRefid().getRefId()));
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.ignoreErrors.size() != 0) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(" [").append(CR);
        Iterator i = this.ignoreErrors.iterator();
        while (i.hasNext()) {
            IgnoreError ignoreError = (IgnoreError)((Object)i.next());
            sb.append("\t\t");
            ignoreError.toString(sb);
            if (!i.hasNext()) continue;
            sb.append(",").append(CR);
        }
        sb.append(" ] ");
    }
}

