/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ComboBoxEditorAdapter
implements ComboBoxEditor {
    private final BidiStringConverter converter;
    private final ComboBoxEditor delegate;
    private final Object nullValue;

    public ComboBoxEditorAdapter(ComboBoxEditor delegate, BidiStringConverter converter) {
        this(delegate, converter, null);
    }

    public ComboBoxEditorAdapter(ComboBoxEditor delegate, BidiStringConverter converter, Object nullValue) {
        this.delegate = delegate;
        this.converter = converter;
        this.nullValue = nullValue;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.delegate.addActionListener(listener);
    }

    @Override
    public Component getEditorComponent() {
        return this.delegate.getEditorComponent();
    }

    @Override
    public Object getItem() {
        String value = (String)this.delegate.getItem();
        if (value != null) {
            value = value.trim();
        }
        if (StringTools.stringIsEmpty((String)value)) {
            value = null;
        } else if (value == this.nullValue()) {
            value = null;
        }
        Object objectValue = this.converter.convertToObject(value);
        if (objectValue == null) {
            objectValue = "";
        }
        return objectValue;
    }

    protected Object nullValue() {
        return this.nullValue;
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.delegate.removeActionListener(listener);
    }

    @Override
    public void selectAll() {
        this.delegate.selectAll();
    }

    @Override
    public void setItem(Object value) {
        if (value == this.nullValue()) {
            value = null;
        }
        value = this.converter.convertToString(value);
        this.delegate.setItem(value);
    }
}

