/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

public class QueryImpl {
    private static final int UNDEFINED = -1;
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map<String, Object> parameterValues = new HashMap<String, Object>();
    protected Map<String, Parameter<?>> parameters;
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected LockModeType lockMode = null;
    protected boolean isShared;

    protected QueryImpl(EntityManagerImpl entityManager) {
        this.entityManager = entityManager;
        this.isShared = true;
    }

    public QueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        this(entityManager);
        this.databaseQuery = query;
    }

    public void close() {
    }

    protected void setAsDataModifyQuery() {
        DataModifyQuery query = new DataModifyQuery();
        query.setIsUserDefined(this.databaseQuery.isUserDefined());
        query.copyFromQuery(this.databaseQuery);
        query.setDatasourceCall((Call)this.databaseQuery.getDatasourceCall().clone());
        this.databaseQuery = query;
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQueryInternal().isDataReadQuery()) {
            this.setAsDataModifyQuery();
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQueryInternal().isDataModifyQuery()) {
            DataReadQuery query = new DataReadQuery();
            query.setResultType(4);
            query.setIsUserDefined(this.databaseQuery.isUserDefined());
            query.copyFromQuery(this.databaseQuery);
            this.databaseQuery = query;
        }
    }

    protected Object executeReadQuery() {
        List<Object> parameterValues = this.processParameters();
        boolean shouldResetConformResultsInUnitOfWork = false;
        DatabaseQuery query = this.getDatabaseQueryInternal();
        boolean isObjectLevelReadQuery = query.isObjectLevelReadQuery();
        if (!(!this.isFlushModeAUTO() || isObjectLevelReadQuery && ((ObjectLevelReadQuery)query).isReadOnly())) {
            this.performPreQueryFlush();
            if (isObjectLevelReadQuery && ((ObjectLevelReadQuery)query).shouldConformResultsInUnitOfWork()) {
                this.cloneSharedQuery();
                query = this.getDatabaseQueryInternal();
                ((ObjectLevelReadQuery)query).setCacheUsage(-1);
                shouldResetConformResultsInUnitOfWork = true;
            }
        }
        if (this.lockMode != null) {
            this.entityManager.checkForTransaction(true);
            this.cloneSharedQuery();
            query = this.getDatabaseQueryInternal();
            if (((ObjectLevelReadQuery)query).setLockModeType(this.lockMode.name(), (AbstractSession)this.getActiveSession())) {
                throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
            }
        }
        Session session = this.getActiveSession();
        try {
            if (query.isUserDefined() && this.entityManager.checkForTransaction(false) != null && session.isUnitOfWork() && !((UnitOfWorkImpl)session).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)session).beginEarlyTransaction();
            }
            Object object = session.executeQuery(query, parameterValues);
            return object;
        }
        catch (DatabaseException e) {
            throw this.getDetailedException(e);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            this.lockMode = null;
            if (shouldResetConformResultsInUnitOfWork) {
                ((ObjectLevelReadQuery)query).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQueryInternal() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            List<Object> parameterValues = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer changedRows = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, parameterValues);
            return changedRows;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public DatabaseQuery getDatabaseQuery() {
        this.cloneSharedQuery();
        return this.getDatabaseQueryInternal();
    }

    public DatabaseQuery getDatabaseQueryInternal() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.entityManager.getAbstractSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.checkPrepare(this.entityManager.getAbstractSession(), new DatabaseRecord());
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    protected RuntimeException getDetailedException(DatabaseException e) {
        if (this.lockMode != null && this.lockMode.name().contains("PESSIMISTIC_")) {
            if (this.getActiveSession().getPlatform().isLockTimeoutException(e)) {
                return new LockTimeoutException(e);
            }
            return new PessimisticLockException(e);
        }
        this.setRollbackOnly();
        return e;
    }

    public JpaEntityManager getEntityManager() {
        return this.entityManager;
    }

    protected Map<String, Parameter<?>> getInternalParameters() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
            DatabaseQuery query = this.getDatabaseQueryInternal();
            int count = 0;
            if (query.getArguments() != null && !query.getArguments().isEmpty()) {
                for (String argName : query.getArguments()) {
                    ParameterExpressionImpl param = new ParameterExpressionImpl(null, query.getArgumentTypes().get(count), argName);
                    this.parameters.put(argName, (Parameter<?>)((Object)param));
                    ++count;
                }
            }
        }
        return this.parameters;
    }

    public LockModeType getLockMode() {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            return this.lockMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public List getResultList() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            DatabaseQuery query = this.getDatabaseQueryInternal();
            if (query.isReadAllQuery()) {
                Class containerClass = ((ReadAllQuery)query).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface(containerClass, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass(containerClass, ClassConstants.List_Class);
                }
            } else {
                if (query.isReadObjectQuery()) {
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    Object result = this.executeReadQuery();
                    if (result != null) {
                        resultList.add(result);
                    }
                    return resultList;
                }
                if (!query.isReadQuery()) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_list"));
                }
            }
            return (List)this.executeReadQuery();
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public Object getSingleResult() {
        boolean rollbackOnException = true;
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_single_result"));
            }
            Object result = this.executeReadQuery();
            if (result instanceof List) {
                List results = (List)result;
                if (results.isEmpty()) {
                    rollbackOnException = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                } else if (results.size() > 1) {
                    rollbackOnException = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                return results.get(0);
            }
            if (result == null) {
                rollbackOnException = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
            }
            return result;
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            if (rollbackOnException) {
                this.setRollbackOnly();
            }
            throw exception;
        }
    }

    protected List<Object> processParameters() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        List<String> arguments = query.getArguments();
        if (arguments.isEmpty()) {
            arguments = new ArrayList<String>(this.parameterValues.keySet());
            query.setArguments(arguments);
        }
        int size = arguments.size();
        ArrayList<Object> parameterValues = new ArrayList<Object>(size);
        int index = 0;
        while (index < size) {
            String name = arguments.get(index);
            Object parameter = this.parameterValues.get(name);
            if (parameter != null || this.parameterValues.containsKey(name)) {
                parameterValues.add(parameter);
            } else if (query.hasNullableArguments() && query.getNullableArguments().contains(new DatabaseField(name))) {
                parameterValues.add(null);
            } else {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("missing_parameter_value", new Object[]{name}));
            }
            ++index;
        }
        return parameterValues;
    }

    public void setDatabaseQuery(DatabaseQuery query) {
        this.databaseQuery = query;
    }

    public QueryImpl setFirstResult(int startPosition) {
        try {
            this.entityManager.verifyOpen();
            this.setFirstResultInternal(startPosition);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getFirstResult() {
        if (this.firstResultIndex == -1) {
            return 0;
        }
        return this.firstResultIndex;
    }

    public QueryImpl setFlushMode(FlushModeType flushMode) {
        try {
            this.entityManager.verifyOpen();
            if (flushMode == null) {
                this.getDatabaseQueryInternal().setFlushOnExecute(null);
            } else {
                this.cloneSharedQuery();
                this.getDatabaseQueryInternal().setFlushOnExecute(flushMode == FlushModeType.AUTO);
            }
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setFirstResultInternal(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        this.firstResultIndex = startPosition;
    }

    protected static void applyArguments(StoredProcedureCall call, DatabaseQuery query) {
        if (call instanceof PLSQLStoredProcedureCall) {
            PLSQLStoredProcedureCall plsqlCall = (PLSQLStoredProcedureCall)call;
            int index = 0;
            while (index < plsqlCall.getArguments().size()) {
                PLSQLargument argument = plsqlCall.getArguments().get(index);
                int type = argument.direction;
                if (type == StoredProcedureCall.IN || type == StoredProcedureCall.INOUT) {
                    if (call.hasOptionalArguments()) {
                        query.addArgument(argument.name, Object.class, call.getOptionalArguments().contains(new DatabaseField(argument.name)));
                    } else {
                        query.addArgument(argument.name);
                    }
                }
                ++index;
            }
        } else {
            int index = 0;
            while (index < call.getParameters().size()) {
                int type = call.getParameterTypes().get(index);
                if (type == StoredProcedureCall.IN || type == StoredProcedureCall.INOUT) {
                    Object value = call.getParameters().get(index);
                    DatabaseField parameter = null;
                    parameter = value instanceof Object[] ? (DatabaseField)((Object[])value)[0] : (DatabaseField)call.getParameters().get(index);
                    if (call.hasOptionalArguments()) {
                        query.addArgument(parameter.getName(), Object.class, call.getOptionalArguments().contains(parameter));
                    } else {
                        query.addArgument(parameter.getName());
                    }
                }
                ++index;
            }
        }
    }

    protected static DatabaseQuery applyHints(Map<String, Object> hints, DatabaseQuery query, ClassLoader classLoader, AbstractSession session) {
        return QueryHintsHandler.apply(hints, query, classLoader, session);
    }

    public boolean isBound(Parameter<?> param) {
        if (param == null) {
            return false;
        }
        return this.parameterValues.containsKey(param.getName());
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQueryInternal().getFlushOnExecute() != null) {
            return this.getDatabaseQueryInternal().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    protected void setHintInternal(String hintName, Object value) {
        this.cloneSharedQuery();
        ClassLoader loader = this.getEntityManager().getAbstractSession().getLoader();
        DatabaseQuery hintQuery = QueryHintsHandler.apply(hintName, value, this.getDatabaseQueryInternal(), loader, (AbstractSession)this.getActiveSession());
        if (hintQuery != null) {
            this.setDatabaseQuery(hintQuery);
        }
    }

    public QueryImpl setLockMode(LockModeType lockMode) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQueryInternal().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            this.lockMode = lockMode;
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void cloneSharedQuery() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (this.isShared) {
            query = (DatabaseQuery)this.databaseQuery.clone();
            this.setDatabaseQuery(query);
            this.isShared = false;
        }
    }

    protected Object convertTemporalType(Object value, TemporalType type) {
        ConversionManager conversionManager = ((AbstractSession)this.getEntityManager().getActiveSession()).getDatasourcePlatform().getConversionManager();
        if (type == TemporalType.TIME) {
            return conversionManager.convertObject(value, ClassConstants.TIME);
        }
        if (type == TemporalType.TIMESTAMP) {
            return conversionManager.convertObject(value, ClassConstants.TIMESTAMP);
        }
        if (type == TemporalType.DATE) {
            return conversionManager.convertObject(value, ClassConstants.SQLDATE);
        }
        return value;
    }

    public QueryImpl setMaxResults(int maxResult) {
        try {
            this.entityManager.verifyOpen();
            this.setMaxResultsInternal(maxResult);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public int getMaxResults() {
        if (this.maxResults == -1) {
            return Integer.MAX_VALUE;
        }
        return this.maxResults;
    }

    public void setMaxResultsInternal(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        this.maxResults = maxResult == Integer.MAX_VALUE ? -1 : maxResult;
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQueryInternal();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQueryInternal();
                int maxRows = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(maxRows);
            }
            if (this.firstResultIndex > -1) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQueryInternal();
                readQuery.setFirstResult(this.firstResultIndex);
            }
        }
    }

    protected void setParameterInternal(int position, Object value) {
        this.setParameterInternal(String.valueOf(position), value, true);
    }

    protected void setParameterInternal(String name, Object value, boolean isIndex) {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (query.getQueryMechanism().isJPQLCallQueryMechanism()) {
            int index = query.getArguments().indexOf(name);
            if (index == -1) {
                if (isIndex) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{name, query.getEJBQLString()}));
                }
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{name, query.getEJBQLString()}));
            }
            Class type = query.getArgumentTypes().get(index);
            if (!this.isValidActualParameter(value, type)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{name, value.getClass(), query.getArgumentTypes().get(index), query.getEJBQLString()}));
            }
        } else if (isIndex && name.equals("0")) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{name, query.getSQLString()}));
        }
        this.parameterValues.put(name, value);
    }

    protected boolean isValidActualParameter(Object value, Class parameterType) {
        if (value == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom(parameterType, value.getClass());
    }

    protected Session getActiveSession() {
        DatabaseQuery query = this.getDatabaseQueryInternal();
        if (query.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)query).isReadOnly()) {
            return this.entityManager.getReadOnlySession();
        }
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }

    protected void throwNoResultException(String message) {
        throw new NoResultException(message);
    }

    protected void throwNonUniqueResultException(String message) {
        throw new NonUniqueResultException(message);
    }

    public FlushModeType getFlushMode() {
        try {
            this.entityManager.verifyOpen();
            if (this.getDatabaseQueryInternal().getFlushOnExecute().booleanValue()) {
                return FlushModeType.AUTO;
            }
            return FlushModeType.COMMIT;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Map<String, Object> getHints() {
        return (Map)this.getDatabaseQueryInternal().getProperty("eclipselink.query.hints");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_INDEX", new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(String name) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(name);
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Parameter<?> getParameter(int position) {
        try {
            this.entityManager.verifyOpen();
            Parameter<?> param = this.getInternalParameters().get(String.valueOf(position));
            if (param == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_INDEX", new Object[]{position, this.databaseQuery}));
            }
            return param;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PARAMETER_NILL_NOT_FOUND"));
        }
        return (T)this.getParameterValue(param.getName());
    }

    public Object getParameterValue(String name) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getInternalParameters().containsKey(name)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NO_PARAMETER_WITH_NAME", new Object[]{name, this.databaseQuery}));
            }
            if (!this.parameterValues.containsKey(name)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("NO_VALUE_BOUND", new Object[]{name}));
            }
            return this.parameterValues.get(name);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getParameterValue(int position) {
        String param = String.valueOf(position);
        if (!this.parameterValues.containsKey(param)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("position_param_not_found", new Object[]{position}));
        }
        return this.parameterValues.get(param);
    }

    public Set<Parameter<?>> getParameters() {
        return new HashSet(this.getInternalParameters().values());
    }

    public Set<String> getSupportedHints() {
        return QueryHintsHandler.getSupportedHints();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (cls.isAssignableFrom(this.getDatabaseQueryInternal().getClass())) {
            return (T)this.getDatabaseQueryInternal();
        }
        throw new PersistenceException("Could not unwrap query to: " + cls);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + String.valueOf(this.databaseQuery) + ")";
    }
}

