/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.Parameter;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceException;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredProcedureQueryImpl
extends QueryImpl
implements StoredProcedureQuery {
    protected List resultList;
    protected boolean hasMoreResults;
    protected DatabaseCall executeCall;
    protected Statement executeStatement;
    protected int executeResultSetIndex = -1;

    protected StoredProcedureQueryImpl(EntityManagerImpl entityManager) {
        super(entityManager);
    }

    public StoredProcedureQueryImpl(DatabaseQuery query, EntityManagerImpl entityManager) {
        super(query, entityManager);
    }

    public StoredProcedureQueryImpl(String name, EntityManagerImpl entityManager) {
        super(entityManager);
        this.queryName = name;
    }

    protected List buildResultRecords(ResultSet resultSet) {
        try {
            AbstractSession session = (AbstractSession)this.getActiveSession();
            DatabaseAccessor accessor = (DatabaseAccessor)this.executeCall.getQuery().getAccessor();
            this.executeCall.setFields(null);
            this.executeCall.matchFieldOrder(resultSet, accessor, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            Vector<AbstractRecord> result = new Vector<AbstractRecord>();
            while (resultSet.next()) {
                result.add(accessor.fetchRow(this.executeCall.getFields(), this.executeCall.getFieldsArray(), resultSet, metaData, session));
            }
            resultSet.close();
            return result;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)e);
        }
    }

    public static DatabaseQuery buildResultSetMappingNameQuery(List<String> resultSetMappingNames, StoredProcedureCall call) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets() && !call.isMultipleCursorOutputProcedure());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappingNames(resultSetMappingNames);
        return query;
    }

    public static DatabaseQuery buildResultSetMappingNameQuery(List<String> resultSetMappingNames, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, StoredProcedureQueryImpl.buildResultSetMappingNameQuery(resultSetMappingNames, call), classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildResultSetMappingQuery(List<SQLResultSetMapping> resultSetMappings, StoredProcedureCall call) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        call.setReturnMultipleResultSetCollections(call.hasMultipleResultSets() && !call.isMultipleCursorOutputProcedure());
        query.setCall(call);
        query.setIsUserDefined(true);
        query.setSQLResultSetMappings(resultSetMappings);
        return query;
    }

    public static DatabaseQuery buildResultSetMappingQuery(List<SQLResultSetMapping> resultSetMappings, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, StoredProcedureQueryImpl.buildResultSetMappingQuery(resultSetMappings, call), classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class resultClass, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DatabaseQuery query = new ReadAllQuery(resultClass);
        query.setCall(call);
        query.setIsUserDefined(true);
        query = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, query);
        return query;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        DataReadQuery query = new DataReadQuery();
        query.setResultType(4);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String sqlResultSetMappingName, StoredProcedureCall call, Map<String, Object> hints, ClassLoader classLoader, AbstractSession session) {
        ResultSetMappingQuery query = new ResultSetMappingQuery();
        query.setSQLResultSetMappingName(sqlResultSetMappingName);
        query.setCall(call);
        query.setIsUserDefined(true);
        DatabaseQuery hintQuery = StoredProcedureQueryImpl.applyHints(hints, query, classLoader, session);
        StoredProcedureQueryImpl.applyArguments(call, hintQuery);
        return hintQuery;
    }

    @Override
    public void close() {
        DatabaseQuery query = this.executeCall.getQuery();
        AbstractSession session = query.getSession();
        try {
            if (this.executeStatement != null) {
                DatabaseAccessor accessor = (DatabaseAccessor)query.getAccessor();
                accessor.releaseStatement(this.executeStatement, query.getSQLString(), this.executeCall, session);
            }
        }
        catch (SQLException exception) {
            session.log(6, "connection", "exception_caught_closing_statement", exception);
        }
    }

    @Override
    public boolean execute() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (!this.getDatabaseQueryInternal().isResultSetMappingQuery()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute"));
            }
            this.getResultSetMappingQuery().setIsExecuteCall(true);
            this.executeCall = (DatabaseCall)this.executeReadQuery();
            this.executeStatement = this.executeCall.getStatement();
            this.entityManager.addOpenQuery(this);
            this.hasMoreResults = this.executeCall.getExecuteReturnValue();
            return this.hasMoreResults;
        }
        catch (LockTimeoutException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public void finalize() {
        this.close();
    }

    protected StoredProcedureCall getCall() {
        return (StoredProcedureCall)this.getDatabaseQueryInternal().getCall();
    }

    @Override
    public Object getOutputParameterValue(int position) {
        this.entityManager.verifyOpen();
        if (this.isValidCallableStatement()) {
            try {
                Object obj = ((CallableStatement)this.executeStatement).getObject(position);
                if (obj instanceof ResultSet) {
                    return this.getResultSetMappingQuery().buildObjectsFromRecords(this.buildResultRecords((ResultSet)obj), ++this.executeResultSetIndex);
                }
                return obj;
            }
            catch (SQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21_invalid_parameter_position", new Object[]{position, exception.getMessage()}), exception);
            }
        }
        return null;
    }

    @Override
    public Object getOutputParameterValue(String parameterName) {
        this.entityManager.verifyOpen();
        if (this.isValidCallableStatement()) {
            try {
                Integer position = this.getCall().getCursorOrdinalPosition(parameterName);
                if (position == null) {
                    return ((CallableStatement)this.executeStatement).getObject(parameterName);
                }
                return this.getOutputParameterValue(position);
            }
            catch (SQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa21_invalid_parameter_name", new Object[]{parameterName, exception.getMessage()}), exception);
            }
        }
        return null;
    }

    @Override
    public List getResultList() {
        try {
            if (this.executeStatement == null) {
                if (this.resultList == null) {
                    if (this.getDatabaseQuery().isResultSetMappingQuery()) {
                        this.getResultSetMappingQuery().setIsExecuteCall(false);
                    }
                    this.resultList = super.getResultList();
                }
                if (this.resultList.get(0) instanceof List) {
                    return (List)this.resultList.remove(0);
                }
                return this.resultList;
            }
            if (this.hasMoreResults()) {
                List result = this.buildResultRecords(this.executeStatement.getResultSet());
                this.moveResultPointer();
                return this.getResultSetMappingQuery().buildObjectsFromRecords(result, ++this.executeResultSetIndex);
            }
            return null;
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (PersistenceException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw new PersistenceException((Throwable)e);
        }
    }

    protected ResultSetMappingQuery getResultSetMappingQuery() {
        if (this.executeCall != null) {
            return (ResultSetMappingQuery)this.executeCall.getQuery();
        }
        return (ResultSetMappingQuery)this.getDatabaseQuery();
    }

    @Override
    public int getUpdateCount() {
        this.entityManager.verifyOpen();
        if (this.executeStatement != null) {
            try {
                int updateCount = this.executeStatement.getUpdateCount();
                if (updateCount > -1) {
                    this.moveResultPointer();
                }
                return updateCount;
            }
            catch (SQLException e) {
                throw this.getDetailedException(DatabaseException.sqlException(e, this.executeCall, this.executeCall.getQuery().getAccessor(), this.executeCall.getQuery().getSession(), false));
            }
        }
        return -1;
    }

    @Override
    public boolean hasMoreResults() {
        this.entityManager.verifyOpen();
        if (this.executeStatement != null) {
            return this.hasMoreResults;
        }
        return this.resultList != null && !this.resultList.isEmpty();
    }

    protected boolean isValidCallableStatement() {
        if (this.executeStatement == null) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("jpa21_invalid_call_on_un_executed_query"));
        }
        if (!(this.executeStatement instanceof CallableStatement)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("jpa21_invalid_call_with_no_output_parameters"));
        }
        return true;
    }

    private void moveResultPointer() {
        try {
            this.hasMoreResults = this.executeStatement.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.hasMoreResults = false;
        }
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        StoredProcedureCall call = (StoredProcedureCall)this.getDatabaseQuery().getCall();
        if (mode.equals((Object)ParameterMode.IN)) {
            call.addUnamedArgument(String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.OUT)) {
            call.addUnamedOutputArgument(String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.INOUT)) {
            call.addUnamedInOutputArgument(String.valueOf(position), String.valueOf(position), type);
        } else if (mode.equals((Object)ParameterMode.REF_CURSOR)) {
            boolean multipleCursors = call.getParameterTypes().contains(StoredProcedureCall.OUT_CURSOR);
            call.useUnnamedCursorOutputAsResultSet();
            if (multipleCursors) {
                call.setIsCursorOutputProcedure(false);
            }
        }
        return this;
    }

    @Override
    public StoredProcedureQuery registerStoredProcedureParameter(String parameterName, Class type, ParameterMode mode) {
        StoredProcedureCall call = (StoredProcedureCall)this.getDatabaseQuery().getCall();
        if (mode.equals((Object)ParameterMode.IN)) {
            call.addNamedArgument(parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.OUT)) {
            call.addNamedOutputArgument(parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.INOUT)) {
            call.addNamedInOutputArgument(parameterName, parameterName, parameterName, type);
        } else if (mode.equals((Object)ParameterMode.REF_CURSOR)) {
            boolean multipleCursors = call.getParameterTypes().contains(StoredProcedureCall.OUT_CURSOR);
            call.useNamedCursorOutputAsResultSet(parameterName);
            if (multipleCursors) {
                call.setIsCursorOutputProcedure(false);
            }
        }
        return this;
    }

    @Override
    protected void setAsSQLModifyQuery() {
        this.setAsDataModifyQuery();
    }

    @Override
    public StoredProcedureQueryImpl setFirstResult(int startPosition) {
        return (StoredProcedureQueryImpl)super.setFirstResult(startPosition);
    }

    @Override
    public StoredProcedureQueryImpl setFlushMode(FlushModeType flushMode) {
        return (StoredProcedureQueryImpl)super.setFlushMode(flushMode);
    }

    @Override
    public StoredProcedureQuery setHint(String hintName, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(hintName, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public StoredProcedureQueryImpl setLockMode(LockModeType lockMode) {
        return (StoredProcedureQueryImpl)super.setLockMode(lockMode);
    }

    @Override
    public StoredProcedureQueryImpl setMaxResults(int maxResult) {
        return (StoredProcedureQueryImpl)super.setMaxResults(maxResult);
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(position, this.convertTemporalType(value, temporalType));
    }

    @Override
    public StoredProcedureQuery setParameter(int position, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(position, value);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    @Override
    public StoredProcedureQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value, temporalType);
    }

    @Override
    public <T> StoredProcedureQuery setParameter(Parameter<T> param, T value) {
        if (param == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("NULL_PARAMETER_PASSED_TO_SET_PARAMETER"));
        }
        return this.setParameter(param.getName(), value);
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Calendar value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Date value, TemporalType temporalType) {
        this.entityManager.verifyOpen();
        return this.setParameter(name, this.convertTemporalType(value, temporalType));
    }

    @Override
    public StoredProcedureQuery setParameter(String name, Object value) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(name, value, false);
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }
}

