/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass
implements Converter {
    String attributeConverterClassName;
    AttributeConverter attributeConverter;

    public ConverterClass(MetadataClass attributeConverterClass) {
        this.attributeConverterClassName = attributeConverterClass.getName();
    }

    public ConverterClass(String attributeConverterClassName) {
        this.attributeConverterClassName = attributeConverterClassName;
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.attributeConverter.convertToEntityAttribute(dataValue);
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.attributeConverter.convertToDatabaseColumn(objectValue);
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        block7: {
            Class attributeConverterClass = null;
            try {
                ClassLoader loader = session.getClass().getClassLoader();
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        attributeConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, loader));
                        this.attributeConverter = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeConverterClass));
                        break block7;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception.getException());
                    }
                }
                attributeConverterClass = PrivilegedAccessHelper.getClassForName(this.attributeConverterClassName, true, loader);
                this.attributeConverter = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass(attributeConverterClass);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
            }
            catch (IllegalAccessException exception) {
                throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
            }
            catch (InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
            }
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

