/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;

public class NamedPLSQLStoredFunctionQueryMetadata
extends NamedPLSQLStoredProcedureQueryMetadata {
    private PLSQLParameterMetadata returnParameter;

    public NamedPLSQLStoredFunctionQueryMetadata() {
        super("<named-plsql-stored-function-query>");
    }

    public NamedPLSQLStoredFunctionQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        this.returnParameter = new PLSQLParameterMetadata((MetadataAnnotation)namedStoredProcedureQuery.getAttribute("returnParameter"), accessor);
        this.setProcedureName((String)namedStoredProcedureQuery.getAttribute("functionName"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedPLSQLStoredFunctionQueryMetadata) {
            NamedPLSQLStoredFunctionQueryMetadata query = (NamedPLSQLStoredFunctionQueryMetadata)objectToCompare;
            return this.valuesMatch(this.returnParameter, query.getReturnParameter());
        }
        return false;
    }

    public PLSQLParameterMetadata getReturnParameter() {
        return this.returnParameter;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.returnParameter, accessibleObject);
    }

    @Override
    public void process(AbstractSession session) {
        PLSQLStoredFunctionCall call = new PLSQLStoredFunctionCall();
        for (PLSQLParameterMetadata parameter : this.getParameters()) {
            parameter.process(call, false);
        }
        if (this.getReturnParameter() != null) {
            this.getReturnParameter().process(call, true);
        }
        call.setProcedureName(this.getProcedureName());
        Map<String, Object> hints = this.processQueryHints(session);
        JPAQuery query = new JPAQuery(this.getName(), call, hints);
        if (!this.getResultClass().isVoid()) {
            query.setResultClassName(this.getJavaClassName(this.getResultClass()));
        } else if (this.hasResultSetMapping(session)) {
            query.addResultSetMapping(this.getResultSetMapping());
        }
        session.addJPAQuery(query);
    }

    public void setReturnParameter(PLSQLParameterMetadata returnParameter) {
        this.returnParameter = returnParameter;
    }
}

