/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class NamedStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private Boolean m_multipleResultSets;
    private Boolean m_returnsResultSet;
    private Boolean m_callByIndex;
    private List<MetadataClass> m_resultClasses = new ArrayList<MetadataClass>();
    private List<String> m_resultClassNames = new ArrayList<String>();
    private List<String> m_resultSetMappings = new ArrayList<String>();
    private List<StoredProcedureParameterMetadata> m_parameters = new ArrayList<StoredProcedureParameterMetadata>();
    private String m_procedureName;

    public NamedStoredProcedureQueryMetadata() {
        super("<named-stored-procedure-query>");
    }

    public NamedStoredProcedureQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        Object[] objectArray = (Object[])namedStoredProcedureQuery.getAttributeArray("parameters");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object storedProcedureParameter = objectArray[n2];
            this.m_parameters.add(new StoredProcedureParameterMetadata((MetadataAnnotation)storedProcedureParameter, accessor));
            ++n2;
        }
        objectArray = (Object[])namedStoredProcedureQuery.getAttributeArray("resultClasses");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object resultClass = objectArray[n2];
            this.m_resultClasses.add(this.getMetadataClass((String)resultClass));
            ++n2;
        }
        objectArray = (Object[])namedStoredProcedureQuery.getAttributeArray("resultSetMappings");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object resultSetMapping = objectArray[n2];
            this.m_resultSetMappings.add((String)resultSetMapping);
            ++n2;
        }
        this.m_procedureName = (String)namedStoredProcedureQuery.getAttribute("procedureName");
        this.m_returnsResultSet = (Boolean)namedStoredProcedureQuery.getAttribute("returnsResultSet");
        this.m_multipleResultSets = (Boolean)namedStoredProcedureQuery.getAttribute("multipleResultSets");
        this.m_callByIndex = (Boolean)namedStoredProcedureQuery.getAttributeBooleanDefaultFalse("callByIndex");
    }

    public NamedStoredProcedureQueryMetadata(String elementName) {
        super(elementName);
    }

    public boolean callByIndex() {
        return this.m_callByIndex == null ? false : this.m_callByIndex;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedStoredProcedureQueryMetadata) {
            NamedStoredProcedureQueryMetadata query = (NamedStoredProcedureQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_returnsResultSet, query.getReturnsResultSet())) {
                return false;
            }
            if (!this.valuesMatch(this.m_callByIndex, query.getCallByIndex())) {
                return false;
            }
            if (!this.valuesMatch(this.m_multipleResultSets, query.getMultipleResultSets())) {
                return false;
            }
            if (!this.valuesMatch(this.m_parameters, query.getParameters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_resultClassNames, query.getResultClassNames())) {
                return false;
            }
            if (!this.valuesMatch(this.m_resultSetMappings, query.getResultSetMappings())) {
                return false;
            }
            return this.valuesMatch(this.m_procedureName, query.getProcedureName());
        }
        return false;
    }

    public Boolean getCallByIndex() {
        return this.m_callByIndex;
    }

    public Boolean getMultipleResultSets() {
        return this.m_multipleResultSets;
    }

    public List<StoredProcedureParameterMetadata> getParameters() {
        return this.m_parameters;
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<String> getResultClassNames() {
        return this.m_resultClassNames;
    }

    public List<String> getResultSetMappings() {
        return this.m_resultSetMappings;
    }

    public Boolean getReturnsResultSet() {
        return this.m_returnsResultSet;
    }

    public boolean hasMultipleResultSets() {
        return this.m_multipleResultSets == null ? this.m_resultClasses.size() > 1 || this.m_resultSetMappings.size() > 1 : this.m_multipleResultSets;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_parameters, accessibleObject);
        for (String resultClassName : this.m_resultClassNames) {
            this.m_resultClasses.add(this.initXMLClassName(resultClassName));
        }
    }

    @Override
    public void process(AbstractSession session) {
        StoredProcedureCall call = new StoredProcedureCall();
        int index = 1;
        boolean callByIndex = this.callByIndex();
        boolean hasOutParameters = false;
        for (StoredProcedureParameterMetadata parameter : this.m_parameters) {
            parameter.processArgument(call, callByIndex, index);
            ++index;
            if (!parameter.isOutParameter()) continue;
            hasOutParameters = true;
        }
        call.setProcedureName(this.m_procedureName);
        call.setReturnsResultSet(this.returnsResultSet(hasOutParameters));
        call.setHasMultipleResultSets(this.hasMultipleResultSets());
        Map<String, Object> hints = this.processQueryHints(session);
        JPAQuery query = new JPAQuery(this.getName(), call, hints);
        if (!this.m_resultClasses.isEmpty()) {
            for (MetadataClass resultClass : this.m_resultClasses) {
                query.addResultClassNames(this.getJavaClassName(resultClass));
            }
        } else if (!this.m_resultSetMappings.isEmpty()) {
            query.setResultSetMappings(this.m_resultSetMappings);
        } else if (!this.getResultClass().isVoid()) {
            query.setResultClassName(this.getJavaClassName(this.getResultClass()));
        } else if (this.hasResultSetMapping(session)) {
            query.addResultSetMapping(this.getResultSetMapping());
        }
        session.addJPAQuery(query);
    }

    public boolean returnsResultSet(boolean hasOutParameters) {
        return this.m_returnsResultSet == null ? !hasOutParameters : this.m_returnsResultSet;
    }

    public void setCallByIndex(Boolean callByIndex) {
        this.m_callByIndex = callByIndex;
    }

    public void setMultipleResultSets(Boolean multipleResultSets) {
        this.m_multipleResultSets = multipleResultSets;
    }

    public void setParameters(List<StoredProcedureParameterMetadata> parameters) {
        this.m_parameters = parameters;
    }

    public void setProcedureName(String procedureName) {
        this.m_procedureName = procedureName;
    }

    public void setResultClassNames(List<String> resultClassNames) {
        this.m_resultClassNames = resultClassNames;
    }

    public void setResultSetMappings(List<String> resultSetMappings) {
        this.m_resultSetMappings = resultSetMappings;
    }

    public void setReturnsResultSet(Boolean returnsResultSet) {
        this.m_returnsResultSet = returnsResultSet;
    }
}

