/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionValuedPathExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SimpleFromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.model.query.VariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.util.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.util.iterable.SingleElementListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionMemberDeclarationStateObject
extends AbstractStateObject
implements VariableDeclarationStateObject {
    private boolean as;
    private CollectionValuedPathExpressionStateObject collectionValuedPath;
    private boolean derived;
    private IdentificationVariableStateObject identificationVariable;
    public static final String AS_PROPERTY = "as";

    public CollectionMemberDeclarationStateObject(AbstractFromClauseStateObject parent) {
        super(parent);
    }

    public CollectionMemberDeclarationStateObject(AbstractFromClauseStateObject parent, ListIterator<String> paths, boolean as, String identificationVariable) {
        super(parent);
        this.as = as;
        this.getCollectionValuedPath().setPaths(paths);
        this.setIdentificationVariable(identificationVariable);
    }

    public CollectionMemberDeclarationStateObject(AbstractFromClauseStateObject parent, ListIterator<String> paths, String identificationVariable) {
        this(parent, paths, false, identificationVariable);
    }

    public CollectionMemberDeclarationStateObject(SimpleFromClauseStateObject parent, String collectionValuedPath) {
        super(parent);
        this.derived = true;
        this.setPath(collectionValuedPath);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    public CollectionMemberDeclarationStateObject addAs() {
        if (!this.as) {
            this.setAs(true);
        }
        return this;
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.add(this.collectionValuedPath);
        children.add(this.identificationVariable);
    }

    public CollectionValuedPathExpressionStateObject getCollectionValuedPath() {
        return this.collectionValuedPath;
    }

    @Override
    public CollectionMemberDeclaration getExpression() {
        return (CollectionMemberDeclaration)super.getExpression();
    }

    public IdentificationVariableStateObject getIdentificationVariable() {
        return this.identificationVariable;
    }

    @Override
    public IManagedType getManagedType(StateObject stateObject) {
        if (this.identificationVariable.isEquivalent(stateObject)) {
            return this.collectionValuedPath.getManagedType();
        }
        return null;
    }

    @Override
    public AbstractFromClauseStateObject getParent() {
        return (AbstractFromClauseStateObject)super.getParent();
    }

    public boolean hasAs() {
        return this.as;
    }

    public boolean hasIdentificationVariable() {
        return this.identificationVariable.hasText();
    }

    @Override
    public ListIterable<IdentificationVariableStateObject> identificationVariables() {
        return new SingleElementListIterable<IdentificationVariableStateObject>(this.identificationVariable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.collectionValuedPath = new CollectionValuedPathExpressionStateObject(this);
        this.identificationVariable = new IdentificationVariableStateObject(this);
    }

    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            CollectionMemberDeclarationStateObject declaration = (CollectionMemberDeclarationStateObject)stateObject;
            return this.as == declaration.as && this.derived == declaration.derived && this.identificationVariable.isEquivalent(declaration.identificationVariable) && this.collectionValuedPath.isEquivalent(declaration.collectionValuedPath);
        }
        return false;
    }

    public void removeAs() {
        if (this.as) {
            this.setAs(false);
        }
    }

    public void setAs(boolean as) {
        boolean oldAs = this.as;
        this.as = as;
        this.firePropertyChanged(AS_PROPERTY, oldAs, as);
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public void setExpression(CollectionMemberDeclaration expression) {
        super.setExpression(expression);
    }

    public void setIdentificationVariable(String identificationVariable) {
        this.identificationVariable.setText(identificationVariable);
    }

    public void setPath(String path) {
        this.collectionValuedPath.setPath(path);
    }

    public void setPaths(List<String> paths) {
        this.collectionValuedPath.setPaths(paths);
    }

    public void setPaths(ListIterator<String> paths) {
        this.collectionValuedPath.setPaths(paths);
    }

    public void setPaths(String ... paths) {
        this.collectionValuedPath.setPaths(paths);
    }

    public void toggleAs() {
        this.setAs(!this.as);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("IN");
        if (!this.derived) {
            writer.append('(');
        } else {
            writer.append(' ');
        }
        this.collectionValuedPath.toString(writer);
        if (!this.derived) {
            writer.append(')');
        }
        if (!this.derived) {
            writer.append(' ');
            if (this.as) {
                writer.append("AS");
                writer.append(' ');
            }
            this.identificationVariable.toString(writer);
        }
    }
}

