/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFromClause
extends AbstractExpression {
    private AbstractExpression asOfClause;
    private AbstractExpression declaration;
    private boolean hasSpace;
    private boolean hasSpaceAfterHierarchicalQueryClause;
    private boolean hasSpaceDeclaration;
    private AbstractExpression hierarchicalQueryClause;
    private String identifier;

    protected AbstractFromClause(AbstractExpression parent) {
        super(parent, "FROM");
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getDeclaration().accept(visitor);
        this.getHierarchicalQueryClause().accept(visitor);
        this.getAsOfClause().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getDeclaration());
        children.add(this.getHierarchicalQueryClause());
        children.add(this.getAsOfClause());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("FROM"));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.declaration != null) {
            children.add(this.declaration);
        }
        if (this.hasSpaceDeclaration) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hierarchicalQueryClause != null) {
            children.add(this.hierarchicalQueryClause);
        }
        if (this.hasSpaceAfterHierarchicalQueryClause) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.asOfClause != null) {
            children.add(this.asOfClause);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getDeclaration());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public abstract String declarationBNF();

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getAsOfClause() {
        if (this.asOfClause == null) {
            this.asOfClause = this.buildNullExpression();
        }
        return this.asOfClause;
    }

    public final Expression getDeclaration() {
        if (this.declaration == null) {
            this.declaration = this.buildNullExpression();
        }
        return this.declaration;
    }

    public final Expression getHierarchicalQueryClause() {
        if (this.hierarchicalQueryClause == null) {
            this.hierarchicalQueryClause = this.buildNullExpression();
        }
        return this.hierarchicalQueryClause;
    }

    public final boolean hasAsOfClause() {
        return this.asOfClause != null && !this.asOfClause.isNull();
    }

    public final boolean hasDeclaration() {
        return this.declaration != null && !this.declaration.isNull();
    }

    public final boolean hasHierarchicalQueryClause() {
        return this.hierarchicalQueryClause != null && !this.hierarchicalQueryClause.isNull();
    }

    public final boolean hasSpaceAfterDeclaration() {
        return this.hasSpaceDeclaration;
    }

    public final boolean hasSpaceAfterFrom() {
        return this.hasSpace;
    }

    public final boolean hasSpaceAfterHierarchicalQueryClause() {
        return this.hasSpaceAfterHierarchicalQueryClause;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        char character = wordParser.character();
        return wordParser.isArithmeticSymbol(character) || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("FROM");
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.declaration = this.parse(wordParser, this.declarationBNF(), tolerant);
        int count = wordParser.skipLeadingWhitespace();
        boolean bl = this.hasSpaceDeclaration = count > 0;
        if (wordParser.startsWithIdentifier("START WITH") || wordParser.startsWithIdentifier("CONNECT BY") || wordParser.startsWithIdentifier("ORDER SIBLINGS BY")) {
            this.hierarchicalQueryClause = new HierarchicalQueryClause(this);
            this.hierarchicalQueryClause.parse(wordParser, tolerant);
            count = wordParser.skipLeadingWhitespace();
            boolean bl2 = this.hasSpaceAfterHierarchicalQueryClause = count > 0;
        }
        if (wordParser.startsWithIdentifier("AS OF")) {
            this.asOfClause = new AsOfClause(this);
            this.asOfClause.parse(wordParser, tolerant);
        } else if (this.hasSpaceAfterHierarchicalQueryClause) {
            this.hasSpaceAfterHierarchicalQueryClause = false;
            wordParser.moveBackward(count);
        } else if (this.hierarchicalQueryClause == null) {
            this.hasSpaceDeclaration = false;
            wordParser.moveBackward(count);
        }
    }

    @Override
    protected boolean shouldParseWithFactoryFirst() {
        return true;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : "FROM");
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.declaration != null) {
            this.declaration.toParsedText(writer, actual);
        }
        if (this.hasSpaceDeclaration) {
            writer.append(' ');
        }
        if (this.hierarchicalQueryClause != null) {
            this.hierarchicalQueryClause.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterHierarchicalQueryClause) {
            writer.append(' ');
        }
        if (this.asOfClause != null) {
            this.asOfClause.toParsedText(writer, actual);
        }
    }
}

