/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.EclipseLinkVersion;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor();
    }

    protected FromClauseSelectStatementHelper buildFromClauseSelectStatementHelper() {
        return new FromClauseSelectStatementHelper();
    }

    protected GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new GroupByClauseCollectionHelper();
    }

    protected GroupByClauseSelectStatementHelper buildGroupByClauseSelectStatementHelper() {
        return new GroupByClauseSelectStatementHelper();
    }

    protected HavingClauseSelectStatementHelper buildHavingClauseSelectStatementHelper() {
        return new HavingClauseSelectStatementHelper();
    }

    protected OrderByClauseSelectStatementHelper buildOrderByClauseSelectStatementHelper() {
        return new OrderByClauseSelectStatementHelper();
    }

    protected TrailingCompletenessVisitor buildTrailingCompleteness() {
        return new TrailingCompletenessVisitor();
    }

    protected UnionClauseSelectStatementHelper buildUnionClauseSelectStatementHelper() {
        return new UnionClauseSelectStatementHelper();
    }

    protected WhereClauseHelper buildWhereClauseHelper() {
        return new WhereClauseHelper();
    }

    protected WhereClauseSelectStatementHelper buildWhereClauseSelectStatementHelper() {
        return new WhereClauseSelectStatementHelper();
    }

    protected UnionClauseSelectStatementHelper getUnionClauseSelectStatementHelper() {
        UnionClauseSelectStatementHelper helper = this.getHelper(UnionClauseSelectStatementHelper.class);
        if (helper == null) {
            helper = this.buildUnionClauseSelectStatementHelper();
            this.registerHelper(UnionClauseSelectStatementHelper.class, helper);
        }
        return helper;
    }

    protected boolean isJoinFetchIdentifiable() {
        EclipseLinkVersion version = EclipseLinkVersion.value(this.getGrammar().getProviderVersion());
        return version.isNewerThanOrEqual(EclipseLinkVersion.VERSION_2_4);
    }

    public void visit(AsOfClause expression) {
    }

    public void visit(CastExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            Expression scalarExpression;
            int length = identifier.length() + 1;
            if (position == length) {
                this.addAllIdentificationVariables();
                this.addAllFunctions(expression.encapsulatedExpressionBNF());
            } else if (expression.hasExpression() && this.isComplete(scalarExpression = expression.getExpression())) {
                length += this.length(scalarExpression);
                if (expression.hasSpaceAfterExpression()) {
                    if (position == ++length) {
                        this.addAllAggregates(expression.encapsulatedExpressionBNF());
                        this.proposals.addIdentifier("AS");
                    } else if (this.isPositionWithin(position, length, "AS")) {
                        this.proposals.addIdentifier("AS");
                    }
                }
            }
        }
    }

    public void visit(ConnectByClause expression) {
    }

    public void visit(DatabaseType expression) {
    }

    public void visit(ExtractExpression expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            if (expression.hasDatePart()) {
                String datePart = expression.getDatePart();
                this.isPositionWithin(position, length, datePart);
                length += datePart.length();
                if (expression.hasSpaceAfterDatePart() && position == ++length) {
                    this.addIdentifier("FROM");
                    if (!expression.hasExpression() || !expression.hasFrom()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.proposals.addIdentifier("FROM");
                    if (!expression.hasExpression()) {
                        this.addAllIdentificationVariables();
                        this.addAllFunctions(expression.encapsulatedExpressionBNF());
                    }
                }
                length += 4;
                if (expression.hasSpaceAfterFrom()) {
                    ++length;
                }
                if (position == length) {
                    this.addAllIdentificationVariables();
                    this.addAllFunctions(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    public void visit(HierarchicalQueryClause expression) {
    }

    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasExpression()) {
            int length = this.length(expression.getExpression());
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    if (expression.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    }
                } else if (position > (length += expression.getActualOrdering().length()) && expression.hasSpaceAfterOrdering()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    } else {
                        String nullOrdering = expression.getActualNullOrdering();
                        if (this.isPositionWithin(position, length, nullOrdering)) {
                            this.proposals.addIdentifier("NULLS FIRST");
                            this.proposals.addIdentifier("NULLS LAST");
                        }
                    }
                }
            }
        }
    }

    public void visit(OrderSiblingsByClause expression) {
    }

    public void visit(RegexpExpression expression) {
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += this.length(expression.getStringExpression());
            if (expression.hasSpaceAfterStringExpression()) {
                ++length;
            }
        }
        if (this.isPositionWithin(position, length, "REGEXP")) {
            this.proposals.addIdentifier("REGEXP");
        } else {
            length += 6;
            if (expression.hasSpaceAfterIdentifier()) {
                ++length;
                this.addAllIdentificationVariables();
                this.addAllFunctions("pattern_value");
            }
        }
    }

    public void visit(StartWithClause expression) {
    }

    public void visit(TableExpression expression) {
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, "TABLE")) {
            this.proposals.addIdentifier("TABLE");
        } else if (expression.hasLeftParenthesis()) {
            int length = "TABLE".length() + 1;
            String tableName = this.queryContext.literal(expression, LiteralType.STRING_LITERAL);
            int tableNameLength = tableName.length();
            if (position >= length && position <= length + tableNameLength) {
                String prefix = ExpressionTools.unquote(tableName).substring(position - length);
                this.proposals.setTableNamePrefix(prefix);
            }
        }
    }

    public void visit(TableVariableDeclaration expression) {
        TableExpression tableExpression = expression.getTableExpression();
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        int length = this.length(tableExpression);
        if (expression.hasSpaceAfterTableExpression() && this.isPositionWithin(position, ++length, "AS")) {
            this.addIdentifier("AS");
        }
    }

    public void visit(UnionClause expression) {
        String identifier;
        int position = this.getPosition(expression) - (Integer)this.corrections.peek();
        if (this.isPositionWithin(position, identifier = expression.getIdentifier())) {
            this.proposals.addIdentifier("EXCEPT");
            this.proposals.addIdentifier("INTERSECT");
            this.proposals.addIdentifier("UNION");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = identifier.length() + 1;
            if (position == length) {
                this.proposals.addIdentifier("ALL");
                if (!expression.hasAll()) {
                    this.addIdentifier("SELECT");
                }
            } else if (this.isPositionWithin(position, length, "ALL")) {
                this.addIdentifier("ALL");
            } else if (position == length && !expression.hasAll()) {
                this.proposals.addIdentifier("SELECT");
            } else {
                if (expression.hasAll()) {
                    length += 3;
                }
                if (expression.hasSpaceAfterAll() && position == ++length) {
                    this.proposals.addIdentifier("SELECT");
                }
            }
        }
    }

    protected class AppendableExpressionVisitor
    extends AbstractContentAssistVisitor.AppendableExpressionVisitor
    implements EclipseLinkExpressionVisitor {
        protected AppendableExpressionVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void visit(AsOfClause expression) {
        }

        public void visit(CastExpression expression) {
        }

        public void visit(ConnectByClause expression) {
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
        }

        public void visit(HierarchicalQueryClause expression) {
        }

        public void visit(OrderSiblingsByClause expression) {
        }

        public void visit(RegexpExpression expression) {
        }

        public void visit(StartWithClause expression) {
        }

        public void visit(TableExpression expression) {
        }

        public void visit(TableVariableDeclaration expression) {
        }

        public void visit(UnionClause expression) {
        }
    }

    protected class FromClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.FromClauseSelectStatementHelper {
        protected FromClauseSelectStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        protected void addClauseIdentifierProposals(SelectStatement expression) {
            super.addClauseIdentifierProposals(expression);
            if (!(expression.hasWhereClause() || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            }
        }
    }

    protected class GroupByClauseCollectionHelper
    extends AbstractContentAssistVisitor.GroupByClauseCollectionHelper {
        protected GroupByClauseCollectionHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void addAtTheEndOfChild(GroupByClause expression, Expression child, int index) {
        }
    }

    protected class GroupByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.GroupByClauseSelectStatementHelper {
        protected GroupByClauseSelectStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void appendNextClauseProposals(SelectStatement expression, GroupByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isGroupByComplete(clause)) && !expression.hasHavingClause() && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class HavingClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.HavingClauseSelectStatementHelper {
        protected HavingClauseSelectStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void appendNextClauseProposals(SelectStatement expression, HavingClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if ((complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) && !expression.hasOrderByClause()) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }

    protected class OrderByClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper {
        protected OrderByClauseSelectStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void appendNextClauseProposals(SelectStatement expression, OrderByClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (complete || EclipseLinkContentAssistVisitor.this.isAppendable(clause)) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }

        public UnionClauseSelectStatementHelper getNextHelper() {
            return EclipseLinkContentAssistVisitor.this.getUnionClauseSelectStatementHelper();
        }

        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }
    }

    protected class TrailingCompletenessVisitor
    extends AbstractContentAssistVisitor.TrailingCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected TrailingCompletenessVisitor() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void visit(AsOfClause expression) {
        }

        public void visit(CastExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(ConnectByClause expression) {
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(HierarchicalQueryClause expression) {
        }

        public void visit(OrderSiblingsByClause expression) {
        }

        public void visit(RegexpExpression expression) {
            this.complete = expression.hasPatternValue();
        }

        public void visit(StartWithClause expression) {
        }

        public void visit(TableExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TableVariableDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(UnionClause expression) {
            this.complete = expression.hasQuery();
            if (this.complete) {
                expression.getQuery().accept(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnionClauseSelectStatementHelper
    implements AbstractContentAssistVisitor.SelectStatementHelper<SelectStatement, UnionClause> {
        protected UnionClauseSelectStatementHelper() {
        }

        @Override
        public void addClauseProposal() {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public void appendNextClauseProposals(SelectStatement expression, UnionClause clause, int position, boolean complete) {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public UnionClause getClause(SelectStatement expression) {
            return (UnionClause)expression.getUnionClauses();
        }

        @Override
        public Expression getClauseExpression(UnionClause clause) {
            return clause.getQuery();
        }

        @Override
        public AbstractContentAssistVisitor.SelectStatementHelper<? extends AbstractSelectStatement, ? extends Expression> getNextHelper() {
            return null;
        }

        public AbstractContentAssistVisitor.OrderByClauseSelectStatementHelper getPreviousHelper() {
            return EclipseLinkContentAssistVisitor.this.getOrderByClauseSelectStatementHelper();
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasUnionClauses();
        }

        @Override
        public boolean hasClauseExpression(UnionClause clause) {
            return clause.hasQuery();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean hasSpaceBeforeClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }

        @Override
        public boolean isClauseExpressionComplete(Expression expression) {
            return false;
        }
    }

    protected class WhereClauseHelper
    extends AbstractContentAssistVisitor.WhereClauseHelper {
        protected WhereClauseHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void addAtTheEndOfExpression(WhereClause expression) {
            super.addAtTheEndOfExpression(expression);
        }
    }

    protected class WhereClauseSelectStatementHelper
    extends AbstractContentAssistVisitor.WhereClauseSelectStatementHelper {
        protected WhereClauseSelectStatementHelper() {
            super(EclipseLinkContentAssistVisitor.this);
        }

        public void appendNextClauseProposals(SelectStatement expression, WhereClause clause, int position, boolean complete) {
            super.appendNextClauseProposals(expression, clause, position, complete);
            if (!(!complete && !EclipseLinkContentAssistVisitor.this.isAppendable(clause) || expression.hasGroupByClause() || expression.hasHavingClause() || expression.hasOrderByClause())) {
                EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
                EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
            }
        }
    }
}

